/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.boot.amqp.autoconfigure.PropertiesRabbitConnectionDetails;
import org.springframework.boot.amqp.autoconfigure.RabbitConnectionDetails;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.util.Assert;

public abstract class AbstractConnectionFactoryConfigurer<T extends AbstractConnectionFactory> {
    private final RabbitProperties rabbitProperties;
    private @Nullable ConnectionNameStrategy connectionNameStrategy;
    private final RabbitConnectionDetails connectionDetails;

    protected AbstractConnectionFactoryConfigurer(RabbitProperties properties) {
        this(properties, new PropertiesRabbitConnectionDetails(properties, null));
    }

    protected AbstractConnectionFactoryConfigurer(RabbitProperties properties, RabbitConnectionDetails connectionDetails) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        Assert.notNull((Object)connectionDetails, (String)"'connectionDetails' must not be null");
        this.rabbitProperties = properties;
        this.connectionDetails = connectionDetails;
    }

    protected final @Nullable ConnectionNameStrategy getConnectionNameStrategy() {
        return this.connectionNameStrategy;
    }

    public final void setConnectionNameStrategy(@Nullable ConnectionNameStrategy connectionNameStrategy) {
        this.connectionNameStrategy = connectionNameStrategy;
    }

    public final void configure(T connectionFactory) {
        Assert.notNull(connectionFactory, (String)"'connectionFactory' must not be null");
        PropertyMapper map = PropertyMapper.get();
        String addresses = this.connectionDetails.getAddresses().stream().map(address -> address.host() + ":" + address.port()).collect(Collectors.joining(","));
        map.from((Object)addresses).to(arg_0 -> connectionFactory.setAddresses(arg_0));
        map.from(this.rabbitProperties::getAddressShuffleMode).to(arg_0 -> connectionFactory.setAddressShuffleMode(arg_0));
        map.from((Object)this.connectionNameStrategy).to(arg_0 -> connectionFactory.setConnectionNameStrategy(arg_0));
        this.configure(connectionFactory, this.rabbitProperties);
    }

    protected abstract void configure(T var1, RabbitProperties var2);
}

