/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import java.util.Iterator;
import java.util.Map;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.database.orm.JpaQueryProvider;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JpaCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private String queryString;
    private JpaQueryProvider queryProvider;
    private Map<String, Object> parameterValues;
    private Iterator<T> iterator;

    public JpaCursorItemReader() {
        this.setName(ClassUtils.getShortName(JpaCursorItemReader.class));
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setQueryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.entityManagerFactory != null ? 1 : 0) != 0, (String)"EntityManagerFactory is required");
        if (this.queryProvider == null) {
            Assert.state((boolean)StringUtils.hasLength((String)this.queryString), (String)"Query string is required when queryProvider is null");
        }
    }

    @Override
    protected void doOpen() throws Exception {
        this.entityManager = this.entityManagerFactory.createEntityManager();
        if (this.entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to create an EntityManager");
        }
        if (this.queryProvider != null) {
            this.queryProvider.setEntityManager(this.entityManager);
        }
        Query query = this.createQuery();
        if (this.parameterValues != null) {
            this.parameterValues.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        }
        this.iterator = query.getResultStream().iterator();
    }

    private Query createQuery() {
        if (this.queryProvider == null) {
            return this.entityManager.createQuery(this.queryString);
        }
        return this.queryProvider.createQuery();
    }

    @Override
    protected T doRead() {
        return this.iterator.hasNext() ? (T)this.iterator.next() : null;
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.entityManager.clear();
    }

    @Override
    protected void doClose() {
        if (this.entityManager != null) {
            this.entityManager.close();
        }
    }
}

