/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@Deprecated(since="5.0", forRemoval=true)
public class HibernateItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(HibernateItemWriter.class);
    private SessionFactory sessionFactory;
    private boolean clearSession = true;

    public void setClearSession(boolean clearSession) {
        this.clearSession = clearSession;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory must be provided");
    }

    @Override
    public void write(Chunk<? extends T> items) {
        this.doWrite(this.sessionFactory, items);
        this.sessionFactory.getCurrentSession().flush();
        if (this.clearSession) {
            this.sessionFactory.getCurrentSession().clear();
        }
    }

    protected void doWrite(SessionFactory sessionFactory, Chunk<? extends T> items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing to Hibernate with " + items.size() + " items."));
        }
        Session currentSession = sessionFactory.getCurrentSession();
        if (!items.isEmpty()) {
            long saveOrUpdateCount = 0L;
            for (Object item : items) {
                if (currentSession.contains(item)) continue;
                currentSession.saveOrUpdate(item);
                ++saveOrUpdateCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(saveOrUpdateCount + " entities saved/updated."));
                logger.debug((Object)((long)items.size() - saveOrUpdateCount + " entities found in session."));
            }
        }
    }
}

