/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.UUID;
import org.springframework.amqp.core.Correlation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.SettableListenableFuture;

public class CorrelationData
implements Correlation {
    private final SettableListenableFuture<Confirm> future = new SettableListenableFuture();
    private volatile String id;
    private volatile ReturnedMessage returnedMessage;

    public CorrelationData() {
        this.id = UUID.randomUUID().toString();
    }

    public CorrelationData(String id) {
        Assert.notNull((Object)id, (String)"'id' cannot be null and must be unique");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.notNull((Object)id, (String)"'id' cannot be null and must be unique");
        this.id = id;
    }

    public SettableListenableFuture<Confirm> getFuture() {
        return this.future;
    }

    @Deprecated
    @Nullable
    public Message getReturnedMessage() {
        if (this.returnedMessage == null) {
            return null;
        }
        return this.returnedMessage.getMessage();
    }

    @Deprecated
    public void setReturnedMessage(Message returnedMessage) {
        this.returnedMessage = new ReturnedMessage(returnedMessage, 0, "not available", "not available", "not available");
    }

    @Nullable
    public ReturnedMessage getReturned() {
        return this.returnedMessage;
    }

    public void setReturned(ReturnedMessage returned) {
        this.returnedMessage = returned;
    }

    public String toString() {
        return "CorrelationData [id=" + this.id + "]";
    }

    public static class Confirm {
        private final boolean ack;
        private final String reason;

        public Confirm(boolean ack, @Nullable String reason) {
            this.ack = ack;
            this.reason = reason;
        }

        public boolean isAck() {
            return this.ack;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "Confirm [ack=" + this.ack + (this.reason != null ? ", reason=" + this.reason : "") + "]";
        }
    }
}

