/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.springframework.amqp.support.postprocessor.AbstractDeflaterPostProcessor;

public class DeflaterPostProcessor
extends AbstractDeflaterPostProcessor {
    public DeflaterPostProcessor() {
    }

    public DeflaterPostProcessor(boolean autoDecompress) {
        super(autoDecompress);
    }

    @Override
    protected OutputStream getCompressorStream(OutputStream zipped) throws IOException {
        return new SettableLevelDeflaterOutputStream(zipped, this.getLevel());
    }

    @Override
    protected String getEncoding() {
        return "deflate";
    }

    private static final class SettableLevelDeflaterOutputStream
    extends DeflaterOutputStream {
        SettableLevelDeflaterOutputStream(OutputStream out, int level) {
            super(out);
            this.def.setLevel(level);
        }
    }
}

