/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.FunctionResponse;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.PartMaker;
import com.google.cloud.vertexai.generativeai.ResponseStream;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.model.tool.internal.ToolCallReactiveContextHolder;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatOptions;
import org.springframework.ai.vertexai.gemini.api.VertexAiGeminiApi;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiConstants;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiSafetySetting;
import org.springframework.ai.vertexai.gemini.schema.VertexAiSchemaConverter;
import org.springframework.ai.vertexai.gemini.schema.VertexToolCallingManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public class VertexAiGeminiChatModel
implements org.springframework.ai.chat.model.ChatModel,
DisposableBean {
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VertexAI vertexAI;
    private final VertexAiGeminiChatOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final GenerationConfig generationConfig;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(vertexAI, defaultOptions, toolCallingManager, retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)vertexAI, (String)"VertexAI must not be null");
        Assert.notNull((Object)defaultOptions, (String)"VertexAiGeminiChatOptions must not be null");
        Assert.notNull((Object)defaultOptions.getModel(), (String)"VertexAiGeminiChatOptions.modelName must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)toolCallingManager, (String)"ToolCallingManager must not be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"ToolExecutionEligibilityPredicate must not be null");
        this.vertexAI = vertexAI;
        this.defaultOptions = defaultOptions;
        this.generationConfig = this.toGenerationConfig(defaultOptions);
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
        this.toolCallingManager = toolCallingManager instanceof VertexToolCallingManager ? toolCallingManager : new VertexToolCallingManager(toolCallingManager);
    }

    private static GeminiMessageType toGeminiMessageType(@NonNull MessageType type) {
        Assert.notNull((Object)type, (String)"Message type must not be null");
        return switch (type) {
            case MessageType.SYSTEM, MessageType.USER, MessageType.TOOL -> GeminiMessageType.USER;
            case MessageType.ASSISTANT -> GeminiMessageType.MODEL;
            default -> throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(type));
        };
    }

    static List<Part> messageToGeminiParts(Message message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (systemMessage.getText() != null) {
                parts.add(Part.newBuilder().setText(systemMessage.getText()).build());
            }
            return parts;
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (userMessage.getText() != null) {
                parts.add(Part.newBuilder().setText(userMessage.getText()).build());
            }
            parts.addAll(VertexAiGeminiChatModel.mediaToParts(userMessage.getMedia()));
            return parts;
        }
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (StringUtils.hasText((String)assistantMessage.getText())) {
                parts.add(Part.newBuilder().setText(assistantMessage.getText()).build());
            }
            if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                parts.addAll(assistantMessage.getToolCalls().stream().map(toolCall -> Part.newBuilder().setFunctionCall(FunctionCall.newBuilder().setName(toolCall.name()).setArgs(VertexAiGeminiChatModel.jsonToStruct(toolCall.arguments())).build()).build()).toList());
            }
            return parts;
        }
        if (message instanceof ToolResponseMessage) {
            ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
            return toolResponseMessage.getResponses().stream().map(response -> Part.newBuilder().setFunctionResponse(FunctionResponse.newBuilder().setName(response.name()).setResponse(VertexAiGeminiChatModel.jsonToStruct(response.responseData())).build()).build()).toList();
        }
        throw new IllegalArgumentException("Gemini doesn't support message type: " + String.valueOf(message.getClass()));
    }

    private static List<Part> mediaToParts(Collection<Media> media) {
        ArrayList<Part> parts = new ArrayList<Part>();
        List<Part> mediaParts = media.stream().map(mediaData -> PartMaker.fromMimeTypeAndData((String)mediaData.getMimeType().toString(), (Object)mediaData.getData())).toList();
        if (!CollectionUtils.isEmpty(mediaParts)) {
            parts.addAll(mediaParts);
        }
        return parts;
    }

    private static String structToJson(Struct struct) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)struct);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Struct jsonToStruct(String json) {
        try {
            JsonNode rootNode = ModelOptionsUtils.OBJECT_MAPPER.readTree(json);
            Struct.Builder structBuilder = Struct.newBuilder();
            if (rootNode.isTextual()) {
                structBuilder.putFields("result", Value.newBuilder().setStringValue(json).build());
            } else if (rootNode.isArray()) {
                ArrayList<Value> values = new ArrayList<Value>();
                for (JsonNode element : rootNode) {
                    String elementJson = element.toString();
                    Struct.Builder elementBuilder = Struct.newBuilder();
                    JsonFormat.parser().ignoringUnknownFields().merge(elementJson, (Message.Builder)elementBuilder);
                    values.add(Value.newBuilder().setStructValue(elementBuilder.build()).build());
                }
                structBuilder.putFields("items", Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(values).build()).build());
            } else {
                JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)structBuilder);
            }
            return structBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    private ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(VertexAiGeminiConstants.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> (ChatResponse)this.retryTemplate.execute(context -> {
            GeminiRequest geminiRequest = this.createGeminiRequest(prompt);
            GenerateContentResponse generateContentResponse = this.getContentResponse(geminiRequest);
            List generations = generateContentResponse.getCandidatesList().stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
            GenerateContentResponse.UsageMetadata usage = generateContentResponse.getUsageMetadata();
            DefaultUsage currentUsage = usage != null ? new DefaultUsage(Integer.valueOf(usage.getPromptTokenCount()), Integer.valueOf(usage.getCandidatesTokenCount())) : new EmptyUsage();
            Usage cumulativeUsage = UsageCalculator.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(cumulativeUsage));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        }));
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        VertexAiGeminiChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, VertexAiGeminiChatOptions.class);
            } else {
                runtimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiGeminiChatOptions.class);
            }
        }
        VertexAiGeminiChatOptions requestOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, VertexAiGeminiChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
            requestOptions.setGoogleSearchRetrieval((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getGoogleSearchRetrieval(), (Object)this.defaultOptions.getGoogleSearchRetrieval()));
            requestOptions.setSafetySettings((List)ModelOptionsUtils.mergeOption(runtimeOptions.getSafetySettings(), this.defaultOptions.getSafetySettings()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
            requestOptions.setGoogleSearchRetrieval(this.defaultOptions.getGoogleSearchRetrieval());
            requestOptions.setSafetySettings(this.defaultOptions.getSafetySettings());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(VertexAiGeminiConstants.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            GeminiRequest request = this.createGeminiRequest(prompt);
            try {
                ResponseStream responseStream = request.model.generateContentStream(request.contents);
                Flux chatResponseFlux = Flux.fromStream((Stream)responseStream.stream()).switchMap(response -> {
                    List generations = response.getCandidatesList().stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
                    GenerateContentResponse.UsageMetadata usage = response.getUsageMetadata();
                    EmptyUsage currentUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
                    Usage cumulativeUsage = UsageCalculator.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
                    ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(cumulativeUsage));
                    return Flux.just((Object)chatResponse);
                });
                Flux flux = chatResponseFlux.flatMap(response -> {
                    if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
                        return Flux.deferContextual(ctx -> {
                            ToolExecutionResult toolExecutionResult;
                            try {
                                ToolCallReactiveContextHolder.setContext((ContextView)ctx);
                                toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
                            }
                            finally {
                                ToolCallReactiveContextHolder.clearContext();
                            }
                            if (toolExecutionResult.returnDirect()) {
                                return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                            }
                            return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)response);
                        }).subscribeOn(Schedulers.boundedElastic());
                    }
                    return Flux.just((Object)response);
                }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate content", e);
            }
        });
    }

    protected List<Generation> responseCandidateToGeneration(Candidate candidate) {
        int candidateIndex = candidate.getIndex();
        Candidate.FinishReason candidateFinishReason = candidate.getFinishReason();
        List<VertexAiGeminiApi.LogProbs.TopContent> topCandidates = candidate.getLogprobsResult().getTopCandidatesList().stream().filter(topCandidate -> !topCandidate.getCandidatesList().isEmpty()).map(topCandidate -> new VertexAiGeminiApi.LogProbs.TopContent(topCandidate.getCandidatesList().stream().map(c -> new VertexAiGeminiApi.LogProbs.Content(c.getToken(), Float.valueOf(c.getLogProbability()), c.getTokenId())).toList())).toList();
        List<VertexAiGeminiApi.LogProbs.Content> chosenCandidates = candidate.getLogprobsResult().getChosenCandidatesList().stream().map(c -> new VertexAiGeminiApi.LogProbs.Content(c.getToken(), Float.valueOf(c.getLogProbability()), c.getTokenId())).toList();
        VertexAiGeminiApi.LogProbs logprobs = new VertexAiGeminiApi.LogProbs(candidate.getAvgLogprobs(), topCandidates, chosenCandidates);
        Map<String, VertexAiGeminiApi.LogProbs> messageMetadata = Map.of("candidateIndex", candidateIndex, "finishReason", candidateFinishReason, "logprobs", logprobs);
        ChatGenerationMetadata chatGenerationMetadata = ChatGenerationMetadata.builder().finishReason(candidateFinishReason.name()).build();
        List parts = candidate.getContent().getPartsList();
        List<AssistantMessage.ToolCall> assistantToolCalls = parts.stream().filter(Part::hasFunctionCall).map(part -> {
            FunctionCall functionCall = part.getFunctionCall();
            String functionName = functionCall.getName();
            String functionArguments = VertexAiGeminiChatModel.structToJson(functionCall.getArgs());
            return new AssistantMessage.ToolCall("", "function", functionName, functionArguments);
        }).toList();
        String text = parts.stream().filter(part -> part.hasText() && !part.getText().isEmpty()).map(Part::getText).collect(Collectors.joining(" "));
        AssistantMessage assistantMessage = AssistantMessage.builder().content(text).properties(messageMetadata).toolCalls(assistantToolCalls).build();
        return List.of(new Generation(assistantMessage, chatGenerationMetadata));
    }

    private ChatResponseMetadata toChatResponseMetadata(Usage usage) {
        return ChatResponseMetadata.builder().usage(usage).build();
    }

    private DefaultUsage getDefaultUsage(GenerateContentResponse.UsageMetadata usageMetadata) {
        return new DefaultUsage(Integer.valueOf(usageMetadata.getPromptTokenCount()), Integer.valueOf(usageMetadata.getCandidatesTokenCount()), Integer.valueOf(usageMetadata.getTotalTokenCount()), (Object)usageMetadata);
    }

    private VertexAiGeminiChatOptions vertexAiGeminiChatOptions(Prompt prompt) {
        VertexAiGeminiChatOptions updatedRuntimeOptions = VertexAiGeminiChatOptions.builder().build();
        if (prompt.getOptions() != null) {
            updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiGeminiChatOptions.class);
        }
        updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)this.defaultOptions, VertexAiGeminiChatOptions.class);
        return updatedRuntimeOptions;
    }

    GeminiRequest createGeminiRequest(Prompt prompt) {
        VertexAiGeminiChatOptions options;
        ChatOptions chatOptions;
        VertexAiGeminiChatOptions requestOptions = (VertexAiGeminiChatOptions)prompt.getOptions();
        GenerativeModel.Builder generativeModelBuilder = new GenerativeModel.Builder().setVertexAi(this.vertexAI).setSafetySettings(this.toGeminiSafetySettings(requestOptions.getSafetySettings()));
        if (requestOptions.getModel() != null) {
            generativeModelBuilder.setModelName(requestOptions.getModel());
        } else {
            generativeModelBuilder.setModelName(this.defaultOptions.getModel());
        }
        GenerationConfig generationConfig = this.generationConfig;
        if (requestOptions != null) {
            generationConfig = this.toGenerationConfig(requestOptions);
        }
        ArrayList<Tool> tools = new ArrayList<Tool>();
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            List<FunctionDeclaration> functionDeclarations = toolDefinitions.stream().map(toolDefinition -> FunctionDeclaration.newBuilder().setName(toolDefinition.name()).setDescription(toolDefinition.description()).setParameters(VertexAiSchemaConverter.fromOpenApiSchema(toolDefinition.inputSchema())).build()).toList();
            tools.add(Tool.newBuilder().addAllFunctionDeclarations(functionDeclarations).build());
        }
        if ((chatOptions = prompt.getOptions()) instanceof VertexAiGeminiChatOptions && (options = (VertexAiGeminiChatOptions)chatOptions).getGoogleSearchRetrieval().booleanValue()) {
            Tool.GoogleSearch googleSearch = Tool.GoogleSearch.newBuilder().getDefaultInstanceForType();
            Tool googleSearchRetrievalTool = Tool.newBuilder().setGoogleSearch(googleSearch).build();
            tools.add(googleSearchRetrievalTool);
        }
        if (!CollectionUtils.isEmpty(tools)) {
            generativeModelBuilder.setTools(tools);
        }
        if (!CollectionUtils.isEmpty(requestOptions.getSafetySettings())) {
            generativeModelBuilder.setSafetySettings(this.toGeminiSafetySettings(requestOptions.getSafetySettings()));
        }
        generativeModelBuilder.setGenerationConfig(generationConfig);
        GenerativeModel generativeModel = generativeModelBuilder.build();
        List<Content> contents = this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).toList());
        if (!CollectionUtils.isEmpty(contents)) {
            Assert.isTrue((contents.size() <= 1 ? 1 : 0) != 0, (String)"Only one system message is allowed in the prompt");
            generativeModel = generativeModel.withSystemInstruction(contents.get(0));
        }
        return new GeminiRequest(this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() != MessageType.SYSTEM).toList()), generativeModel);
    }

    private GenerationConfig toGenerationConfig(VertexAiGeminiChatOptions options) {
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (options.getTemperature() != null) {
            generationConfigBuilder.setTemperature(options.getTemperature().floatValue());
        }
        if (options.getMaxOutputTokens() != null) {
            generationConfigBuilder.setMaxOutputTokens(options.getMaxOutputTokens().intValue());
        }
        if (options.getTopK() != null) {
            generationConfigBuilder.setTopK((float)options.getTopK().intValue());
        }
        if (options.getTopP() != null) {
            generationConfigBuilder.setTopP(options.getTopP().floatValue());
        }
        if (options.getCandidateCount() != null) {
            generationConfigBuilder.setCandidateCount(options.getCandidateCount().intValue());
        }
        if (options.getStopSequences() != null) {
            generationConfigBuilder.addAllStopSequences(options.getStopSequences());
        }
        if (options.getResponseMimeType() != null) {
            generationConfigBuilder.setResponseMimeType(options.getResponseMimeType());
        }
        if (options.getResponseSchema() != null) {
            generationConfigBuilder.setResponseSchema(VertexAiSchemaConverter.fromOpenApiSchema(options.getResponseSchema()));
        }
        if (options.getFrequencyPenalty() != null) {
            generationConfigBuilder.setFrequencyPenalty(options.getFrequencyPenalty().floatValue());
        }
        if (options.getPresencePenalty() != null) {
            generationConfigBuilder.setPresencePenalty(options.getPresencePenalty().floatValue());
        }
        if (options.getLogprobs() != null) {
            generationConfigBuilder.setLogprobs(options.getLogprobs().intValue());
        }
        generationConfigBuilder.setResponseLogprobs(options.getResponseLogprobs());
        return generationConfigBuilder.build();
    }

    private List<Content> toGeminiContent(List<Message> instructions) {
        List<Content> contents = instructions.stream().map(message -> Content.newBuilder().setRole(VertexAiGeminiChatModel.toGeminiMessageType(message.getMessageType()).getValue()).addAllParts(VertexAiGeminiChatModel.messageToGeminiParts(message)).build()).toList();
        return contents;
    }

    private List<SafetySetting> toGeminiSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
        return safetySettings.stream().map(safetySetting -> SafetySetting.newBuilder().setCategoryValue(safetySetting.getCategory().getValue()).setThresholdValue(safetySetting.getThreshold().getValue()).setMethodValue(safetySetting.getMethod().getValue()).build()).toList();
    }

    GenerateContentResponse getContentResponse(GeminiRequest request) {
        try {
            return request.model.generateContent(request.contents);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate content", e);
        }
    }

    public ChatOptions getDefaultOptions() {
        return VertexAiGeminiChatOptions.fromOptions(this.defaultOptions);
    }

    public void destroy() throws Exception {
        if (this.vertexAI != null) {
            this.vertexAI.close();
        }
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum GeminiMessageType {
        USER("user"),
        MODEL("model");

        public final String value;

        private GeminiMessageType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record GeminiRequest(List<Content> contents, GenerativeModel model) {
    }

    public static final class Builder {
        private VertexAI vertexAI;
        private VertexAiGeminiChatOptions defaultOptions = VertexAiGeminiChatOptions.builder().temperature(0.7).topP(1.0).model(ChatModel.GEMINI_2_0_FLASH).build();
        private ToolCallingManager toolCallingManager;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder vertexAI(VertexAI vertexAI) {
            this.vertexAI = vertexAI;
            return this;
        }

        public Builder defaultOptions(VertexAiGeminiChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public VertexAiGeminiChatModel build() {
            if (this.toolCallingManager != null) {
                return new VertexAiGeminiChatModel(this.vertexAI, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            return new VertexAiGeminiChatModel(this.vertexAI, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        GEMINI_1_5_PRO("gemini-1.5-pro-002"),
        GEMINI_1_5_FLASH("gemini-1.5-flash-002"),
        GEMINI_2_0_FLASH("gemini-2.0-flash"),
        GEMINI_2_0_FLASH_LIGHT("gemini-2.0-flash-lite"),
        GEMINI_2_5_PRO("gemini-2.5-pro-preview-05-06"),
        GEMINI_2_5_FLASH("gemini-2.5-flash-preview-04-17");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }
}

