/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.server.McpStatelessSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerStdioDisabledCondition;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

@AutoConfiguration(afterName={"org.springframework.ai.mcp.server.common.autoconfigure.annotations.StatelessServerSpecificationFactoryAutoConfiguration", "org.springframework.ai.mcp.server.common.autoconfigure.StatelessToolCallbackConverterAutoConfiguration", "org.springframework.ai.mcp.server.autoconfigure.McpServerStatelessWebFluxAutoConfiguration", "org.springframework.ai.mcp.server.autoconfigure.McpServerStatelessWebMvcAutoConfiguration"})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpServerProperties.class})
@Conditional(value={McpServerStdioDisabledCondition.class, EnabledStatelessServerCondition.class})
public class McpServerStatelessAutoConfiguration {
    private static final LogAccessor logger = new LogAccessor(McpServerStatelessAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public McpSchema.ServerCapabilities.Builder capabilitiesBuilder() {
        return McpSchema.ServerCapabilities.builder();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public McpStatelessSyncServer mcpStatelessSyncServer(McpStatelessServerTransport statelessTransport, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpStatelessServerFeatures.SyncToolSpecification>> tools, ObjectProvider<List<McpStatelessServerFeatures.SyncResourceSpecification>> resources, ObjectProvider<List<McpStatelessServerFeatures.SyncResourceTemplateSpecification>> resourceTemplates, ObjectProvider<List<McpStatelessServerFeatures.SyncPromptSpecification>> prompts, ObjectProvider<List<McpStatelessServerFeatures.SyncCompletionSpecification>> completions, Environment environment) {
        List resourceSpecifications;
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.StatelessSyncSpecification serverBuilder = McpServer.sync((McpStatelessServerTransport)statelessTransport).serverInfo(serverInfo);
        if (serverProperties.getCapabilities().isTool()) {
            capabilitiesBuilder.tools(Boolean.valueOf(false));
            ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
            if (!CollectionUtils.isEmpty(toolSpecifications)) {
                serverBuilder.tools(toolSpecifications);
                logger.info((CharSequence)("Registered tools: " + toolSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(false));
            resourceSpecifications = resources.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceSpecifications)) {
                serverBuilder.resources(resourceSpecifications);
                logger.info((CharSequence)("Registered resources: " + resourceSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(false));
            resourceSpecifications = resourceTemplates.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceSpecifications)) {
                serverBuilder.resourceTemplates(resourceSpecifications);
                logger.info((CharSequence)("Registered resource templates: " + resourceSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isPrompt()) {
            capabilitiesBuilder.prompts(Boolean.valueOf(false));
            List promptSpecifications = prompts.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(promptSpecifications)) {
                serverBuilder.prompts(promptSpecifications);
                logger.info((CharSequence)("Registered prompts: " + promptSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isCompletion()) {
            logger.info((CharSequence)"Enable completions capabilities");
            capabilitiesBuilder.completions();
            List completionSpecifications = completions.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(completionSpecifications)) {
                serverBuilder.completions(completionSpecifications);
                logger.info((CharSequence)("Registered completions: " + completionSpecifications.size()));
            }
        }
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        serverBuilder.requestTimeout(serverProperties.getRequestTimeout());
        if (environment instanceof StandardServletEnvironment) {
            serverBuilder.immediateExecution(true);
        }
        return serverBuilder.build();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public McpStatelessAsyncServer mcpStatelessAsyncServer(McpStatelessServerTransport statelessTransport, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpStatelessServerFeatures.AsyncToolSpecification>> tools, ObjectProvider<List<McpStatelessServerFeatures.AsyncResourceSpecification>> resources, ObjectProvider<List<McpStatelessServerFeatures.AsyncResourceTemplateSpecification>> resourceTemplates, ObjectProvider<List<McpStatelessServerFeatures.AsyncPromptSpecification>> prompts, ObjectProvider<List<McpStatelessServerFeatures.AsyncCompletionSpecification>> completions) {
        List resourceSpecifications;
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.StatelessAsyncSpecification serverBuilder = McpServer.async((McpStatelessServerTransport)statelessTransport).serverInfo(serverInfo);
        if (serverProperties.getCapabilities().isTool()) {
            ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
            capabilitiesBuilder.tools(Boolean.valueOf(false));
            if (!CollectionUtils.isEmpty(toolSpecifications)) {
                serverBuilder.tools(toolSpecifications);
                logger.info((CharSequence)("Registered tools: " + toolSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(false));
            resourceSpecifications = resources.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceSpecifications)) {
                serverBuilder.resources(resourceSpecifications);
                logger.info((CharSequence)("Registered resources: " + resourceSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(false));
            resourceSpecifications = resourceTemplates.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceSpecifications)) {
                serverBuilder.resourceTemplates(resourceSpecifications);
                logger.info((CharSequence)("Registered resource templates: " + resourceSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isPrompt()) {
            capabilitiesBuilder.prompts(Boolean.valueOf(false));
            List promptSpecifications = prompts.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(promptSpecifications)) {
                serverBuilder.prompts(promptSpecifications);
                logger.info((CharSequence)("Registered prompts: " + promptSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isCompletion()) {
            logger.info((CharSequence)"Enable completions capabilities");
            capabilitiesBuilder.completions();
            List completionSpecifications = completions.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(completionSpecifications)) {
                serverBuilder.completions(completionSpecifications);
                logger.info((CharSequence)("Registered completions: " + completionSpecifications.size()));
            }
        }
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        serverBuilder.requestTimeout(serverProperties.getRequestTimeout());
        return serverBuilder.build();
    }

    public static class EnabledStatelessServerCondition
    extends AllNestedConditions {
        public EnabledStatelessServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"protocol"}, havingValue="STATELESS", matchIfMissing=false)
        static class StatelessEnabledCondition {
            StatelessEnabledCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class McpServerEnabledCondition {
            McpServerEnabledCondition() {
            }
        }
    }
}

