/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class SwaggerWelcomeWebMvc
extends SwaggerWelcomeCommon {
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;
    private String pathPrefix;
    private final SpringWebProvider springWebProvider;

    public SwaggerWelcomeWebMvc(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, SpringWebProvider springWebProvider) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.springWebProvider = springWebProvider;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        return super.redirectToUi(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = (String)contextPath + this.mvcServletPath;
        }
        return super.buildUrl((String)contextPath, docsUrl);
    }

    protected String buildApiDocUrl() {
        return this.buildUrlWithContextPath(this.springDocConfigProperties.getApiDocs().getPath());
    }

    protected String buildUrlWithContextPath(String swaggerUiUrl) {
        if (this.pathPrefix == null) {
            this.pathPrefix = this.springWebProvider.findPathPrefix(this.springDocConfigProperties);
        }
        return this.buildUrl(this.contextPath + this.pathPrefix, swaggerUiUrl);
    }

    protected String buildSwaggerConfigUrl() {
        return this.apiDocsUrl + "/swagger-config";
    }
}

