/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.security.server.oauth2.metadata;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Consumer;
import org.springaicommunity.mcp.security.server.oauth2.metadata.OAuth2ProtectedResourceMetadata;
import org.springaicommunity.mcp.security.server.oauth2.metadata.ResourceIdentifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class OAuth2ProtectedResourceMetadataEndpointFilter
extends OncePerRequestFilter {
    private static final HttpMessageConverter<Object> JSON_MESSAGE_CONVERTER = new MappingJackson2HttpMessageConverter();
    private static final String OAUTH2_PROTECTED_RESOURCE_METADATA_ENDPOINT_URI = "/.well-known/oauth-protected-resource/**";
    private final RequestMatcher requestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/.well-known/oauth-protected-resource/**");
    private final ResourceIdentifier resourceIdentifier;
    private Consumer<OAuth2ProtectedResourceMetadata.Builder> protectedResourceMetadataCustomizer = protectedResourceMetadata -> {};

    public OAuth2ProtectedResourceMetadataEndpointFilter(ResourceIdentifier resourceIdentifier) {
        Assert.notNull((Object)resourceIdentifier, (String)"resourceIdentifier cannot be null");
        this.resourceIdentifier = resourceIdentifier;
    }

    public void setProtectedResourceMetadataCustomizer(Consumer<OAuth2ProtectedResourceMetadata.Builder> protectedResourceMetadataCustomizer) {
        Assert.notNull(protectedResourceMetadataCustomizer, (String)"protectedResourceMetadataCustomizer cannot be null");
        this.protectedResourceMetadataCustomizer = protectedResourceMetadataCustomizer;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OAuth2ProtectedResourceMetadata.Builder builder = OAuth2ProtectedResourceMetadata.builder().resource(this.resourceIdentifier.getResource());
        this.protectedResourceMetadataCustomizer.accept(builder);
        OAuth2ProtectedResourceMetadata protectedResourceMetadata = builder.build();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        JSON_MESSAGE_CONVERTER.write(protectedResourceMetadata.getClaims(), MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
    }
}

