/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.security.server.config;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springaicommunity.mcp.security.server.oauth2.authentication.BearerResourceMetadataTokenAuthenticationEntryPoint;
import org.springaicommunity.mcp.security.server.oauth2.jwt.JwtResourceValidator;
import org.springaicommunity.mcp.security.server.oauth2.metadata.OAuth2ProtectedResourceMetadata;
import org.springaicommunity.mcp.security.server.oauth2.metadata.OAuth2ProtectedResourceMetadataEndpointFilter;
import org.springaicommunity.mcp.security.server.oauth2.metadata.ResourceIdentifier;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.Assert;

public class McpServerOAuth2Configurer
extends AbstractHttpConfigurer<McpServerOAuth2Configurer, HttpSecurity> {
    private String issuerUri = null;
    private final List<String> scopes = new ArrayList<String>();
    private String bearerMethod = "header";
    private String resourceName = "Spring MCP Resource Server";
    private Consumer<OAuth2ProtectedResourceMetadata.Builder> customizer = null;
    private ResourceIdentifier resourceIdentifier = new ResourceIdentifier("/mcp");
    private boolean validateAudienceClaim = false;

    public McpServerOAuth2Configurer authorizationServer(String issuerUri) {
        this.issuerUri = issuerUri;
        return this;
    }

    public McpServerOAuth2Configurer scope(String scope) {
        this.scopes.add(scope);
        return this;
    }

    public McpServerOAuth2Configurer bearerMethod(String bearerMethod) {
        this.bearerMethod = bearerMethod;
        return this;
    }

    public McpServerOAuth2Configurer resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public McpServerOAuth2Configurer resourcePath(String resourceIdentifier) {
        this.resourceIdentifier = new ResourceIdentifier(resourceIdentifier);
        return this;
    }

    public McpServerOAuth2Configurer protectedResourceMetadataCustomizer(Consumer<OAuth2ProtectedResourceMetadata.Builder> customizer) {
        this.customizer = customizer;
        return this;
    }

    public McpServerOAuth2Configurer validateAudienceClaim(boolean validateAudienceClaim) {
        this.validateAudienceClaim = validateAudienceClaim;
        return this;
    }

    public void init(HttpSecurity http) throws Exception {
        Assert.notNull((Object)this.issuerUri, (String)"authorizationServer cannot be null");
        Assert.notNull((Object)this.resourceIdentifier, (String)"resourceIdentifier cannot be null");
        OAuth2ProtectedResourceMetadataEndpointFilter protectedResourceMetadataEndpointFilter = new OAuth2ProtectedResourceMetadataEndpointFilter(this.resourceIdentifier);
        protectedResourceMetadataEndpointFilter.setProtectedResourceMetadataCustomizer(this.getProtectedMetadataCustomizer());
        BearerResourceMetadataTokenAuthenticationEntryPoint entryPoint = new BearerResourceMetadataTokenAuthenticationEntryPoint(this.resourceIdentifier);
        http.oauth2ResourceServer(resourceServer -> {
            resourceServer.jwt(jwt -> jwt.decoder(this.getJwtDecoder(http)));
            resourceServer.authenticationEntryPoint((AuthenticationEntryPoint)entryPoint);
        }).addFilterBefore((Filter)protectedResourceMetadataEndpointFilter, AbstractPreAuthenticatedProcessingFilter.class);
    }

    private JwtDecoder getJwtDecoder(HttpSecurity http) {
        NimbusJwtDecoder decoder = NimbusJwtDecoder.withIssuerLocation((String)this.issuerUri).build();
        if (this.validateAudienceClaim) {
            OAuth2TokenValidator jwtValidator = JwtValidators.createDefaultWithValidators((OAuth2TokenValidator[])new OAuth2TokenValidator[]{new JwtResourceValidator(this.resourceIdentifier)});
            decoder.setJwtValidator(jwtValidator);
        }
        return decoder;
    }

    private Consumer<OAuth2ProtectedResourceMetadata.Builder> getProtectedMetadataCustomizer() {
        if (this.customizer != null) {
            return this.customizer;
        }
        return protectedMetadata -> protectedMetadata.authorizationServer(this.issuerUri).resourceName(this.resourceName).bearerMethod(this.bearerMethod);
    }

    public static McpServerOAuth2Configurer mcpServerOAuth2() {
        return new McpServerOAuth2Configurer();
    }
}

