/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.context;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.context.DefaultElicitationSpec;
import org.springaicommunity.mcp.context.DefaultLoggingSpec;
import org.springaicommunity.mcp.context.DefaultProgressSpec;
import org.springaicommunity.mcp.context.DefaultSamplingSpec;
import org.springaicommunity.mcp.context.McpAsyncRequestContext;
import org.springaicommunity.mcp.context.McpRequestContextTypes;
import org.springaicommunity.mcp.context.StructuredElicitResult;
import org.springaicommunity.mcp.method.tool.utils.ConcurrentReferenceHashMap;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;
import org.springaicommunity.mcp.method.tool.utils.JsonSchemaGenerator;
import reactor.core.publisher.Mono;

public class DefaultMcpAsyncRequestContext
implements McpAsyncRequestContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpAsyncRequestContext.class);
    private static final Map<Type, Map<String, Object>> typeSchemaCache = new ConcurrentReferenceHashMap<Type, Map<String, Object>>(256);
    private static TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private final McpSchema.Request request;
    private final McpAsyncServerExchange exchange;

    private DefaultMcpAsyncRequestContext(McpSchema.Request request, McpAsyncServerExchange exchange) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)exchange, (String)"Exchange must not be null");
        this.request = request;
        this.exchange = exchange;
    }

    @Override
    public Mono<Boolean> rootsEnabled() {
        return Mono.just((Object)(this.exchange.getClientCapabilities() != null && this.exchange.getClientCapabilities().roots() != null ? 1 : 0));
    }

    @Override
    public Mono<McpSchema.ListRootsResult> roots() {
        return this.rootsEnabled().flatMap(enabled -> {
            if (!enabled.booleanValue()) {
                return Mono.error((Throwable)new IllegalStateException("Roots not supported by the client: " + String.valueOf(this.exchange.getClientInfo())));
            }
            return this.exchange.listRoots();
        });
    }

    @Override
    public Mono<Boolean> elicitEnabled() {
        return Mono.just((Object)(this.exchange.getClientCapabilities() != null && this.exchange.getClientCapabilities().elicitation() != null ? 1 : 0));
    }

    @Override
    public <T> Mono<StructuredElicitResult<T>> elicit(Consumer<McpRequestContextTypes.ElicitationSpec> spec, TypeReference<T> type) {
        Assert.notNull(type, (String)"Elicitation response type must not be null");
        Assert.notNull(spec, (String)"Elicitation spec consumer must not be null");
        DefaultElicitationSpec elicitationSpec = new DefaultElicitationSpec();
        spec.accept(elicitationSpec);
        return this.elicitationInternal(elicitationSpec.message, type.getType(), elicitationSpec.meta).map(er -> new StructuredElicitResult(er.action(), JsonParser.convertMapToType((Map<String, Object>)er.content(), type), er.meta()));
    }

    @Override
    public <T> Mono<StructuredElicitResult<T>> elicit(Consumer<McpRequestContextTypes.ElicitationSpec> spec, Class<T> type) {
        Assert.notNull(type, (String)"Elicitation response type must not be null");
        Assert.notNull(spec, (String)"Elicitation spec consumer must not be null");
        DefaultElicitationSpec elicitationSpec = new DefaultElicitationSpec();
        spec.accept(elicitationSpec);
        return this.elicitationInternal(elicitationSpec.message, type, elicitationSpec.meta).map(er -> new StructuredElicitResult(er.action(), JsonParser.convertMapToType((Map<String, Object>)er.content(), type), er.meta()));
    }

    @Override
    public <T> Mono<StructuredElicitResult<T>> elicit(TypeReference<T> type) {
        Assert.notNull(type, (String)"Elicitation response type must not be null");
        return this.elicitationInternal("Please provide the required information.", type.getType(), null).map(er -> new StructuredElicitResult(er.action(), JsonParser.convertMapToType((Map<String, Object>)er.content(), type), er.meta()));
    }

    @Override
    public <T> Mono<StructuredElicitResult<T>> elicit(Class<T> type) {
        Assert.notNull(type, (String)"Elicitation response type must not be null");
        return this.elicitationInternal("Please provide the required information.", type, null).map(er -> new StructuredElicitResult(er.action(), JsonParser.convertMapToType((Map<String, Object>)er.content(), type), er.meta()));
    }

    @Override
    public Mono<McpSchema.ElicitResult> elicit(McpSchema.ElicitRequest elicitRequest) {
        Assert.notNull((Object)elicitRequest, (String)"Elicit request must not be null");
        return this.elicitEnabled().flatMap(enabled -> {
            if (!enabled.booleanValue()) {
                return Mono.error((Throwable)new IllegalStateException("Elicitation not supported by the client: " + String.valueOf(this.exchange.getClientInfo())));
            }
            return this.exchange.createElicitation(elicitRequest);
        });
    }

    public Mono<McpSchema.ElicitResult> elicitationInternal(String message, Type type, Map<String, Object> meta) {
        Assert.hasText((String)message, (String)"Elicitation message must not be empty");
        Assert.notNull((Object)type, (String)"Elicitation response type must not be null");
        Map schema = typeSchemaCache.computeIfAbsent(type, t -> this.generateElicitSchema((Type)t));
        return this.elicit(McpSchema.ElicitRequest.builder().message(message).requestedSchema(schema).meta(meta).build());
    }

    private Map<String, Object> generateElicitSchema(Type type) {
        Map<String, Object> schema = JsonParser.fromJson(JsonSchemaGenerator.generateFromType(type), MAP_TYPE_REF);
        schema.remove("$schema");
        return schema;
    }

    @Override
    public Mono<Boolean> sampleEnabled() {
        return Mono.just((Object)(this.exchange.getClientCapabilities() != null && this.exchange.getClientCapabilities().sampling() != null ? 1 : 0));
    }

    @Override
    public Mono<McpSchema.CreateMessageResult> sample(String ... messages) {
        return this.sample((McpRequestContextTypes.SamplingSpec s) -> s.message(messages));
    }

    @Override
    public Mono<McpSchema.CreateMessageResult> sample(Consumer<McpRequestContextTypes.SamplingSpec> samplingSpec) {
        String pt;
        Assert.notNull(samplingSpec, (String)"Sampling spec consumer must not be null");
        DefaultSamplingSpec spec = new DefaultSamplingSpec();
        samplingSpec.accept(spec);
        Object progressToken = this.request.progressToken();
        if (progressToken == null || progressToken instanceof String && !Utils.hasText((String)(pt = (String)progressToken))) {
            logger.warn("Progress notification not supported by the client!");
        }
        return this.sample(McpSchema.CreateMessageRequest.builder().messages(spec.messages).modelPreferences(spec.modelPreferences).systemPrompt(spec.systemPrompt).temperature(spec.temperature).maxTokens(spec.maxTokens != null && spec.maxTokens > 0 ? spec.maxTokens : 500).stopSequences(spec.stopSequences.isEmpty() ? null : spec.stopSequences).includeContext(spec.includeContextStrategy).meta(spec.metadata.isEmpty() ? null : spec.metadata).progressToken(progressToken).meta(spec.meta.isEmpty() ? null : spec.meta).build());
    }

    @Override
    public Mono<McpSchema.CreateMessageResult> sample(McpSchema.CreateMessageRequest createMessageRequest) {
        return this.sampleEnabled().flatMap(enabled -> {
            if (!enabled.booleanValue()) {
                return Mono.error((Throwable)new IllegalStateException("Sampling not supported by the client: " + String.valueOf(this.exchange.getClientInfo())));
            }
            return this.exchange.createMessage(createMessageRequest);
        });
    }

    @Override
    public Mono<Void> progress(int percentage) {
        Assert.isTrue((percentage >= 0 && percentage <= 100 ? 1 : 0) != 0, (String)"Percentage must be between 0 and 100");
        return this.progress((McpRequestContextTypes.ProgressSpec p) -> p.progress((double)percentage / 100.0).total(1.0).message(null));
    }

    @Override
    public Mono<Void> progress(Consumer<McpRequestContextTypes.ProgressSpec> progressSpec) {
        String pt;
        Assert.notNull(progressSpec, (String)"Progress spec consumer must not be null");
        DefaultProgressSpec spec = new DefaultProgressSpec();
        progressSpec.accept(spec);
        Object progressToken = this.request.progressToken();
        if (progressToken == null || progressToken instanceof String && !Utils.hasText((String)(pt = (String)progressToken))) {
            logger.warn("Progress notification not supported by the client!");
            return Mono.empty();
        }
        return this.progress(new McpSchema.ProgressNotification(progressToken, Double.valueOf(spec.progress), Double.valueOf(spec.total), spec.message, spec.meta));
    }

    @Override
    public Mono<Void> progress(McpSchema.ProgressNotification progressNotification) {
        return this.exchange.progressNotification(progressNotification).then(Mono.empty());
    }

    @Override
    public Mono<Object> ping() {
        return this.exchange.ping();
    }

    @Override
    public Mono<Void> log(Consumer<McpRequestContextTypes.LoggingSpec> logSpec) {
        Assert.notNull(logSpec, (String)"Logging spec consumer must not be null");
        DefaultLoggingSpec spec = new DefaultLoggingSpec();
        logSpec.accept(spec);
        return this.exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().data(spec.message).level(spec.level).logger(spec.logger).meta(spec.meta).build()).then();
    }

    @Override
    public Mono<Void> debug(String message) {
        return this.logInternal(message, McpSchema.LoggingLevel.DEBUG);
    }

    @Override
    public Mono<Void> info(String message) {
        return this.logInternal(message, McpSchema.LoggingLevel.INFO);
    }

    @Override
    public Mono<Void> warn(String message) {
        return this.logInternal(message, McpSchema.LoggingLevel.WARNING);
    }

    @Override
    public Mono<Void> error(String message) {
        return this.logInternal(message, McpSchema.LoggingLevel.ERROR);
    }

    private Mono<Void> logInternal(String message, McpSchema.LoggingLevel level) {
        Assert.hasText((String)message, (String)"Log message must not be empty");
        return this.exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().data(message).level(level).build()).then();
    }

    @Override
    public McpSchema.Request request() {
        return this.request;
    }

    @Override
    public McpAsyncServerExchange exchange() {
        return this.exchange;
    }

    @Override
    public String sessionId() {
        return this.exchange.sessionId();
    }

    @Override
    public McpSchema.Implementation clientInfo() {
        return this.exchange.getClientInfo();
    }

    @Override
    public McpSchema.ClientCapabilities clientCapabilities() {
        return this.exchange.getClientCapabilities();
    }

    @Override
    public Map<String, Object> requestMeta() {
        return this.request.meta();
    }

    @Override
    public McpTransportContext transportContext() {
        return this.exchange.transportContext();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpSchema.Request request;
        private McpAsyncServerExchange exchange;

        private Builder() {
        }

        public Builder request(McpSchema.Request request) {
            this.request = request;
            return this;
        }

        public Builder exchange(McpAsyncServerExchange exchange) {
            this.exchange = exchange;
            return this;
        }

        public McpAsyncRequestContext build() {
            return new DefaultMcpAsyncRequestContext(this.request, this.exchange);
        }
    }
}

