/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.collections.PStack;

final class SinglyLinkedList<E>
implements PStack<E> {
    private final E element;
    @Nullable
    private final SinglyLinkedList<E> next;
    private int hashCode;
    static final PStack EMPTY = new PStack(){

        public PStack push(Object o) {
            return new SinglyLinkedList(o);
        }

        public Object peek() {
            throw new IllegalStateException();
        }

        public Object peek(int i) {
            throw new IllegalStateException();
        }

        public PStack pop() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public void forEach(Consumer action) {
        }

        public boolean anyMatch(Predicate predicate) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String toString() {
            return "[]";
        }
    };

    private SinglyLinkedList(E element) {
        this.element = element;
        this.next = null;
    }

    private SinglyLinkedList(E element, SinglyLinkedList<E> next) {
        this.element = element;
        this.next = next;
    }

    @Override
    public PStack<E> push(E e) {
        Objects.requireNonNull(e);
        return new SinglyLinkedList<E>(e, this);
    }

    @Override
    public E peek() {
        return this.element;
    }

    @Override
    public E peek(int i) {
        SinglyLinkedList<E> c = this;
        for (int j = i; j > 0 && c != null; --j) {
            c = c.next;
        }
        if (c == null) {
            throw new IllegalStateException();
        }
        return c.element;
    }

    @Override
    public PStack<E> pop() {
        return this.next == null ? EMPTY : this.next;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIterator(this);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        SinglyLinkedList<E> c = this;
        while (c != null) {
            action.accept(c.element);
            c = c.next;
        }
    }

    @Override
    public boolean anyMatch(Predicate<E> predicate) {
        SinglyLinkedList<E> c = this;
        while (c != null) {
            if (predicate.test(c.element)) {
                return true;
            }
            c = c.next;
        }
        return false;
    }

    @Override
    public int size() {
        return 1 + (this.next == null ? 0 : this.next.size());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.next == null ? 0 : this.next.hashCode();
            this.hashCode = this.hashCode * 31 + this.element.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        this.forEach((Consumer<? super E>)((Consumer<Object>)e -> sb.append(e.toString()).append(", ")));
        sb.delete(sb.length() - 2, sb.length());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SinglyLinkedList) {
            SinglyLinkedList other = (SinglyLinkedList)obj;
            return this.element.equals(other.element) && Objects.equals(this.next, other.next);
        }
        return false;
    }

    private static class ListIterator<E>
    implements Iterator<E> {
        private SinglyLinkedList<E> current;

        public ListIterator(SinglyLinkedList<E> root) {
            this.current = root;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SinglyLinkedList<E> c = this.current;
            this.current = ((SinglyLinkedList)this.current).next;
            return (E)((SinglyLinkedList)c).element;
        }
    }
}

