/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport.builder;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.internal.smimesupport.builder.SmimeParseResult;
import org.simplejavamail.api.internal.smimesupport.model.AttachmentDecryptionResult;
import org.simplejavamail.internal.smimesupport.model.OriginalSmimeDetailsImpl;

public class SmimeParseResultBuilder
implements SmimeParseResult {
    @NotNull
    private final List<AttachmentDecryptionResult> decryptedAttachmentResults = new ArrayList<AttachmentDecryptionResult>();
    @NotNull
    private final OriginalSmimeDetailsImpl originalSmimeDetails = OriginalSmimeDetailsImpl.builder().build();
    @Nullable
    private AttachmentResource smimeSignedOrEncryptedEmail;

    public void addDecryptedAttachments(@NotNull List<AttachmentDecryptionResult> attachments) {
        this.decryptedAttachmentResults.addAll(attachments);
    }

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments() {
        ArrayList<AttachmentResource> attachmentResources = new ArrayList<AttachmentResource>();
        for (AttachmentDecryptionResult decryptedAttachment : this.decryptedAttachmentResults) {
            attachmentResources.add(decryptedAttachment.getAttachmentResource());
        }
        return attachmentResources;
    }

    @NotNull
    public List<AttachmentDecryptionResult> getDecryptedAttachmentResults() {
        return this.decryptedAttachmentResults;
    }

    @NotNull
    public OriginalSmimeDetailsImpl getOriginalSmimeDetails() {
        return this.originalSmimeDetails;
    }

    @Nullable
    public AttachmentResource getSmimeSignedOrEncryptedEmail() {
        return this.smimeSignedOrEncryptedEmail;
    }

    public void setSmimeSignedOrEncryptedEmail(@Nullable AttachmentResource smimeSignedOrEncryptedEmail) {
        this.smimeSignedOrEncryptedEmail = smimeSignedOrEncryptedEmail;
    }
}

