/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.SessionId;

@NullMarked
public class Response {
    private volatile @Nullable Object value;
    private volatile @Nullable String sessionId;
    @Deprecated
    private volatile @Nullable Integer status;
    private volatile @Nullable String state;

    public Response() {
    }

    public Response(SessionId sessionId) {
        this.sessionId = String.valueOf(sessionId);
    }

    @Deprecated
    public @Nullable Integer getStatus() {
        return this.status;
    }

    @Deprecated
    public void setStatus(@Nullable Integer status) {
        this.status = status;
    }

    public @Nullable String getState() {
        return this.state;
    }

    public void setState(@Nullable String state) {
        this.state = state;
    }

    public void setValue(@Nullable Object value) {
        this.value = value;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    public @Nullable String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return String.format("(Response: SessionID: %s, State: %s, Value: %s)", this.getSessionId(), this.getState(), this.getValue());
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Response)) {
            return false;
        }
        Response that = (Response)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.status, that.status) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sessionId, this.status, this.state);
    }

    private static Response fromJson(Map<String, Object> json) {
        String state;
        ErrorCodes errorCodes = new ErrorCodes();
        Response response = new Response();
        if (json.get("error") instanceof String) {
            state = (String)json.get("error");
            response.setState(state);
            response.setStatus(errorCodes.toStatus(state, Optional.empty()));
            response.setValue(json.get("message"));
        }
        if (json.get("state") instanceof String) {
            state = (String)json.get("state");
            response.setState(state);
            response.setStatus(errorCodes.toStatus(state, Optional.empty()));
        }
        if (json.get("status") != null) {
            Object status = json.get("status");
            if (status instanceof String) {
                String state2 = (String)status;
                response.setState(state2);
                response.setStatus(errorCodes.toStatus(state2, Optional.empty()));
            } else {
                int intStatus = ((Number)status).intValue();
                response.setState(errorCodes.toState(intStatus));
                response.setStatus(intStatus);
            }
        }
        if (json.get("sessionId") instanceof String) {
            response.setSessionId((String)json.get("sessionId"));
        }
        response.setValue(json.getOrDefault("value", json));
        return response;
    }
}

