/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Method;
import java.util.HashMap;

public class SimplePropertyDescriptor {
    private String name;
    private Method readMethod;
    private Method writeMethod;

    public SimplePropertyDescriptor() {
    }

    public SimplePropertyDescriptor(String name, Method readMethod, Method writeMethod) {
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public String getName() {
        return this.name;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public static SimplePropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        HashMap<String, SimplePropertyDescriptor> properties = new HashMap<String, SimplePropertyDescriptor>();
        for (Method m : clazz.getMethods()) {
            String propertyName;
            String methodName = m.getName();
            if (methodName.length() > 2 && methodName.startsWith("is")) {
                propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(2));
                if (properties.containsKey(propertyName)) {
                    ((SimplePropertyDescriptor)properties.get((Object)propertyName)).readMethod = m;
                } else {
                    properties.put(propertyName, new SimplePropertyDescriptor(propertyName, m, null));
                }
            }
            if (methodName.length() <= 3) continue;
            propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(3));
            if (methodName.startsWith("get") || methodName.startsWith("has")) {
                if (properties.containsKey(propertyName)) {
                    ((SimplePropertyDescriptor)properties.get((Object)propertyName)).readMethod = m;
                } else {
                    properties.put(propertyName, new SimplePropertyDescriptor(propertyName, m, null));
                }
            }
            if (!methodName.startsWith("set")) continue;
            if (properties.containsKey(propertyName)) {
                ((SimplePropertyDescriptor)properties.get((Object)propertyName)).writeMethod = m;
                continue;
            }
            properties.put(propertyName, new SimplePropertyDescriptor(propertyName, null, m));
        }
        SimplePropertyDescriptor[] pdsArray = new SimplePropertyDescriptor[properties.size()];
        return properties.values().toArray(pdsArray);
    }

    private static String uncapitalize(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }
}

