package org.openqa.selenium.devtools.v142.domstorage;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Query and modify DOM storage.
 */
@Beta()
public class DOMStorage {

    public static Command<Void> clear(org.openqa.selenium.devtools.v142.domstorage.model.StorageId storageId) {
        java.util.Objects.requireNonNull(storageId, "storageId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageId", storageId);
        return new Command<>("DOMStorage.clear", Map.copyOf(params));
    }

    /**
     * Disables storage tracking, prevents storage events from being sent to the client.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("DOMStorage.disable", Map.copyOf(params));
    }

    /**
     * Enables storage tracking, storage events will now be delivered to the client.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("DOMStorage.enable", Map.copyOf(params));
    }

    public static Command<java.util.List<org.openqa.selenium.devtools.v142.domstorage.model.Item>> getDOMStorageItems(org.openqa.selenium.devtools.v142.domstorage.model.StorageId storageId) {
        java.util.Objects.requireNonNull(storageId, "storageId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageId", storageId);
        return new Command<>("DOMStorage.getDOMStorageItems", Map.copyOf(params), ConverterFunctions.map("entries", input -> input.readArray(org.openqa.selenium.devtools.v142.domstorage.model.Item.class)));
    }

    public static Command<Void> removeDOMStorageItem(org.openqa.selenium.devtools.v142.domstorage.model.StorageId storageId, java.lang.String key) {
        java.util.Objects.requireNonNull(storageId, "storageId is required");
        java.util.Objects.requireNonNull(key, "key is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageId", storageId);
        params.put("key", key);
        return new Command<>("DOMStorage.removeDOMStorageItem", Map.copyOf(params));
    }

    public static Command<Void> setDOMStorageItem(org.openqa.selenium.devtools.v142.domstorage.model.StorageId storageId, java.lang.String key, java.lang.String value) {
        java.util.Objects.requireNonNull(storageId, "storageId is required");
        java.util.Objects.requireNonNull(key, "key is required");
        java.util.Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageId", storageId);
        params.put("key", key);
        params.put("value", value);
        return new Command<>("DOMStorage.setDOMStorageItem", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v142.domstorage.model.DomStorageItemAdded> domStorageItemAdded() {
        return new Event<>("DOMStorage.domStorageItemAdded", input -> input.read(org.openqa.selenium.devtools.v142.domstorage.model.DomStorageItemAdded.class));
    }

    public static Event<org.openqa.selenium.devtools.v142.domstorage.model.DomStorageItemRemoved> domStorageItemRemoved() {
        return new Event<>("DOMStorage.domStorageItemRemoved", input -> input.read(org.openqa.selenium.devtools.v142.domstorage.model.DomStorageItemRemoved.class));
    }

    public static Event<org.openqa.selenium.devtools.v142.domstorage.model.DomStorageItemUpdated> domStorageItemUpdated() {
        return new Event<>("DOMStorage.domStorageItemUpdated", input -> input.read(org.openqa.selenium.devtools.v142.domstorage.model.DomStorageItemUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v142.domstorage.model.StorageId> domStorageItemsCleared() {
        return new Event<>("DOMStorage.domStorageItemsCleared", ConverterFunctions.map("storageId", org.openqa.selenium.devtools.v142.domstorage.model.StorageId.class));
    }
}
