package org.openqa.selenium.devtools.v142.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a node's scrollability state changes.
 */
@org.openqa.selenium.Beta()
public class ScrollableFlagUpdated {

    private final org.openqa.selenium.devtools.v142.dom.model.NodeId nodeId;

    private final java.lang.Boolean isScrollable;

    public ScrollableFlagUpdated(org.openqa.selenium.devtools.v142.dom.model.NodeId nodeId, java.lang.Boolean isScrollable) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.isScrollable = java.util.Objects.requireNonNull(isScrollable, "isScrollable is required");
    }

    /**
     * The id of the node.
     */
    public org.openqa.selenium.devtools.v142.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    /**
     * If the node is scrollable.
     */
    public java.lang.Boolean getIsScrollable() {
        return isScrollable;
    }

    private static ScrollableFlagUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v142.dom.model.NodeId nodeId = null;
        java.lang.Boolean isScrollable = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v142.dom.model.NodeId.class);
                    break;
                case "isScrollable":
                    isScrollable = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScrollableFlagUpdated(nodeId, isScrollable);
    }
}
