package org.openqa.selenium.devtools.v142.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Section of the body of a CSS function rule.
 */
public class CSSFunctionNode {

    private final java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSFunctionConditionNode> condition;

    private final java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSStyle> style;

    public CSSFunctionNode(java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSFunctionConditionNode> condition, java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSStyle> style) {
        this.condition = condition;
        this.style = style;
    }

    /**
     * A conditional block. If set, style should not be set.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSFunctionConditionNode> getCondition() {
        return condition;
    }

    /**
     * Values set by this node. If set, condition should not be set.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSStyle> getStyle() {
        return style;
    }

    private static CSSFunctionNode fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSFunctionConditionNode> condition = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSStyle> style = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "condition":
                    condition = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.css.model.CSSFunctionConditionNode.class));
                    break;
                case "style":
                    style = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.css.model.CSSStyle.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSFunctionNode(condition, style);
    }
}
