/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.Network;
import org.openqa.selenium.devtools.v141.fetch.Fetch;
import org.openqa.selenium.devtools.v141.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v141.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v141.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v141.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v141.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v141.fetch.model.RequestStage;
import org.openqa.selenium.devtools.v141.network.Network;
import org.openqa.selenium.devtools.v141.network.model.Request;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class v141Network
extends org.openqa.selenium.devtools.idealized.Network<AuthRequired, RequestPaused> {
    private static final Logger LOG = Logger.getLogger(v141Network.class.getName());

    public v141Network(DevTools devTools) {
        super(devTools);
    }

    protected Command<Void> setUserAgentOverride(Network.UserAgent userAgent) {
        return Network.setUserAgentOverride(userAgent.userAgent(), userAgent.acceptLanguage(), userAgent.platform(), Optional.empty());
    }

    protected Command<Void> enableNetworkCaching() {
        return Network.setCacheDisabled(false);
    }

    protected Command<Void> disableNetworkCaching() {
        return Network.setCacheDisabled(true);
    }

    protected Command<Void> enableFetchForAllPatterns() {
        return Fetch.enable(Optional.of(List.of(new RequestPattern(Optional.of("*"), Optional.empty(), Optional.of(RequestStage.REQUEST)), new RequestPattern(Optional.of("*"), Optional.empty(), Optional.of(RequestStage.RESPONSE)))), Optional.of(true));
    }

    protected Command<Void> disableFetch() {
        return Fetch.disable();
    }

    protected Event<AuthRequired> authRequiredEvent() {
        return Fetch.authRequired();
    }

    protected String getUriFrom(AuthRequired authRequired) {
        return authRequired.getAuthChallenge().getOrigin();
    }

    protected Command<Void> continueWithAuth(AuthRequired authRequired, UsernameAndPassword credentials) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.PROVIDECREDENTIALS, Optional.of(credentials.username()), Optional.ofNullable(credentials.password())));
    }

    protected Command<Void> cancelAuth(AuthRequired authRequired) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.CANCELAUTH, Optional.empty(), Optional.empty()));
    }

    public Event<RequestPaused> requestPausedEvent() {
        return Fetch.requestPaused();
    }

    public Either<HttpRequest, HttpResponse> createSeMessages(RequestPaused pausedReq) {
        if (pausedReq.getResponseStatusCode().isPresent()) {
            boolean bodyIsBase64Encoded;
            String body;
            try {
                Fetch.GetResponseBodyResponse base64Body = (Fetch.GetResponseBodyResponse)this.devTools.send(Fetch.getResponseBody(pausedReq.getRequestId()));
                body = base64Body.getBody();
                bodyIsBase64Encoded = base64Body.getBase64Encoded() != null && base64Body.getBase64Encoded() != false;
            }
            catch (DevToolsException e) {
                int code = pausedReq.getResponseStatusCode().orElse(200);
                if (code >= 300 && code <= 399) {
                    LOG.warning("Unable to get body for request id " + String.valueOf(pausedReq.getRequestId()));
                }
                body = null;
                bodyIsBase64Encoded = false;
            }
            ArrayList headers = new ArrayList();
            pausedReq.getResponseHeaders().ifPresent(resHeaders -> resHeaders.forEach(header -> headers.add(new AbstractMap.SimpleEntry<String, String>(header.getName(), header.getValue()))));
            HttpResponse res = this.createHttpResponse(pausedReq.getResponseStatusCode(), body, bodyIsBase64Encoded, headers);
            return Either.right((Object)res);
        }
        Request cdpReq = pausedReq.getRequest();
        HttpRequest req = this.createHttpRequest(cdpReq.getMethod(), cdpReq.getUrl(), cdpReq.getHeaders(), cdpReq.getPostData());
        return Either.left((Object)req);
    }

    protected boolean hasErrorResponse(RequestPaused pausedReq) {
        return pausedReq.getResponseErrorReason().isPresent();
    }

    protected String getRequestId(RequestPaused pausedReq) {
        return pausedReq.getRequestId().toString();
    }

    protected Command<Void> continueWithoutModification(RequestPaused pausedRequest) {
        return Fetch.continueRequest(pausedRequest.getRequestId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    protected Command<Void> continueRequest(RequestPaused pausedReq, HttpRequest req) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (InputStream is = (InputStream)req.getContent().get();){
            is.transferTo(bos);
        }
        catch (IOException e) {
            return this.continueWithoutModification(pausedReq);
        }
        ArrayList headers = new ArrayList();
        req.forEachHeader((name, value) -> headers.add(new HeaderEntry((String)name, (String)value)));
        return Fetch.continueRequest(pausedReq.getRequestId(), Optional.of(req.getUri()), Optional.of(req.getMethod().toString()), Optional.of(Base64.getEncoder().encodeToString(bos.toByteArray())), Optional.of(headers), Optional.empty());
    }

    protected Command<Void> fulfillRequest(RequestPaused pausedReq, HttpResponse res) {
        ArrayList headers = new ArrayList();
        res.forEachHeader((name, value) -> headers.add(new HeaderEntry((String)name, (String)value)));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (InputStream is = (InputStream)res.getContent().get();){
            is.transferTo(bos);
        }
        catch (IOException e) {
            bos.reset();
        }
        return Fetch.fulfillRequest(pausedReq.getRequestId(), res.getStatus(), Optional.of(headers), Optional.empty(), Optional.of(Base64.getEncoder().encodeToString(bos.toByteArray())), Optional.empty());
    }
}

