/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.page.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v141.page.model.AdScriptId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AdScriptAncestry {
    private final List<AdScriptId> ancestryChain;
    private final Optional<String> rootScriptFilterlistRule;

    public AdScriptAncestry(List<AdScriptId> ancestryChain, Optional<String> rootScriptFilterlistRule) {
        this.ancestryChain = Objects.requireNonNull(ancestryChain, "ancestryChain is required");
        this.rootScriptFilterlistRule = rootScriptFilterlistRule;
    }

    public List<AdScriptId> getAncestryChain() {
        return this.ancestryChain;
    }

    public Optional<String> getRootScriptFilterlistRule() {
        return this.rootScriptFilterlistRule;
    }

    private static AdScriptAncestry fromJson(JsonInput input) {
        List ancestryChain = null;
        Optional<String> rootScriptFilterlistRule = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "ancestryChain": {
                    ancestryChain = input.readArray(AdScriptId.class);
                    continue block8;
                }
                case "rootScriptFilterlistRule": {
                    rootScriptFilterlistRule = Optional.ofNullable(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AdScriptAncestry(ancestryChain, rootScriptFilterlistRule);
    }
}

