package org.openqa.selenium.devtools.v141.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when message is received from udp direct socket stream.
 */
@org.openqa.selenium.Beta()
public class DirectUDPSocketChunkReceived {

    private final org.openqa.selenium.devtools.v141.network.model.RequestId identifier;

    private final org.openqa.selenium.devtools.v141.network.model.DirectUDPMessage message;

    private final org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp;

    public DirectUDPSocketChunkReceived(org.openqa.selenium.devtools.v141.network.model.RequestId identifier, org.openqa.selenium.devtools.v141.network.model.DirectUDPMessage message, org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.message = java.util.Objects.requireNonNull(message, "message is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public org.openqa.selenium.devtools.v141.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public org.openqa.selenium.devtools.v141.network.model.DirectUDPMessage getMessage() {
        return message;
    }

    public org.openqa.selenium.devtools.v141.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    private static DirectUDPSocketChunkReceived fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.network.model.RequestId identifier = null;
        org.openqa.selenium.devtools.v141.network.model.DirectUDPMessage message = null;
        org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v141.network.model.RequestId.class);
                    break;
                case "message":
                    message = input.read(org.openqa.selenium.devtools.v141.network.model.DirectUDPMessage.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v141.network.model.MonotonicTime.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectUDPSocketChunkReceived(identifier, message, timestamp);
    }
}
