package org.openqa.selenium.devtools.v141.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum SharedDictionaryError {

    USEERRORCROSSORIGINNOCORSREQUEST("UseErrorCrossOriginNoCorsRequest"),
    USEERRORDICTIONARYLOADFAILURE("UseErrorDictionaryLoadFailure"),
    USEERRORMATCHINGDICTIONARYNOTUSED("UseErrorMatchingDictionaryNotUsed"),
    USEERRORUNEXPECTEDCONTENTDICTIONARYHEADER("UseErrorUnexpectedContentDictionaryHeader"),
    WRITEERRORCOSSORIGINNOCORSREQUEST("WriteErrorCossOriginNoCorsRequest"),
    WRITEERRORDISALLOWEDBYSETTINGS("WriteErrorDisallowedBySettings"),
    WRITEERROREXPIREDRESPONSE("WriteErrorExpiredResponse"),
    WRITEERRORFEATUREDISABLED("WriteErrorFeatureDisabled"),
    WRITEERRORINSUFFICIENTRESOURCES("WriteErrorInsufficientResources"),
    WRITEERRORINVALIDMATCHFIELD("WriteErrorInvalidMatchField"),
    WRITEERRORINVALIDSTRUCTUREDHEADER("WriteErrorInvalidStructuredHeader"),
    WRITEERRORNAVIGATIONREQUEST("WriteErrorNavigationRequest"),
    WRITEERRORNOMATCHFIELD("WriteErrorNoMatchField"),
    WRITEERRORNONLISTMATCHDESTFIELD("WriteErrorNonListMatchDestField"),
    WRITEERRORNONSECURECONTEXT("WriteErrorNonSecureContext"),
    WRITEERRORNONSTRINGIDFIELD("WriteErrorNonStringIdField"),
    WRITEERRORNONSTRINGINMATCHDESTLIST("WriteErrorNonStringInMatchDestList"),
    WRITEERRORNONSTRINGMATCHFIELD("WriteErrorNonStringMatchField"),
    WRITEERRORNONTOKENTYPEFIELD("WriteErrorNonTokenTypeField"),
    WRITEERRORREQUESTABORTED("WriteErrorRequestAborted"),
    WRITEERRORSHUTTINGDOWN("WriteErrorShuttingDown"),
    WRITEERRORTOOLONGIDFIELD("WriteErrorTooLongIdField"),
    WRITEERRORUNSUPPORTEDTYPE("WriteErrorUnsupportedType");

    private String value;

    SharedDictionaryError(String value) {
        this.value = value;
    }

    public static SharedDictionaryError fromString(String s) {
        return java.util.Arrays.stream(SharedDictionaryError.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SharedDictionaryError "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SharedDictionaryError fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
