/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.Alert;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.security.Credentials;

public class HtmlUnitAlert
implements Alert {
    HtmlUnitDriver driver;
    private AlertHolder holder_;
    private boolean quitting_;
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private WebWindow webWindow_;

    HtmlUnitAlert(HtmlUnitDriver driver) {
        this.driver = driver;
        WebClient webClient = driver.getWebClient();
        webClient.setAlertHandler(this::alertHandler);
        webClient.setPromptHandler(this::promptHandler);
        webClient.setOnbeforeunloadHandler(this::onbeforeunloadHandler);
    }

    private void alertHandler(Page page, String message) {
        if (this.quitting_) {
            return;
        }
        this.webWindow_ = page.getEnclosingWindow();
        this.holder_ = new AlertHolder(message);
        this.awaitCondition();
    }

    private void awaitCondition() {
        block5: {
            this.lock.lock();
            try {
                if (!this.driver.isProcessAlert()) break block5;
                try {
                    this.condition.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private String promptHandler(Page page, String message, String defaultMessage) {
        if (this.quitting_) {
            return null;
        }
        this.webWindow_ = page.getEnclosingWindow();
        this.holder_ = new PromptHolder(message, defaultMessage);
        PromptHolder localHolder = (PromptHolder)this.holder_;
        this.awaitCondition();
        return localHolder.value;
    }

    private boolean onbeforeunloadHandler(Page page, String returnValue) {
        if (this.quitting_) {
            return true;
        }
        this.webWindow_ = page.getEnclosingWindow();
        AlertHolder localHolder = this.holder_ = new AlertHolder(returnValue);
        this.awaitCondition();
        return localHolder.isAccepted();
    }

    WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void setAutoAccept(boolean autoAccept) {
        this.quitting_ = autoAccept;
    }

    public void dismiss() {
        this.lock.lock();
        this.condition.signal();
        this.holder_ = null;
        this.lock.unlock();
    }

    public void accept() {
        this.lock.lock();
        this.holder_.accept();
        this.condition.signal();
        this.holder_ = null;
        this.lock.unlock();
    }

    public String getText() {
        if (this.holder_ == null) {
            throw new NoAlertPresentException();
        }
        return this.holder_.message;
    }

    public void sendKeys(String keysToSend) {
        this.holder_.sendKeys(keysToSend);
    }

    public void authenticateUsing(Credentials credentials) {
    }

    public void setCredentials(Credentials credentials) {
    }

    void close() {
        this.lock.lock();
        this.condition.signal();
        this.setAutoAccept(true);
        this.lock.unlock();
        this.holder_ = null;
    }

    boolean isLocked() {
        return this.holder_ != null;
    }

    private static class AlertHolder {
        String message;
        boolean accepted;

        AlertHolder(String message) {
            this.message = message;
        }

        void sendKeys(String keysToSend) {
            if (keysToSend != null) {
                throw new ElementNotInteractableException("alert is not interactable");
            }
        }

        void accept() {
            this.accepted = true;
        }

        boolean isAccepted() {
            return this.accepted;
        }
    }

    private static class PromptHolder
    extends AlertHolder {
        String defaultMessage;
        String value;

        public PromptHolder(String message, String defaultMessage) {
            super(message);
            this.defaultMessage = defaultMessage;
        }

        @Override
        void sendKeys(String keysToSend) {
            if (keysToSend == null) {
                keysToSend = this.defaultMessage;
            }
            this.value = keysToSend;
        }

        @Override
        void accept() {
            if (this.value == null) {
                this.value = this.defaultMessage;
            }
        }
    }
}

