/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scalaj.http.Base64;
import scalaj.http.Http;
import scalaj.http.Http$Request$;
import scalaj.http.HttpOptions$;
import scalaj.http.MultiPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Http$
implements ScalaObject {
    public static final Http$ MODULE$;
    private final List<Function1<HttpURLConnection, BoxedUnit>> defaultOptions;
    private final String CrLf;
    private final String Pref;
    private final String Boundary;
    private final String charset;

    static {
        new Http$();
    }

    public Http.Request apply(String url) {
        return this.get(url);
    }

    public <E> E tryParse(InputStream is, Function1<InputStream, E> parser) {
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = parser.apply((Object)is);
            return (E)exceptionResult1;
        }
        finally {
            is.close();
        }
    }

    public String readString(InputStream is) {
        InputStreamReader in$2 = new InputStreamReader(is, this.charset());
        StringBuilder bos$1 = new StringBuilder();
        char[] ba$1 = new char[4096];
        this.readOnce$1(in$2, bos$1, ba$1);
        return bos$1.toString();
    }

    public byte[] readBytes(InputStream in$1) {
        ByteArrayOutputStream bos$2 = new ByteArrayOutputStream();
        byte[] ba$2 = new byte[4096];
        this.readOnce$2(in$1, bos$2, ba$2);
        return bos$2.toByteArray();
    }

    public List<Function1<HttpURLConnection, BoxedUnit>> defaultOptions() {
        return this.defaultOptions;
    }

    public String urlEncode(String name) {
        return URLEncoder.encode(name, this.charset());
    }

    public String urlDecode(String name) {
        return URLDecoder.decode(name, this.charset());
    }

    public String base64(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.charset()));
    }

    public String toQs(List<Tuple2<String, String>> params) {
        return ((TraversableOnce)params.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<String, String> p) {
                return new StringBuilder().append((Object)Http$.MODULE$.urlEncode((String)p._1())).append((Object)"=").append((Object)Http$.MODULE$.urlEncode((String)p._2())).toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString("&");
    }

    public String appendQs(String url, List<Tuple2<String, String>> params) {
        return new StringBuilder().append((Object)url).append((Object)(params.isEmpty() ? "" : new StringBuilder().append((Object)(url.contains("?") ? "&" : "?")).append((Object)this.toQs(params)).toString())).toString();
    }

    public Function1<Http.Request, URL> appendQsHttpUrl(String url$2) {
        return new Serializable(url$2){
            public static final long serialVersionUID;
            private final String url$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final URL apply(Http.Request r) {
                return new URL(Http$.MODULE$.appendQs(this.url$2, r.params()));
            }
            {
                this.url$2 = string;
            }
        };
    }

    public Function1<Http.Request, URL> noopHttpUrl(String url$3) {
        return new Serializable(url$3){
            public static final long serialVersionUID;
            private final String url$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final URL apply(Http.Request r) {
                return new URL(this.url$3);
            }
            {
                this.url$3 = string;
            }
        };
    }

    public Http.Request get(String url) {
        Serializable getFunc = new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.connect();
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)getFunc, this.appendQsHttpUrl(url), "GET");
    }

    public String CrLf() {
        return this.CrLf;
    }

    public String Pref() {
        return this.Pref;
    }

    public String Boundary() {
        return this.Boundary;
    }

    public Http.Request multipart(String url, Seq<MultiPart> parts$1) {
        Serializable postFunc = new Serializable(parts$1){
            public static final long serialVersionUID;
            private final Seq parts$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", new StringBuilder().append((Object)"multipart/form-data; boundary=").append((Object)Http$.MODULE$.Boundary()).toString());
                conn.setRequestProperty("MIME-Version", "1.0");
                DataOutputStream out$1 = new DataOutputStream(conn.getOutputStream());
                req.params().foreach((Function1)new Serializable(this, out$1){
                    public static final long serialVersionUID;
                    private final DataOutputStream out$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<String, String> tuple2) {
                        Tuple2<String, String> tuple22 = tuple2;
                        if (tuple22 != null) {
                            this.out$1.writeBytes(new StringBuilder().append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.Boundary()).append((Object)Http$.MODULE$.CrLf()).toString());
                            this.out$1.writeBytes(new StringBuilder().append((Object)"Content-Disposition: form-data; name=\"").append(tuple22._1()).append((Object)"\"").toString());
                            this.out$1.writeBytes(new StringBuilder().append((Object)Http$.MODULE$.CrLf()).append((Object)Http$.MODULE$.CrLf()).append((Object)((String)tuple22._2()).toString()).append((Object)Http$.MODULE$.CrLf()).toString());
                            return;
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        this.out$1 = dataOutputStream;
                    }
                });
                this.parts$1.foreach((Function1)new Serializable(this, out$1){
                    public static final long serialVersionUID;
                    private final DataOutputStream out$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MultiPart part) {
                        this.out$1.writeBytes(new StringBuilder().append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.Boundary()).append((Object)Http$.MODULE$.CrLf()).toString());
                        this.out$1.writeBytes(new StringBuilder().append((Object)"Content-Disposition: form-data; name=\"").append((Object)part.name()).append((Object)"\"; filename=\"").append((Object)part.filename()).append((Object)"\"").append((Object)Http$.MODULE$.CrLf()).toString());
                        this.out$1.writeBytes(new StringBuilder().append((Object)"Content-Type: ").append((Object)part.mime()).append((Object)Http$.MODULE$.CrLf()).append((Object)Http$.MODULE$.CrLf()).toString());
                        this.out$1.write(part.data());
                        this.out$1.writeBytes(new StringBuilder().append((Object)Http$.MODULE$.CrLf()).append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.Boundary()).append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.CrLf()).toString());
                    }
                    {
                        this.out$1 = dataOutputStream;
                    }
                });
                out$1.flush();
                out$1.close();
            }
            {
                this.parts$1 = seq;
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)postFunc, this.noopHttpUrl(url), "POST");
    }

    public Http.Request postData(String url, String data) {
        return this.postData(url, data.getBytes(this.charset()));
    }

    public Http.Request postData(String url, byte[] data$2) {
        Serializable postFunc = new Serializable(data$2){
            public static final long serialVersionUID;
            private final byte[] data$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.setDoOutput(true);
                conn.connect();
                conn.getOutputStream().write(this.data$2);
            }
            {
                this.data$2 = byArray;
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)postFunc, this.noopHttpUrl(url), "POST");
    }

    public Http.Request post(String url) {
        Serializable postFunc = new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.setDoOutput(true);
                conn.connect();
                conn.getOutputStream().write(Http$.MODULE$.toQs(req.params()).getBytes(Http$.MODULE$.charset()));
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)postFunc, this.noopHttpUrl(url), "POST").header("content-type", "application/x-www-form-urlencoded");
    }

    public String charset() {
        return this.charset;
    }

    private final void readOnce$1(InputStreamReader inputStreamReader, StringBuilder stringBuilder, char[] cArray) {
        int len;
        do {
            Object object = (len = inputStreamReader.read(cArray)) > 0 ? stringBuilder.appendAll(cArray, 0, len) : BoxedUnit.UNIT;
        } while (len >= 0);
    }

    private final void readOnce$2(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
        int len;
        do {
            if ((len = inputStream.read(byArray)) <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, len);
        } while (len >= 0);
    }

    private Http$() {
        MODULE$ = this;
        this.defaultOptions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{HttpOptions$.MODULE$.connTimeout(100), HttpOptions$.MODULE$.readTimeout(500)}));
        this.CrLf = "\r\n";
        this.Pref = "--";
        this.Boundary = "gc0pMUlT1B0uNdArYc0p";
        this.charset = "UTF-8";
    }
}

