/*
 * Decompiled with CFR 0.152.
 */
package scala.util.matching;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex$;
import scala.util.matching.Regex$Match$;
import scala.util.matching.UnanchoredRegex;

public class Regex
implements Serializable {
    private static final long serialVersionUID = -2094783597747625537L;
    private final Pattern pattern;
    public final Seq<String> scala$util$matching$Regex$$groupNames;

    public static String quote(String string2) {
        return Regex$.MODULE$.quote(string2);
    }

    public static String quoteReplacement(String string2) {
        return Regex$.MODULE$.quoteReplacement(string2);
    }

    public Regex(Pattern pattern, Seq<String> groupNames) {
        this.pattern = pattern;
        this.scala$util$matching$Regex$$groupNames = groupNames;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Regex(String regex, Seq<String> groupNames) {
        this(Pattern.compile(regex), groupNames);
    }

    public Option<List<String>> unapplySeq(CharSequence s) {
        Matcher m = this.pattern().matcher(s);
        if (this.runMatcher(m)) {
            return Some$.MODULE$.apply(package$.MODULE$.List().tabulate(m.groupCount(), (Function1<Object, String> & Serializable)i -> m.group(BoxesRunTime.unboxToInt(i) + 1)));
        }
        return None$.MODULE$;
    }

    public Option<List<Object>> unapplySeq(char c) {
        Matcher m = this.pattern().matcher(BoxesRunTime.boxToCharacter(c).toString());
        if (this.runMatcher(m)) {
            if (m.groupCount() > 0) {
                return Some$.MODULE$.apply(Predef$.MODULE$.wrapString(m.group(1)).toList());
            }
            return Some$.MODULE$.apply(package$.MODULE$.Nil());
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Option<List<String>> unapplySeq(Match m) {
        void var3_3;
        if (m.matched() == null) {
            return None$.MODULE$;
        }
        Pattern pattern = m.matcher().pattern();
        Pattern pattern2 = this.pattern();
        if (!(pattern != null ? !pattern.equals(pattern2) : pattern2 != null)) {
            return Regex$.MODULE$.scala$util$matching$Regex$$$extractGroupsFromMatch(m);
        }
        String x$proxy1 = m.matched();
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return this.unapplySeq((CharSequence)var3_3);
    }

    public boolean runMatcher(Matcher m) {
        return m.matches();
    }

    public MatchIterator findAllIn(CharSequence source) {
        return new MatchIterator(source, this, this.scala$util$matching$Regex$$groupNames);
    }

    public Iterator<Match> findAllMatchIn(CharSequence source) {
        MatchIterator matchIterator = this.findAllIn(source);
        return new AbstractIterator<Match>(matchIterator){
            private final MatchIterator matchIterator$1;
            {
                this.matchIterator$1 = matchIterator$2;
            }

            public boolean hasNext() {
                return this.matchIterator$1.hasNext();
            }

            public Match next() {
                this.matchIterator$1.next();
                return new Match(this.matchIterator$1.source(), this.matchIterator$1.matcher(), this.matchIterator$1._groupNames()).force();
            }
        };
    }

    public Option<String> findFirstIn(CharSequence source) {
        Matcher m = this.pattern().matcher(source);
        if (m.find()) {
            return Some$.MODULE$.apply(m.group());
        }
        return None$.MODULE$;
    }

    public Option<Match> findFirstMatchIn(CharSequence source) {
        Matcher m = this.pattern().matcher(source);
        if (m.find()) {
            return Some$.MODULE$.apply(new Match(source, m, this.scala$util$matching$Regex$$groupNames));
        }
        return None$.MODULE$;
    }

    public Option<String> findPrefixOf(CharSequence source) {
        Matcher m = this.pattern().matcher(source);
        if (m.lookingAt()) {
            return Some$.MODULE$.apply(m.group());
        }
        return None$.MODULE$;
    }

    public Option<Match> findPrefixMatchOf(CharSequence source) {
        Matcher m = this.pattern().matcher(source);
        if (m.lookingAt()) {
            return Some$.MODULE$.apply(new Match(source, m, this.scala$util$matching$Regex$$groupNames));
        }
        return None$.MODULE$;
    }

    public boolean matches(CharSequence source) {
        return this.runMatcher(this.pattern().matcher(source));
    }

    public String replaceAllIn(CharSequence target, String replacement) {
        Matcher m = this.pattern().matcher(target);
        return m.replaceAll(replacement);
    }

    public String replaceAllIn(CharSequence target, Function1<Match, String> replacer) {
        AbstractIterator<Match> rit = new MatchIterator(target, this, this.scala$util$matching$Regex$$groupNames).replacementData();
        rit.foreach((Function1<Match, Matcher> & Serializable)matchdata -> {
            String replacement = (String)replacer.apply((Match)matchdata);
            return ((Replacement)((Object)rit)).replace(replacement);
        });
        return ((Replacement)((Object)rit)).replaced();
    }

    public String replaceSomeIn(CharSequence target, Function1<Match, Option<String>> replacer) {
        AbstractIterator<Match> rit = new MatchIterator(target, this, this.scala$util$matching$Regex$$groupNames).replacementData();
        rit.foreach(matchdata -> ((Option)replacer.apply((Match)matchdata)).foreach((Function1<String, Matcher> & Serializable)replacement -> ((Replacement)((Object)rit)).replace((String)replacement)));
        return ((Replacement)((Object)rit)).replaced();
    }

    public String replaceFirstIn(CharSequence target, String replacement) {
        Matcher m = this.pattern().matcher(target);
        return m.replaceFirst(replacement);
    }

    public String[] split(CharSequence toSplit) {
        return this.pattern().split(toSplit);
    }

    public UnanchoredRegex unanchored() {
        return new UnanchoredRegex(this){
            private final /* synthetic */ Regex $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.pattern(), $outer.scala$util$matching$Regex$$groupNames);
                UnanchoredRegex.$init$(this);
            }

            public boolean runMatcher(Matcher m) {
                return UnanchoredRegex.runMatcher$(this, m);
            }

            public UnanchoredRegex unanchored() {
                return UnanchoredRegex.unanchored$(this);
            }

            public Regex anchored() {
                return this.$outer;
            }
        };
    }

    public Regex anchored() {
        return this;
    }

    public String regex() {
        return this.pattern().pattern();
    }

    public String toString() {
        return this.regex();
    }

    public static class Match
    implements MatchData {
        private static final VarHandle scala$util$matching$Regex$MatchData$$nameToIndex$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(Match.class, "scala$util$matching$Regex$MatchData$$nameToIndex$lzy1", Object.class);
        private static final VarHandle ends$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(Match.class, "ends$lzy1", Object.class);
        private static final VarHandle starts$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(Match.class, "starts$lzy1", Object.class);
        private volatile Object scala$util$matching$Regex$MatchData$$nameToIndex$lzy1;
        private final CharSequence source;
        private final Matcher matcher;
        private final Seq<String> groupNames;
        private final int start;
        private final int end;
        private volatile Object starts$lzy1;
        private volatile Object ends$lzy1;

        public static Some<String> unapply(Match match) {
            return Regex$Match$.MODULE$.unapply(match);
        }

        public Match(CharSequence source, Matcher matcher, Seq<String> _groupNames) {
            this.source = source;
            this.matcher = matcher;
            MatchData.$init$(this);
            this.groupNames = _groupNames;
            this.start = matcher.start();
            this.end = matcher.end();
        }

        public Map scala$util$matching$Regex$MatchData$$nameToIndex() {
            Object object = this.scala$util$matching$Regex$MatchData$$nameToIndex$lzy1;
            if (object instanceof Map) {
                return (Map)object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (Map)this.scala$util$matching$Regex$MatchData$$nameToIndex$lzyINIT1();
        }

        private Object scala$util$matching$Regex$MatchData$$nameToIndex$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.scala$util$matching$Regex$MatchData$$nameToIndex$lzy1) == null) {
                        if (!scala$util$matching$Regex$MatchData$$nameToIndex$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Map map = null;
                        try {
                            map = MatchData.scala$util$matching$Regex$MatchData$$nameToIndex$(this);
                            object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                        }
                        finally {
                            if (!scala$util$matching$Regex$MatchData$$nameToIndex$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.scala$util$matching$Regex$MatchData$$nameToIndex$lzy1;
                                scala$util$matching$Regex$MatchData$$nameToIndex$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return map;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        scala$util$matching$Regex$MatchData$$nameToIndex$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public String matched() {
            return MatchData.matched$(this);
        }

        @Override
        public String group(int i) {
            return MatchData.group$((MatchData)this, i);
        }

        @Override
        public List<String> subgroups() {
            return MatchData.subgroups$(this);
        }

        @Override
        public CharSequence before() {
            return MatchData.before$(this);
        }

        @Override
        public CharSequence before(int i) {
            return MatchData.before$(this, i);
        }

        @Override
        public CharSequence after() {
            return MatchData.after$(this);
        }

        @Override
        public CharSequence after(int i) {
            return MatchData.after$(this, i);
        }

        @Override
        public String group(String id) {
            return MatchData.group$((MatchData)this, id);
        }

        @Override
        public String toString() {
            return MatchData.toString$(this);
        }

        @Override
        public CharSequence source() {
            return this.source;
        }

        @Override
        public Matcher matcher() {
            return this.matcher;
        }

        @Override
        public Seq<String> groupNames() {
            return this.groupNames;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int groupCount() {
            return this.matcher().groupCount();
        }

        private int[] starts() {
            Object object = this.starts$lzy1;
            if (object instanceof int[]) {
                return (int[])object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (int[])this.starts$lzyINIT1();
        }

        private Object starts$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.starts$lzy1) == null) {
                        if (!starts$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        int[] nArray = null;
                        try {
                            nArray = (int[])Array$.MODULE$.tabulate(this.groupCount() + 1, (Function1<Object, Integer> & Serializable)x$0 -> this.starts$lzyINIT1$$anonfun$1(BoxesRunTime.unboxToInt(x$0)), ClassTag$.MODULE$.apply(Integer.TYPE));
                            object2 = nArray == null ? LazyVals$NullValue$.MODULE$ : (Object)nArray;
                        }
                        finally {
                            if (!starts$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.starts$lzy1;
                                starts$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return nArray;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        starts$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private int[] ends() {
            Object object = this.ends$lzy1;
            if (object instanceof int[]) {
                return (int[])object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (int[])this.ends$lzyINIT1();
        }

        private Object ends$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.ends$lzy1) == null) {
                        if (!ends$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        int[] nArray = null;
                        try {
                            nArray = (int[])Array$.MODULE$.tabulate(this.groupCount() + 1, (Function1<Object, Integer> & Serializable)x$0 -> this.ends$lzyINIT1$$anonfun$1(BoxesRunTime.unboxToInt(x$0)), ClassTag$.MODULE$.apply(Integer.TYPE));
                            object2 = nArray == null ? LazyVals$NullValue$.MODULE$ : (Object)nArray;
                        }
                        finally {
                            if (!ends$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.ends$lzy1;
                                ends$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return nArray;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        ends$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public int start(int i) {
            return this.starts()[i];
        }

        @Override
        public int end(int i) {
            return this.ends()[i];
        }

        public Match force() {
            this.starts();
            this.ends();
            return this;
        }

        private final /* synthetic */ int starts$lzyINIT1$$anonfun$1(int x$0) {
            return this.matcher().start(x$0);
        }

        private final /* synthetic */ int ends$lzyINIT1$$anonfun$1(int x$0) {
            return this.matcher().end(x$0);
        }
    }

    public static interface MatchData {
        public static void $init$(MatchData $this) {
        }

        public Matcher matcher();

        public CharSequence source();

        public Seq<String> groupNames();

        public int groupCount();

        public int start();

        public int start(int var1);

        public int end();

        public int end(int var1);

        public static String matched$(MatchData $this) {
            return $this.matched();
        }

        default public String matched() {
            if (this.start() >= 0) {
                return this.source().subSequence(this.start(), this.end()).toString();
            }
            return null;
        }

        public static String group$(MatchData $this, int i) {
            return $this.group(i);
        }

        default public String group(int i) {
            if (this.start(i) >= 0) {
                return this.source().subSequence(this.start(i), this.end(i)).toString();
            }
            return null;
        }

        public static List subgroups$(MatchData $this) {
            return $this.subgroups();
        }

        default public List<String> subgroups() {
            return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.groupCount()).toList().map((Function1<Object, String> & Serializable)i -> this.subgroups$$anonfun$1(BoxesRunTime.unboxToInt(i)));
        }

        public static CharSequence before$(MatchData $this) {
            return $this.before();
        }

        default public CharSequence before() {
            if (this.start() >= 0) {
                return this.source().subSequence(0, this.start());
            }
            return null;
        }

        public static CharSequence before$(MatchData $this, int i) {
            return $this.before(i);
        }

        default public CharSequence before(int i) {
            if (this.start(i) >= 0) {
                return this.source().subSequence(0, this.start(i));
            }
            return null;
        }

        public static CharSequence after$(MatchData $this) {
            return $this.after();
        }

        default public CharSequence after() {
            if (this.end() >= 0) {
                return this.source().subSequence(this.end(), this.source().length());
            }
            return null;
        }

        public static CharSequence after$(MatchData $this, int i) {
            return $this.after(i);
        }

        default public CharSequence after(int i) {
            if (this.end(i) >= 0) {
                return this.source().subSequence(this.end(i), this.source().length());
            }
            return null;
        }

        private Seq<String> groupNamesNowarn() {
            return this.groupNames();
        }

        public static Map scala$util$matching$Regex$MatchData$$nameToIndex$(MatchData $this) {
            return $this.scala$util$matching$Regex$MatchData$$nameToIndex();
        }

        default public Map<String, Object> scala$util$matching$Regex$MatchData$$nameToIndex() {
            return (Map)((MapOps)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]))).$plus$plus((IterableOnce)this.groupNamesNowarn().toList().$colon$colon("").zipWithIndex());
        }

        public static String group$(MatchData $this, String id) {
            return $this.group(id);
        }

        default public String group(String id) {
            if (this.groupNamesNowarn().isEmpty()) {
                return this.matcher().group(id);
            }
            Option option = this.scala$util$matching$Regex$MatchData$$nameToIndex().get(id);
            if (option instanceof Some) {
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt(some.value());
                return this.group(index);
            }
            if (None$.MODULE$.equals(option)) {
                return this.matcher().group(id);
            }
            throw new MatchError(option);
        }

        public static String toString$(MatchData $this) {
            return $this.toString();
        }

        default public String toString() {
            String x$proxy2 = this.matched();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy2;
        }

        private /* synthetic */ String subgroups$$anonfun$1(int i) {
            return this.group(i);
        }
    }

    public static class MatchIterator
    extends AbstractIterator<String>
    implements MatchData {
        private static final VarHandle scala$util$matching$Regex$MatchData$$nameToIndex$lzy2$lzyHandle = MethodHandles.lookup().findVarHandle(MatchIterator.class, "scala$util$matching$Regex$MatchData$$nameToIndex$lzy2", Object.class);
        private volatile Object scala$util$matching$Regex$MatchData$$nameToIndex$lzy2;
        private final CharSequence source;
        private final Regex regex;
        private final Seq<String> _groupNames;
        private final Seq<String> groupNames;
        private final Matcher matcher;
        private int nextSeen;

        public MatchIterator(CharSequence source, Regex regex, Seq<String> _groupNames) {
            this.source = source;
            this.regex = regex;
            this._groupNames = _groupNames;
            MatchData.$init$(this);
            this.groupNames = _groupNames;
            this.matcher = regex.pattern().matcher(source);
            this.nextSeen = 0;
        }

        public Map scala$util$matching$Regex$MatchData$$nameToIndex() {
            Object object = this.scala$util$matching$Regex$MatchData$$nameToIndex$lzy2;
            if (object instanceof Map) {
                return (Map)object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (Map)this.scala$util$matching$Regex$MatchData$$nameToIndex$lzyINIT2();
        }

        private Object scala$util$matching$Regex$MatchData$$nameToIndex$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.scala$util$matching$Regex$MatchData$$nameToIndex$lzy2) == null) {
                        if (!scala$util$matching$Regex$MatchData$$nameToIndex$lzy2$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Map map = null;
                        try {
                            map = MatchData.scala$util$matching$Regex$MatchData$$nameToIndex$(this);
                            object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                        }
                        finally {
                            if (!scala$util$matching$Regex$MatchData$$nameToIndex$lzy2$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.scala$util$matching$Regex$MatchData$$nameToIndex$lzy2;
                                scala$util$matching$Regex$MatchData$$nameToIndex$lzy2$lzyHandle.compareAndSet(this, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return map;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        scala$util$matching$Regex$MatchData$$nameToIndex$lzy2$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public String matched() {
            return MatchData.matched$(this);
        }

        @Override
        public String group(int i) {
            return MatchData.group$((MatchData)this, i);
        }

        @Override
        public List<String> subgroups() {
            return MatchData.subgroups$(this);
        }

        @Override
        public CharSequence before() {
            return MatchData.before$(this);
        }

        @Override
        public CharSequence before(int i) {
            return MatchData.before$(this, i);
        }

        @Override
        public CharSequence after() {
            return MatchData.after$(this);
        }

        @Override
        public CharSequence after(int i) {
            return MatchData.after$(this, i);
        }

        @Override
        public String group(String id) {
            return MatchData.group$((MatchData)this, id);
        }

        @Override
        public CharSequence source() {
            return this.source;
        }

        public Regex regex() {
            return this.regex;
        }

        public Seq<String> _groupNames() {
            return this._groupNames;
        }

        @Override
        public Seq<String> groupNames() {
            return this.groupNames;
        }

        @Override
        public Matcher matcher() {
            return this.matcher;
        }

        @Override
        public boolean hasNext() {
            int n = this.nextSeen;
            switch (n) {
                case 0: {
                    this.nextSeen = this.matcher().find() ? 1 : 3;
                    Serializable serializable = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    Serializable serializable = BoxedUnit.UNIT;
                    break;
                }
                case 2: {
                    this.nextSeen = 0;
                    Serializable serializable = BoxesRunTime.boxToBoolean(this.hasNext());
                    break;
                }
                case 3: {
                    Serializable serializable = BoxedUnit.UNIT;
                    break;
                }
                default: {
                    throw new MatchError(BoxesRunTime.boxToInteger(n));
                }
            }
            return this.nextSeen == 1;
        }

        @Override
        public String next() {
            int n = this.nextSeen;
            switch (n) {
                case 0: {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object object = this.next();
                    break;
                }
                case 1: {
                    this.nextSeen = 2;
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 2: {
                    this.nextSeen = 0;
                    Object object = this.next();
                    break;
                }
                case 3: {
                    throw new NoSuchElementException();
                }
                default: {
                    throw new MatchError(BoxesRunTime.boxToInteger(n));
                }
            }
            return this.matcher().group();
        }

        @Override
        public String toString() {
            return Iterator.toString$(this);
        }

        private void ensure() {
            int n = this.nextSeen;
            switch (n) {
                case 0: {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    return;
                }
                case 1: {
                    return;
                }
                case 2: {
                    return;
                }
                case 3: {
                    throw new IllegalStateException();
                }
            }
            throw new MatchError(BoxesRunTime.boxToInteger(n));
        }

        @Override
        public int start() {
            this.ensure();
            return this.matcher().start();
        }

        @Override
        public int start(int i) {
            this.ensure();
            return this.matcher().start(i);
        }

        @Override
        public int end() {
            this.ensure();
            return this.matcher().end();
        }

        @Override
        public int end(int i) {
            this.ensure();
            return this.matcher().end(i);
        }

        @Override
        public int groupCount() {
            this.ensure();
            return this.matcher().groupCount();
        }

        public Iterator<Match> matchData() {
            return new AbstractIterator<Match>(this){
                private final /* synthetic */ MatchIterator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public boolean hasNext() {
                    return this.$outer.hasNext();
                }

                public Match next() {
                    this.$outer.next();
                    return new Match(this.$outer.source(), this.$outer.matcher(), this.$outer._groupNames()).force();
                }
            };
        }

        public AbstractIterator<Match> replacementData() {
            return new Replacement(this){
                private StringBuffer scala$util$matching$Regex$Replacement$$sb;
                private final /* synthetic */ MatchIterator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    Replacement.$init$(this);
                    Statics.releaseFence();
                }

                public StringBuffer scala$util$matching$Regex$Replacement$$sb() {
                    return this.scala$util$matching$Regex$Replacement$$sb;
                }

                public void scala$util$matching$Regex$Replacement$_setter_$scala$util$matching$Regex$Replacement$$sb_$eq(StringBuffer x$0) {
                    this.scala$util$matching$Regex$Replacement$$sb = x$0;
                }

                public String replaced() {
                    return Replacement.replaced$(this);
                }

                public Matcher replace(String replacement) {
                    return Replacement.replace$(this, replacement);
                }

                public Matcher matcher() {
                    return this.$outer.matcher();
                }

                public boolean hasNext() {
                    return this.$outer.hasNext();
                }

                public Match next() {
                    this.$outer.next();
                    return new Match(this.$outer.source(), this.matcher(), this.$outer._groupNames()).force();
                }
            };
        }
    }

    public static interface Replacement {
        public static void $init$(Replacement $this) {
            $this.scala$util$matching$Regex$Replacement$_setter_$scala$util$matching$Regex$Replacement$$sb_$eq(new StringBuffer());
        }

        public Matcher matcher();

        public StringBuffer scala$util$matching$Regex$Replacement$$sb();

        public void scala$util$matching$Regex$Replacement$_setter_$scala$util$matching$Regex$Replacement$$sb_$eq(StringBuffer var1);

        public static String replaced$(Replacement $this) {
            return $this.replaced();
        }

        default public String replaced() {
            this.matcher().appendTail(this.scala$util$matching$Regex$Replacement$$sb());
            return this.scala$util$matching$Regex$Replacement$$sb().toString();
        }

        public static Matcher replace$(Replacement $this, String replacement) {
            return $this.replace(replacement);
        }

        default public Matcher replace(String replacement) {
            return this.matcher().appendReplacement(this.scala$util$matching$Regex$Replacement$$sb(), replacement);
        }
    }
}

