/*
 * Decompiled with CFR 0.152.
 */
package scala.sys.process;

import java.io.InputStream;
import java.io.OutputStream;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class ProcessIO {
    private final Function1<OutputStream, BoxedUnit> writeInput;
    private final Function1<InputStream, BoxedUnit> processOutput;
    private final Function1<InputStream, BoxedUnit> processError;
    private final boolean daemonizeThreads;

    public ProcessIO(Function1<OutputStream, BoxedUnit> writeInput, Function1<InputStream, BoxedUnit> processOutput, Function1<InputStream, BoxedUnit> processError, boolean daemonizeThreads) {
        this.writeInput = writeInput;
        this.processOutput = processOutput;
        this.processError = processError;
        this.daemonizeThreads = daemonizeThreads;
    }

    public Function1<OutputStream, BoxedUnit> writeInput() {
        return this.writeInput;
    }

    public Function1<InputStream, BoxedUnit> processOutput() {
        return this.processOutput;
    }

    public Function1<InputStream, BoxedUnit> processError() {
        return this.processError;
    }

    public boolean daemonizeThreads() {
        return this.daemonizeThreads;
    }

    public ProcessIO(Function1<OutputStream, BoxedUnit> in, Function1<InputStream, BoxedUnit> out, Function1<InputStream, BoxedUnit> err) {
        this(in, out, err, false);
    }

    public ProcessIO withInput(Function1<OutputStream, BoxedUnit> write) {
        return new ProcessIO(write, this.processOutput(), this.processError(), this.daemonizeThreads());
    }

    public ProcessIO withOutput(Function1<InputStream, BoxedUnit> process) {
        return new ProcessIO(this.writeInput(), process, this.processError(), this.daemonizeThreads());
    }

    public ProcessIO withError(Function1<InputStream, BoxedUnit> process) {
        return new ProcessIO(this.writeInput(), this.processOutput(), process, this.daemonizeThreads());
    }

    public ProcessIO daemonized() {
        return new ProcessIO(this.writeInput(), this.processOutput(), this.processError(), true);
    }
}

