/*
 * Decompiled with CFR 0.152.
 */
package scala.jdk.javaapi;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import scala.Int$;
import scala.MatchError;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.ModuleSerializationProxy;

public final class DurationConverters$
implements Serializable {
    public static final DurationConverters$ MODULE$ = new DurationConverters$();

    private DurationConverters$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DurationConverters$.class);
    }

    public FiniteDuration toScala(Duration duration) {
        FiniteDuration finiteDuration;
        long originalSeconds = duration.getSeconds();
        int originalNanos = duration.getNano();
        if (originalNanos == 0) {
            if (originalSeconds == 0L) {
                return Duration$.MODULE$.Zero();
            }
            return FiniteDuration$.MODULE$.apply(originalSeconds, TimeUnit.SECONDS);
        }
        if (originalSeconds == 0L) {
            return FiniteDuration$.MODULE$.apply(Int$.MODULE$.int2long(originalNanos), TimeUnit.NANOSECONDS);
        }
        try {
            long secondsAsNanos = Math.multiplyExact(originalSeconds, 1000000000);
            long totalNanos = secondsAsNanos + (long)originalNanos;
            if (!(totalNanos < 0L && secondsAsNanos < 0L || totalNanos > 0L && secondsAsNanos > 0L)) {
                throw new ArithmeticException();
            }
            finiteDuration = FiniteDuration$.MODULE$.apply(totalNanos, TimeUnit.NANOSECONDS);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException(new StringBuilder(54).append("Java duration ").append(duration).append(" cannot be expressed as a Scala duration").toString());
        }
        return finiteDuration;
    }

    public Duration toJava(FiniteDuration duration) {
        if (duration.length() == 0L) {
            return Duration.ZERO;
        }
        TimeUnit timeUnit = duration.unit();
        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            return Duration.ofNanos(duration.length());
        }
        TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
        TimeUnit timeUnit5 = timeUnit;
        if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
            return Duration.of(duration.length(), ChronoUnit.MICROS);
        }
        TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
        TimeUnit timeUnit7 = timeUnit;
        if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
            return Duration.ofMillis(duration.length());
        }
        TimeUnit timeUnit8 = TimeUnit.SECONDS;
        TimeUnit timeUnit9 = timeUnit;
        if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
            return Duration.ofSeconds(duration.length());
        }
        TimeUnit timeUnit10 = TimeUnit.MINUTES;
        TimeUnit timeUnit11 = timeUnit;
        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
            return Duration.ofMinutes(duration.length());
        }
        TimeUnit timeUnit12 = TimeUnit.HOURS;
        TimeUnit timeUnit13 = timeUnit;
        if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
            return Duration.ofHours(duration.length());
        }
        TimeUnit timeUnit14 = TimeUnit.DAYS;
        TimeUnit timeUnit15 = timeUnit;
        if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
            return Duration.ofDays(duration.length());
        }
        throw new MatchError((Object)timeUnit);
    }
}

