/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.SeqMap;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.AbstractMap;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.LinkedHashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LinkedHashMap<K, V>
extends AbstractMap<K, V>
implements scala.collection.mutable.SeqMap<K, V>,
StrictOptimizedMapOps<K, V, LinkedHashMap, LinkedHashMap<K, V>>,
DefaultSerializable {
    private LinkedEntry<K, V> firstEntry;
    private LinkedEntry<K, V> lastEntry;
    private LinkedEntry<K, V>[] table;
    private int threshold;
    private int contentSize;

    public static double defaultLoadFactor() {
        return LinkedHashMap$.MODULE$.defaultLoadFactor();
    }

    public static int defaultinitialSize() {
        return LinkedHashMap$.MODULE$.defaultinitialSize();
    }

    public static <K, V> LinkedHashMap<K, V> from(IterableOnce<Tuple2<K, V>> iterableOnce) {
        return LinkedHashMap$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <K, V> GrowableBuilder<Tuple2<K, V>, LinkedHashMap<K, V>> newBuilder() {
        return LinkedHashMap$.MODULE$.newBuilder();
    }

    public LinkedHashMap() {
        SeqMap.$init$(this);
        scala.collection.mutable.SeqMap.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedMapOps.$init$(this);
        DefaultSerializable.$init$(this);
        this.firstEntry = null;
        this.lastEntry = null;
        this.table = new LinkedEntry[this.tableSizeFor(LinkedHashMap$.MODULE$.defaultinitialSize())];
        this.threshold = this.newThreshold(this.table.length);
        this.contentSize = 0;
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Tuple2<K, V>, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<Tuple2<K, V>, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<Tuple2<K, V>, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<Tuple2<K, V>, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<Tuple2<K, V>, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Tuple2<K, V>, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public IterableOps map(Function1 f) {
        return StrictOptimizedMapOps.map$(this, f);
    }

    @Override
    public IterableOps flatMap(Function1 f) {
        return StrictOptimizedMapOps.flatMap$(this, f);
    }

    @Override
    public IterableOps concat(IterableOnce suffix) {
        return StrictOptimizedMapOps.concat$(this, suffix);
    }

    @Override
    public IterableOps collect(PartialFunction pf) {
        return StrictOptimizedMapOps.collect$(this, pf);
    }

    @Override
    public IterableOps $plus(Tuple2 elem1, Tuple2 elem2, Seq elems) {
        return StrictOptimizedMapOps.$plus$(this, elem1, elem2, elems);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    @Override
    public MapFactory<LinkedHashMap> mapFactory() {
        return LinkedHashMap$.MODULE$;
    }

    public LinkedEntry<K, V> _firstEntry() {
        return this.firstEntry();
    }

    public LinkedEntry<K, V> firstEntry() {
        return this.firstEntry;
    }

    public void firstEntry_$eq(LinkedEntry<K, V> x$1) {
        this.firstEntry = x$1;
    }

    public LinkedEntry<K, V> lastEntry() {
        return this.lastEntry;
    }

    public void lastEntry_$eq(LinkedEntry<K, V> x$1) {
        this.lastEntry = x$1;
    }

    @Override
    public Tuple2<K, V> last() {
        if (this.size() > 0) {
            LinkedEntry<K, V> x$proxy1 = this.lastEntry();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            LinkedEntry<K, V> x$proxy2 = this.lastEntry();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return Tuple2$.MODULE$.apply(x$proxy1.key(), x$proxy2.value());
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashMap");
    }

    @Override
    public Option<Tuple2<K, V>> lastOption() {
        if (this.size() > 0) {
            LinkedEntry<K, V> x$proxy3 = this.lastEntry();
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            LinkedEntry<K, V> x$proxy4 = this.lastEntry();
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(x$proxy3.key(), x$proxy4.value()));
        }
        return None$.MODULE$;
    }

    @Override
    public Tuple2<K, V> head() {
        if (this.size() > 0) {
            LinkedEntry<K, V> x$proxy5 = this.firstEntry();
            if (x$proxy5 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            LinkedEntry<K, V> x$proxy6 = this.firstEntry();
            if (x$proxy6 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return Tuple2$.MODULE$.apply(x$proxy5.key(), x$proxy6.value());
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashMap");
    }

    @Override
    public Option<Tuple2<K, V>> headOption() {
        if (this.size() > 0) {
            LinkedEntry<K, V> x$proxy7 = this.firstEntry();
            if (x$proxy7 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            LinkedEntry<K, V> x$proxy8 = this.firstEntry();
            if (x$proxy8 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(x$proxy7.key(), x$proxy8.value()));
        }
        return None$.MODULE$;
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Option<V> get(K key) {
        LinkedEntry<K, V> e = this.findEntry(key);
        if (e == null) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(e.value());
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / LinkedHashMap$.MODULE$.defaultLoadFactor()));
        if (target > this.table.length) {
            this.growTable(target);
            return;
        }
    }

    @Override
    public boolean contains(K key) {
        if (this.getClass() == LinkedHashMap.class) {
            return this.findEntry(key) != null;
        }
        return MapOps.contains$(this, key);
    }

    @Override
    public Option<V> put(K key, V value) {
        Some<V> some = this.put0(key, value, true);
        if (some == null) {
            return None$.MODULE$;
        }
        Some<V> sm = some;
        return sm;
    }

    @Override
    public void update(K key, V value) {
        this.put0(key, value, false);
    }

    @Override
    public Option<V> remove(K key) {
        LinkedEntry<K, V> linkedEntry = this.removeEntry0(key);
        if (linkedEntry == null) {
            return None$.MODULE$;
        }
        LinkedEntry<K, V> nd = linkedEntry;
        return Some$.MODULE$.apply(nd.value());
    }

    @Override
    public <V1> V1 getOrElse(K key, Function0<V1> function0) {
        Class<?> clazz = this.getClass();
        Class<LinkedHashMap> clazz2 = LinkedHashMap.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return (V1)MapOps.getOrElse$(this, key, function0);
        }
        LinkedEntry<K, V> nd = this.findEntry(key);
        if (nd == null) {
            return function0.apply();
        }
        return (V1)nd.value();
    }

    @Override
    public V getOrElseUpdate(K key, Function0<V> defaultValue) {
        LinkedEntry<K, V> nd;
        LinkedEntry<K, V> linkedEntry;
        Class<?> clazz = this.getClass();
        Class<LinkedHashMap> clazz2 = LinkedHashMap.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return (V)scala.collection.mutable.MapOps.getOrElseUpdate$(this, key, defaultValue);
        }
        int hash = this.computeHash(key);
        int idx = this.index(hash);
        LinkedEntry<K, V> linkedEntry2 = this.table[idx];
        if (linkedEntry2 == null) {
            linkedEntry = null;
        } else {
            LinkedEntry<K, V> nd2 = linkedEntry2;
            linkedEntry = nd = nd2.findEntry(key, hash);
        }
        if (nd != null) {
            return nd.value();
        }
        LinkedEntry<K, V>[] table0 = this.table;
        V v = defaultValue.apply();
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.table.length * 2);
        }
        int newIdx = table0 == this.table ? idx : this.index(hash);
        this.put0(key, v, false, hash, newIdx);
        return v;
    }

    private LinkedEntry<K, V> removeEntry0(K elem) {
        return this.removeEntry0(elem, this.computeHash(elem));
    }

    private LinkedEntry<K, V> removeEntry0(K elem, int hash) {
        LinkedEntry<K, V> nd;
        int idx = this.index(hash);
        LinkedEntry<K, V> linkedEntry = this.table[idx];
        if (linkedEntry == null) {
            return null;
        }
        LinkedEntry<K, V> nd2 = linkedEntry;
        if (nd2.hash() == hash && BoxesRunTime.equals(nd2.key(), elem)) {
            this.table[idx] = nd2.next();
            this.deleteEntry(nd2);
            --this.contentSize;
            return nd2;
        }
        LinkedEntry<K, V> prev = nd = linkedEntry;
        LinkedEntry<K, V> next = nd.next();
        while (!(next == null) && next.hash() <= hash) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return next;
            }
            prev = next;
            next = next.next();
        }
        return null;
    }

    private int improveHash(int originalHash) {
        return originalHash ^ originalHash >>> 16;
    }

    public int unimproveHash(int improvedHash) {
        return this.improveHash(improvedHash);
    }

    private int computeHash(K o) {
        return this.improveHash(Statics.anyHash(o));
    }

    private int index(int hash) {
        return hash & this.table.length - 1;
    }

    private LinkedEntry<K, V> findEntry(K key) {
        int hash = this.computeHash(key);
        LinkedEntry<K, V> linkedEntry = this.table[this.index(hash)];
        if (linkedEntry == null) {
            return null;
        }
        LinkedEntry<K, V> nd = linkedEntry;
        return nd.findEntry(key, hash);
    }

    public LinkedHashMap<K, V> addOne(Tuple2<K, V> kv) {
        this.put(kv._1(), kv._2());
        return this;
    }

    public LinkedHashMap<K, V> subtractOne(K key) {
        this.remove(key);
        return this;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new LinkedHashMapIterator<Tuple2<K, V>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Tuple2 extract(LinkedEntry nd) {
                return Tuple2$.MODULE$.apply(nd.key(), nd.value());
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new LinkedKeySet();
    }

    @Override
    public Iterator<K> keysIterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new LinkedHashMapIterator<K>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object extract(LinkedEntry nd) {
                return nd.key();
            }
        };
    }

    public Iterator<LinkedEntry<K, V>> entryIterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new LinkedHashMapIterator<LinkedEntry<K, V>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public LinkedEntry extract(LinkedEntry nd) {
                return nd;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<V> updateWith(K key, Function1<Option<V>, Option<V>> remappingFunction) {
        Serializable serializable;
        Option option;
        Class<?> clazz = this.getClass();
        Class<LinkedHashMap> clazz2 = LinkedHashMap.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return scala.collection.mutable.MapOps.updateWith$(this, key, remappingFunction);
        }
        int hash = this.computeHash(key);
        int indexedHash = this.index(hash);
        ObjectRef<Object> foundEntry = ObjectRef.create(null);
        ObjectRef<Object> previousEntry = ObjectRef.create(null);
        LinkedEntry<K, V> linkedEntry = this.table[indexedHash];
        if (linkedEntry != null) {
            LinkedEntry<K, V> nd = linkedEntry;
            LinkedHashMap.findEntry$1(previousEntry, foundEntry, null, nd, key, hash);
        }
        LinkedEntry linkedEntry2 = (LinkedEntry)foundEntry.elem;
        if (linkedEntry2 == null) {
            option = None$.MODULE$;
        } else {
            LinkedEntry nd = linkedEntry2;
            option = Some$.MODULE$.apply(nd.value());
        }
        None$ previousValue = option;
        Option<V> nextValue = remappingFunction.apply(previousValue);
        Tuple2<None$, Option<V>> tuple2 = Tuple2$.MODULE$.apply(previousValue, nextValue);
        Option option2 = tuple2._1();
        Option<V> option3 = tuple2._2();
        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3)) {
            serializable = BoxedUnit.UNIT;
            return nextValue;
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            if (None$.MODULE$.equals(option3)) {
                if ((LinkedEntry)previousEntry.elem != null) {
                    LinkedEntry x$proxy17 = (LinkedEntry)previousEntry.elem;
                    if (x$proxy17 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    LinkedEntry x$proxy18 = (LinkedEntry)foundEntry.elem;
                    if (x$proxy18 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy17.next_$eq(x$proxy18.next());
                } else {
                    LinkedEntry x$proxy19 = (LinkedEntry)foundEntry.elem;
                    if (x$proxy19 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    this.table[indexedHash] = x$proxy19.next();
                }
                LinkedEntry x$proxy20 = (LinkedEntry)foundEntry.elem;
                if (x$proxy20 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.deleteEntry(x$proxy20);
                --this.contentSize;
                serializable = BoxedUnit.UNIT;
                return nextValue;
            }
        }
        if (None$.MODULE$.equals(option2) && option3 instanceof Some) {
            int n;
            Some some = (Some)option3;
            Object value = some.value();
            if (this.contentSize + 1 >= this.threshold) {
                this.growTable(this.table.length * 2);
                n = this.index(hash);
            } else {
                n = indexedHash;
            }
            int newIndexedHash = n;
            serializable = this.put0(key, value, false, hash, newIndexedHash);
            return nextValue;
        }
        if (!(option2 instanceof Some)) throw new MatchError(tuple2);
        Some some = (Some)option2;
        if (!(option3 instanceof Some)) throw new MatchError(tuple2);
        Some some2 = (Some)option3;
        Object newValue = some2.value();
        LinkedEntry x$proxy21 = (LinkedEntry)foundEntry.elem;
        if (x$proxy21 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        x$proxy21.value_$eq(newValue);
        serializable = BoxedUnit.UNIT;
        return nextValue;
    }

    @Override
    public Iterator<V> valuesIterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new LinkedHashMapIterator<V>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object extract(LinkedEntry nd) {
                return nd.value();
            }
        };
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        LinkedEntry<K, V> cur = this.firstEntry();
        while (!(cur == null)) {
            f.apply(Tuple2$.MODULE$.apply(cur.key(), cur.value()));
            cur = cur.later();
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        LinkedEntry<K, V> cur = this.firstEntry();
        while (!(cur == null)) {
            f.apply(cur.key(), cur.value());
            cur = cur.later();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.contentSize = 0;
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private int tableSizeFor(int capacity) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(Integer.highestOneBit(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(capacity - 1), 4)) * 2), 0x40000000);
    }

    private int newThreshold(int size) {
        return (int)((double)size * LinkedHashMap$.MODULE$.defaultLoadFactor());
    }

    private LinkedEntry<K, V> createNewEntry(K key, int hash, V value) {
        LinkedEntry<K, V> e = new LinkedEntry<K, V>(key, hash, value);
        if (this.firstEntry() == null) {
            this.firstEntry_$eq(e);
        } else {
            LinkedEntry<K, V> x$proxy27 = this.lastEntry();
            if (x$proxy27 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy27.later_$eq(e);
            e.earlier_$eq(this.lastEntry());
        }
        this.lastEntry_$eq(e);
        return e;
    }

    private void deleteEntry(LinkedEntry<K, V> e) {
        if (e.earlier() == null) {
            this.firstEntry_$eq(e.later());
        } else {
            LinkedEntry<K, V> x$proxy29 = e.earlier();
            if (x$proxy29 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy29.later_$eq(e.later());
        }
        if (e.later() == null) {
            this.lastEntry_$eq(e.earlier());
        } else {
            LinkedEntry<K, V> x$proxy31 = e.later();
            if (x$proxy31 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy31.earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        e.next_$eq(null);
    }

    private Some<V> put0(K key, V value, boolean getOld) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.table.length * 2);
        }
        int hash = this.computeHash(key);
        int idx = this.index(hash);
        return this.put0(key, value, getOld, hash, idx);
    }

    private Some<V> put0(K key, V value, boolean getOld, int hash, int idx) {
        LinkedEntry<K, V> linkedEntry = this.table[idx];
        if (linkedEntry == null) {
            this.table[idx] = this.createNewEntry(key, hash, value);
        } else {
            LinkedEntry<K, V> old = linkedEntry;
            LinkedEntry<K, V> prev = null;
            LinkedEntry<K, V> n = old;
            while (!(n == null) && n.hash() <= hash) {
                if (n.hash() == hash && BoxesRunTime.equals(key, n.key())) {
                    V old2 = n.value();
                    n.value_$eq(value);
                    if (getOld) {
                        return Some$.MODULE$.apply(old2);
                    }
                    return null;
                }
                prev = n;
                n = n.next();
            }
            LinkedEntry<K, V> nnode = this.createNewEntry(key, hash, value);
            if (prev == null) {
                nnode.next_$eq(old);
                this.table[idx] = nnode;
            } else {
                nnode.next_$eq(prev.next());
                prev.next_$eq(nnode);
            }
        }
        ++this.contentSize;
        return null;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(36).append("new hash table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = this.newThreshold(newlen);
        if (this.size() == 0) {
            this.table = new LinkedEntry[newlen];
            return;
        }
        this.table = Arrays.copyOf(this.table, newlen);
        LinkedEntry<Object, Object> preLow = new LinkedEntry<Object, Object>(null, 0, null);
        LinkedEntry<Object, Object> preHigh = new LinkedEntry<Object, Object>(null, 0, null);
        for (int oldlen = this.table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                LinkedEntry<K, V> old = this.table[i];
                if (!(!(old == null))) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                LinkedEntry<Object, Object> lastLow = preLow;
                LinkedEntry<Object, Object> lastHigh = preHigh;
                LinkedEntry<K, V> n = old;
                while (!(n == null)) {
                    LinkedEntry<K, V> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (!(old == preLow.next())) {
                    this.table[i] = preLow.next();
                }
                if (!(!(preHigh.next() == null))) continue;
                this.table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return MurmurHash3$.MODULE$.emptyMapHash();
        }
        LinkedHashMapIterator<Object> tupleHashIterator = new LinkedHashMapIterator<Object>(this){
            private int hash;
            private final /* synthetic */ LinkedHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hash = 0;
            }

            public int hash() {
                return this.hash;
            }

            public void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            public Object extract(LinkedEntry nd) {
                this.hash_$eq(MurmurHash3$.MODULE$.tuple2Hash(BoxesRunTime.boxToInteger(this.$outer.unimproveHash(nd.hash())), BoxesRunTime.boxToInteger(Statics.anyHash(nd.value()))));
                return this;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)tupleHashIterator, MurmurHash3$.MODULE$.mapSeed());
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashMap";
    }

    private static final void findEntry$1(ObjectRef previousEntry$1, ObjectRef foundEntry$1, LinkedEntry prev, LinkedEntry nd, Object k, int h) {
        while (true) {
            if (h == nd.hash() && BoxesRunTime.equals(k, nd.key())) {
                previousEntry$1.elem = prev;
                foundEntry$1.elem = nd;
                return;
            }
            if (nd.next() == null || nd.hash() > h) {
                return;
            }
            LinkedEntry linkedEntry = nd;
            LinkedEntry x$proxy16 = nd.next();
            if (x$proxy16 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            LinkedEntry linkedEntry2 = x$proxy16;
            prev = linkedEntry;
            nd = linkedEntry2;
        }
    }

    public static final class LinkedEntry<K, V> {
        private final K key;
        private final int hash;
        private V value;
        private LinkedEntry<K, V> earlier;
        private LinkedEntry<K, V> later;
        private LinkedEntry<K, V> next;

        public LinkedEntry(K key, int hash, V value) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }

        public K key() {
            return this.key;
        }

        public int hash() {
            return this.hash;
        }

        public V value() {
            return this.value;
        }

        public void value_$eq(V x$1) {
            this.value = x$1;
        }

        public LinkedEntry<K, V> earlier() {
            return this.earlier;
        }

        public void earlier_$eq(LinkedEntry<K, V> x$1) {
            this.earlier = x$1;
        }

        public LinkedEntry<K, V> later() {
            return this.later;
        }

        public void later_$eq(LinkedEntry<K, V> x$1) {
            this.later = x$1;
        }

        public LinkedEntry<K, V> next() {
            return this.next;
        }

        public void next_$eq(LinkedEntry<K, V> x$1) {
            this.next = x$1;
        }

        /*
         * WARNING - void declaration
         */
        public final LinkedEntry<K, V> findEntry(K k, int h) {
            while (h != this_.hash() || !BoxesRunTime.equals(k, this_.key())) {
                void var3_3;
                if (this_.next() == null || this_.hash() > h) {
                    return null;
                }
                LinkedEntry<K, V> x$proxy42 = this_.next();
                if (x$proxy42 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                LinkedEntry this_ = var3_3;
            }
            return this_;
        }
    }

    public abstract class LinkedHashMapIterator<T>
    extends AbstractIterator<T> {
        private LinkedEntry<K, V> cur;

        public LinkedHashMapIterator() {
            if (LinkedHashMap.this == null) {
                throw new NullPointerException();
            }
            this.cur = LinkedHashMap.this.firstEntry();
        }

        public abstract T extract(LinkedEntry<K, V> var1);

        @Override
        public boolean hasNext() {
            return !(this.cur == null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            if (this.hasNext()) {
                void var2_1;
                LinkedEntry x$proxy13 = this.cur;
                if (x$proxy13 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                T r = this.extract((LinkedEntry)var2_1);
                LinkedEntry x$proxy14 = this.cur;
                if (x$proxy14 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.cur = x$proxy14.later();
                return r;
            }
            return (T)Iterator$.MODULE$.empty().next();
        }

        public final /* synthetic */ LinkedHashMap scala$collection$mutable$LinkedHashMap$LinkedHashMapIterator$$$outer() {
            return LinkedHashMap.this;
        }
    }

    public class LinkedKeySet
    extends MapOps.KeySet {
        public LinkedKeySet() {
            if (LinkedHashMap.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public IterableFactory<Set> iterableFactory() {
            return LinkedHashSet$.MODULE$;
        }

        public final /* synthetic */ LinkedHashMap scala$collection$mutable$LinkedHashMap$LinkedKeySet$$$outer() {
            return LinkedHashMap.this;
        }
    }
}

