/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$partitioner$2$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.Scala3RunTime$;
import scala.sys.package$;

public final class RedBlackTree$
implements Serializable {
    private static final Tuple2<Null$, Null$> null2;
    public static final RedBlackTree$ MODULE$;

    private RedBlackTree$() {
    }

    static {
        MODULE$ = new RedBlackTree$();
        null2 = Tuple2$.MODULE$.apply(null, null);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RedBlackTree$.class);
    }

    public <A> RedBlackTree.Tree<A, ?> validate(RedBlackTree.Tree<A, ?> tree, Ordering<A> ordering) {
        if (tree != null) {
            this.impl$1(ordering, tree, (Function1<Object, Boolean> & Serializable)_$1 -> true);
        }
        return tree;
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return !(this.lookup(tree, x, evidence$1) == null);
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$1) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$1);
        if (tree2 == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Tree<A, B> found = tree2;
        return Some$.MODULE$.apply(found.value());
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp < 0) {
                tree = tree.left();
                continue;
            }
            if (cmp <= 0) break;
            tree = tree.right();
        }
        return tree;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.count();
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$1) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$1));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$1) {
        return this.blacken(this.del(tree, k, evidence$1));
    }

    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$1) {
        Tuple2<Option<A>, Option<A>> tuple2 = Tuple2$.MODULE$.apply(from, until);
        Option<A> option = tuple2._1();
        Option<A> option2 = tuple2._2();
        if (option instanceof Some) {
            Object a;
            Some some = (Some)option;
            Object from2 = a = some.value();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Object until2 = some2.value();
                return this.range(tree, from2, until2, evidence$1);
            }
            Object from3 = a;
            if (None$.MODULE$.equals(option2)) {
                return this.from(tree, from3, evidence$1);
            }
        }
        if (None$.MODULE$.equals(option)) {
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object until3 = some.value();
                return this.until(tree, until3, evidence$1);
            }
            if (None$.MODULE$.equals(option2)) {
                return tree;
            }
        }
        throw new MatchError(tuple2);
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$1) {
        return this.blacken(this.doRange(tree, from, until, evidence$1));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$1) {
        return this.blacken(this.doFrom(tree, from, evidence$1));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$1) {
        return this.blacken(this.doTo(tree, to, evidence$1));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$1) {
        return this.blacken(this.doUntil(tree, key, evidence$1));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$1) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$1) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$1) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (!(result.left() == null)) {
            void var3_3;
            RedBlackTree.Tree<A, B> x$proxy9 = result.left();
            if (x$proxy9 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            result = var3_3;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (!(result.right() == null)) {
            void var3_3;
            RedBlackTree.Tree<A, B> x$proxy12 = result.right();
            if (x$proxy12 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            result = var3_3;
        }
        return result;
    }

    public <A, B> RedBlackTree.Tree<A, B> tail(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._tail$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> init(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._init$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> minAfter(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (!(tree == null)) {
            int cmp = ordering.compare(x, tree.key());
            if (cmp == 0) {
                return tree;
            }
            if (cmp < 0) {
                RedBlackTree.Tree<A, B> l = this.minAfter(tree.left(), x, ordering);
                if (l != null) {
                    return l;
                }
                return tree;
            }
            tree = tree.right();
        }
        return null;
    }

    public <A, B> RedBlackTree.Tree<A, B> maxBefore(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp > 0) break;
            tree = tree.left();
        }
        RedBlackTree.Tree<A, B> r = this.maxBefore(tree.right(), x, ordering);
        if (r != null) {
            return r;
        }
        return tree;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (!(tree == null)) {
            this._foreach(tree, f);
            return;
        }
    }

    public <A, X, Y> boolean keysEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$1) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$1).sameKeys(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$1));
    }

    public <A, X, Y> boolean valuesEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$1) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$1).sameValues(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$1));
    }

    public <A, X, Y> boolean entriesEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$1) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$1).sameEntries(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$1));
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (!(tree.left() == null)) {
                void var3_3;
                RedBlackTree.Tree<A, B> x$proxy15 = tree.left();
                if (x$proxy15 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this._foreach((RedBlackTree.Tree<A, B>)var3_3, f);
            }
            f.apply(Tuple2$.MODULE$.apply(tree.key(), tree.value()));
            if (!(!(tree.right() == null))) break;
            RedBlackTree.Tree<A, B> x$proxy18 = tree.right();
            if (x$proxy18 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            tree = x$proxy18;
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (!(tree == null)) {
            this._foreachKey(tree, f);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (!(tree.left() == null)) {
                void var3_3;
                RedBlackTree.Tree<A, ?> x$proxy21 = tree.left();
                if (x$proxy21 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this._foreachKey((RedBlackTree.Tree<A, ?>)var3_3, f);
            }
            f.apply(tree.key());
            if (!(!(tree.right() == null))) break;
            RedBlackTree.Tree<A, ?> x$proxy24 = tree.right();
            if (x$proxy24 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            tree = x$proxy24;
        }
    }

    public <A, B, U> void foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        if (!(tree == null)) {
            this._foreachEntry(tree, f);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, U> void _foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        while (true) {
            if (!(tree.left() == null)) {
                void var3_3;
                RedBlackTree.Tree<A, B> x$proxy27 = tree.left();
                if (x$proxy27 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this._foreachEntry((RedBlackTree.Tree<A, B>)var3_3, f);
            }
            f.apply(tree.key(), tree.value());
            if (!(!(tree.right() == null))) break;
            RedBlackTree.Tree<A, B> x$proxy30 = tree.right();
            if (x$proxy30 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            tree = x$proxy30;
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$1) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$1);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$1) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$1);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$1) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$1);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                RedBlackTree.Tree<A, B> x$proxy31 = tree.left();
                if (x$proxy31 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                tree = x$proxy31;
                continue;
            }
            if (n <= count) break;
            RedBlackTree.Tree<A, B> x$proxy32 = tree.right();
            if (x$proxy32 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Tree<A, B> tree2 = x$proxy32;
            int n2 = n - count - 1;
            tree = tree2;
            n = n2;
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || tree.isBlack();
    }

    public boolean scala$collection$immutable$RedBlackTree$$$isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return !(tree == null) && tree.isRed();
    }

    private boolean isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return !(tree == null) && tree.isBlack();
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        if (t == null) {
            return null;
        }
        return t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> maybeBlacken(RedBlackTree.Tree<A, B> t) {
        if (this.isBlack(t)) {
            return t;
        }
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(t.left()) || this.scala$collection$immutable$RedBlackTree$$$isRedTree(t.right())) {
            return t.black();
        }
        return t;
    }

    private <A, B> RedBlackTree.Tree<A, Nothing$> mkTree(boolean isBlack, A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        int sizeAndColour = this.sizeOf(left) + this.sizeOf(right) + 1 | (isBlack ? Integer.MIN_VALUE : 0);
        return new RedBlackTree.Tree(key, value, left, right, sizeAndColour);
    }

    private <A, B1> RedBlackTree.Tree<A, B1> balanceLeft(RedBlackTree.Tree<A, B1> tree, RedBlackTree.Tree<A, B1> newLeft) {
        if (tree.left() == newLeft) {
            return tree;
        }
        if (newLeft.isRed()) {
            RedBlackTree.Tree<A, B1> newLeft_left = newLeft.left();
            RedBlackTree.Tree<A, B1> newLeft_right = newLeft.right();
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(newLeft_left)) {
                if (newLeft_left == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B1> resultLeft = newLeft_left.black();
                RedBlackTree.Tree<A, B1> resultRight = tree.blackWithLeft(newLeft_right);
                return newLeft.withLeftRight(resultLeft, resultRight);
            }
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(newLeft_right)) {
                if (newLeft_right == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B1> newLeft_right_right = newLeft_right.right();
                if (newLeft_right == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B1> resultLeft = newLeft.blackWithRight(newLeft_right.left());
                RedBlackTree.Tree<A, B1> resultRight = tree.blackWithLeft(newLeft_right_right);
                if (newLeft_right == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return newLeft_right.withLeftRight(resultLeft, resultRight);
            }
            return tree.withLeft(newLeft);
        }
        return tree.withLeft(newLeft);
    }

    private <A, B1> RedBlackTree.Tree<A, B1> balanceRight(RedBlackTree.Tree<A, B1> tree, RedBlackTree.Tree<A, B1> newRight) {
        if (tree.right() == newRight) {
            return tree;
        }
        if (newRight.isRed()) {
            RedBlackTree.Tree<A, B1> newRight_left = newRight.left();
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(newRight_left)) {
                if (newRight_left == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B1> resultLeft = tree.blackWithRight(newRight_left.left());
                if (newRight_left == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B1> resultRight = newRight.blackWithLeft(newRight_left.right());
                if (newRight_left == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return newRight_left.withLeftRight(resultLeft, resultRight);
            }
            RedBlackTree.Tree<A, B1> newRight_right = newRight.right();
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(newRight_right)) {
                RedBlackTree.Tree<A, B1> resultLeft = tree.blackWithRight(newRight_left);
                if (newRight_right == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B1> resultRight = newRight_right.black();
                return newRight.withLeftRight(resultLeft, resultRight);
            }
            return tree.withRight(newRight);
        }
        return tree.withRight(newRight);
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        if (tree == null) {
            return this.RedTree(k, v, null, null);
        }
        if (k == tree.key()) {
            if (overwrite) {
                return tree.withV(v);
            }
            return tree;
        }
        int cmp = ordering.compare(k, tree.key());
        if (cmp < 0) {
            return this.balanceLeft(tree, this.upd(tree.left(), k, v, overwrite, ordering));
        }
        if (cmp > 0) {
            return this.balanceRight(tree, this.upd(tree.right(), k, v, overwrite, ordering));
        }
        if (overwrite && v != tree.value()) {
            return tree.withV(v);
        }
        return tree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v) {
        if (tree == null) {
            return this.RedTree(k, v, null, null);
        }
        int rank = this.count(tree.left()) + 1;
        if (idx < rank) {
            return this.balanceLeft(tree, this.updNth(tree.left(), idx, k, v));
        }
        if (idx > rank) {
            return this.balanceRight(tree, this.updNth(tree.right(), idx - rank, k, v));
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (!ordering.lt(tree.key(), from)) break;
            tree = tree.right();
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        if (newLeft == tree.left()) {
            return tree;
        }
        if (newLeft == null) {
            return this.maybeBlacken(this.upd(tree.right(), tree.key(), tree.value(), false, ordering));
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(newLeft, tree.key(), tree.value(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (!ordering.lt(to, tree.key())) break;
            tree = tree.left();
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.maybeBlacken(this.upd(tree.left(), tree.key(), tree.value(), false, ordering));
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(tree.left(), tree.key(), tree.value(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (!ordering.lteq(until, tree.key())) break;
            tree = tree.left();
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.maybeBlacken(this.upd(tree.left(), tree.key(), tree.value(), false, ordering));
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(tree.left(), tree.key(), tree.value(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (ordering.lt(tree.key(), from)) {
                tree = tree.right();
                continue;
            }
            if (!ordering.lteq(until, tree.key())) break;
            tree = tree.left();
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        if (newLeft == tree.left() && newRight == tree.right()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.key(), tree.value(), false, ordering);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.key(), tree.value(), false, ordering);
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(newLeft, tree.key(), tree.value(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return tree;
            }
            if (n >= tree.count()) {
                return null;
            }
            l = this.count(tree.left());
            if (n <= l) break;
            RedBlackTree.Tree<A, B> tree2 = tree.right();
            int n2 = n - l - 1;
            tree = tree2;
            n = n2;
        }
        if (n == l) {
            return this.scala$collection$immutable$RedBlackTree$$$join(null, tree.key(), tree.value(), tree.right());
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(this.doDrop(tree.left(), n), tree.key(), tree.value(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return null;
            }
            if (n >= tree.count()) {
                return tree;
            }
            l = this.count(tree.left());
            if (n > l) break;
            tree = tree.left();
        }
        if (n == l + 1) {
            return this.maybeBlacken(this.updNth(tree.left(), n, tree.key(), tree.value()));
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(tree.left(), tree.key(), tree.value(), this.doTake(tree.right(), n - l - 1));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        int l;
        while (true) {
            if (tree == null || from >= until || from >= tree.count() || until <= 0) {
                return null;
            }
            if (from <= 0 && until >= tree.count()) {
                return tree;
            }
            l = this.count(tree.left());
            if (until <= l) {
                tree = tree.left();
                continue;
            }
            if (from <= l) break;
            RedBlackTree.Tree<A, B> tree2 = tree.right();
            int n = from - l - 1;
            int n2 = until - l - 1;
            tree = tree2;
            from = n;
            until = n2;
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(this.doDrop(tree.left(), from), tree.key(), tree.value(), this.doTake(tree.right(), until - l - 1));
    }

    public final int colourBit() {
        return Integer.MIN_VALUE;
    }

    public final int colourMask() {
        return Integer.MAX_VALUE;
    }

    public final int initialBlackCount() {
        return Integer.MIN_VALUE;
    }

    public final int initialRedCount() {
        return 0;
    }

    public <A, B> RedBlackTree.Tree<A, B> mutableRedTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return new RedBlackTree.Tree(key, value, left, right, 0);
    }

    public <A, B> RedBlackTree.Tree<A, B> mutableBlackTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return new RedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE);
    }

    public <A, B> RedBlackTree.Tree<A, B> RedTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        int size = this.sizeOf(left) + this.sizeOf(right) + 1;
        return new RedBlackTree.Tree(key, value, left, right, 0 | size);
    }

    public <A, B> RedBlackTree.Tree<A, B> BlackTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        int size = this.sizeOf(left) + this.sizeOf(right) + 1;
        return new RedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE | size);
    }

    private int sizeOf(RedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.count();
    }

    public <A> RedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$2(maxUsedDepth, xs, 1, size);
    }

    public <A, B> RedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$3(xs, maxUsedDepth, 1, size);
    }

    public <A, B, C> RedBlackTree.Tree<A, C> transform(RedBlackTree.Tree<A, B> t, Function2<A, B, C> f) {
        if (t == null) {
            return null;
        }
        A k = t.key();
        B v = t.value();
        RedBlackTree.Tree<A, B> l = t.left();
        RedBlackTree.Tree<A, B> r = t.right();
        RedBlackTree.Tree<A, C> l2 = this.transform(l, f);
        C v2 = f.apply(k, v);
        RedBlackTree.Tree<A, C> r2 = this.transform(r, f);
        if (v2 == v && l2 == l && r2 == r) {
            return t;
        }
        return this.mkTree(t.isBlack(), k, v2, l2, r2);
    }

    public <A, B> RedBlackTree.Tree<A, B> filterEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> f) {
        if (t == null) {
            return null;
        }
        return this.blacken(this.fk$1(f, t));
    }

    public <A, B> Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> partitionEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> p) {
        if (t == null) {
            return Tuple2$.MODULE$.apply(null, null);
        }
        if (t == null) {
            return null2;
        }
        LazyRef lazyRef = new LazyRef();
        this.partitioner$1(lazyRef, p).fk(t);
        return Tuple2$.MODULE$.apply(this.blacken(this.partitioner$1(lazyRef, p).tmpk()), this.blacken(this.partitioner$1(lazyRef, p).tmpd()));
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        int cmp = ordering.compare(k, tree.key());
        if (cmp < 0) {
            RedBlackTree.Tree<A, B> newLeft = this.del(tree.left(), k, ordering);
            if (newLeft == tree.left()) {
                return tree;
            }
            if (this.isBlackTree(tree.left())) {
                return this.balLeft(tree, newLeft, tree.right());
            }
            return tree.redWithLeft(newLeft);
        }
        if (cmp > 0) {
            RedBlackTree.Tree<A, B> newRight = this.del(tree.right(), k, ordering);
            if (newRight == tree.right()) {
                return tree;
            }
            if (this.isBlackTree(tree.right())) {
                return this.balRight(tree, tree.left(), newRight);
            }
            return tree.redWithRight(newRight);
        }
        return this.append(tree.left(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> balance(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tl)) {
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr)) {
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return tree.redWithLeftRight(tl.black(), tr.black());
            }
            if (tl == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tl.left())) {
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy100 = tl.left();
                if (x$proxy100 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return tl.withLeftRight(x$proxy100.black(), tree.blackWithLeftRight(tl.right(), tr));
            }
            if (tl == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tl.right())) {
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy101 = tl.right();
                if (x$proxy101 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy102 = tl.right();
                if (x$proxy102 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy103 = tl.right();
                if (x$proxy103 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return x$proxy101.withLeftRight(tl.blackWithRight(x$proxy102.left()), tree.blackWithLeftRight(x$proxy103.right(), tr));
            }
            return tree.blackWithLeftRight(tl, tr);
        }
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr)) {
            if (tr == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr.right())) {
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy104 = tr.right();
                if (x$proxy104 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return tr.withLeftRight(tree.blackWithLeftRight(tl, tr.left()), x$proxy104.black());
            }
            if (tr == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr.left())) {
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy105 = tr.left();
                if (x$proxy105 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy106 = tr.left();
                if (x$proxy106 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy107 = tr.left();
                if (x$proxy107 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return x$proxy105.withLeftRight(tree.blackWithLeftRight(tl, x$proxy106.left()), tr.blackWithLeftRight(x$proxy107.right(), tr.right()));
            }
            return tree.blackWithLeftRight(tl, tr);
        }
        return tree.blackWithLeftRight(tl, tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> balLeft(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tl)) {
            if (tl == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return tree.redWithLeftRight(tl.black(), tr);
        }
        if (this.isBlackTree(tr)) {
            if (tr == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return this.balance(tree, tl, tr.red());
        }
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr)) {
            if (tr == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (this.isBlackTree(tr.left())) {
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy108 = tr.left();
                if (x$proxy108 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy109 = tr.left();
                if (x$proxy109 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy110 = tr.left();
                if (x$proxy110 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tr == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy111 = tr.right();
                if (x$proxy111 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return x$proxy108.redWithLeftRight(tree.blackWithLeftRight(tl, x$proxy109.left()), this.balance(tr, x$proxy110.right(), x$proxy111.red()));
            }
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private <A, B> RedBlackTree.Tree<A, B> balRight(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr)) {
            if (tr == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return tree.redWithLeftRight(tl, tr.black());
        }
        if (this.isBlackTree(tl)) {
            if (tl == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return this.balance(tree, tl.red(), tr);
        }
        if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tl)) {
            if (tl == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (this.isBlackTree(tl.right())) {
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy112 = tl.right();
                if (x$proxy112 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy113 = tl.left();
                if (x$proxy113 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy114 = tl.right();
                if (x$proxy114 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (tl == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Tree<A, B> x$proxy115 = tl.right();
                if (x$proxy115 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return x$proxy112.redWithLeftRight(this.balance(tl, x$proxy113.red(), x$proxy114.left()), tree.blackWithLeftRight(x$proxy115.right(), tr));
            }
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private <A, B> RedBlackTree.Tree<A, B> append(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (tl.isRed()) {
            if (tr.isRed()) {
                RedBlackTree.Tree<A, B> bc = this.append(tl.right(), tr.left());
                if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(bc)) {
                    if (bc == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (bc == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (bc == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    return bc.withLeftRight(tl.withRight(bc.left()), tr.withLeft(bc.right()));
                }
                return tl.withRight(tr.withLeft(bc));
            }
            return tl.withRight(this.append(tl.right(), tr));
        }
        if (tr.isBlack()) {
            RedBlackTree.Tree<A, B> bc = this.append(tl.right(), tr.left());
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(bc)) {
                if (bc == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (bc == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (bc == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return bc.withLeftRight(tl.withRight(bc.left()), tr.withLeft(bc.right()));
            }
            return this.balLeft(tl, tl.left(), tr.withLeft(bc));
        }
        return tr.withLeft(this.append(tl, tr.left()));
    }

    public <A, B> RedBlackTree.Tree<A, B> union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._union(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._intersect(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, ?> t2, Ordering<A> ordering) {
        return this.blacken(this._difference(t1, t2, ordering));
    }

    private int rank(RedBlackTree.Tree<?, ?> t, int bh) {
        if (t == null) {
            return 0;
        }
        if (t.isBlack()) {
            return 2 * (bh - 1);
        }
        return 2 * bh - 1;
    }

    private <A, B> RedBlackTree.Tree<A, B> joinRight(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int bhtl, int rtr) {
        int rtl = this.rank(tl, bhtl);
        if (rtl == rtr / 2 * 2) {
            return this.RedTree(k, v, tl, tr);
        }
        if (tl == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        RedBlackTree.Tree<A, B> tlnn = tl;
        boolean tlBlack = this.isBlackTree(tl);
        int bhtlr = tlBlack ? bhtl - 1 : bhtl;
        RedBlackTree.Tree<A, B> ttr = this.joinRight(tlnn.right(), k, v, tr, bhtlr, rtr);
        if (tlBlack && this.scala$collection$immutable$RedBlackTree$$$isRedTree(ttr) && this.scala$collection$immutable$RedBlackTree$$$isRedTree(ttr.right())) {
            RedBlackTree.Tree<A, B> x$proxy116 = ttr.right();
            if (x$proxy116 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return this.RedTree(ttr.key(), ttr.value(), this.BlackTree(tlnn.key(), tlnn.value(), tlnn.left(), ttr.left()), x$proxy116.black());
        }
        return this.mkTree(tlBlack, tlnn.key(), tlnn.value(), tlnn.left(), ttr);
    }

    private <A, B> RedBlackTree.Tree<A, B> joinLeft(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int rtl, int bhtr) {
        int rtr = this.rank(tr, bhtr);
        if (rtr == rtl / 2 * 2) {
            return this.RedTree(k, v, tl, tr);
        }
        if (tr == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        RedBlackTree.Tree<A, B> trnn = tr;
        boolean trBlack = this.isBlackTree(tr);
        int bhtrl = trBlack ? bhtr - 1 : bhtr;
        RedBlackTree.Tree<A, B> ttl = this.joinLeft(tl, k, v, trnn.left(), rtl, bhtrl);
        if (trBlack && this.scala$collection$immutable$RedBlackTree$$$isRedTree(ttl) && this.scala$collection$immutable$RedBlackTree$$$isRedTree(ttl.left())) {
            RedBlackTree.Tree<A, B> x$proxy117 = ttl.left();
            if (x$proxy117 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return this.RedTree(ttl.key(), ttl.value(), x$proxy117.black(), this.BlackTree(trnn.key(), trnn.value(), ttl.right(), trnn.right()));
        }
        return this.mkTree(trBlack, trnn.key(), trnn.value(), ttl, trnn.right());
    }

    public <A, B> RedBlackTree.Tree<A, B> scala$collection$immutable$RedBlackTree$$$join(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr) {
        int bhtr;
        int bhtl = this.h$1(tl, 0);
        if (bhtl > (bhtr = this.h$1(tr, 0))) {
            RedBlackTree.Tree<A, B> tt = this.joinRight(tl, k, v, tr, bhtl, this.rank(tr, bhtr));
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tt) && this.scala$collection$immutable$RedBlackTree$$$isRedTree(tt.right())) {
                return tt.black();
            }
            return tt;
        }
        if (bhtr > bhtl) {
            RedBlackTree.Tree<A, B> tt = this.joinLeft(tl, k, v, tr, this.rank(tl, bhtl), bhtr);
            if (this.scala$collection$immutable$RedBlackTree$$$isRedTree(tt) && this.scala$collection$immutable$RedBlackTree$$$isRedTree(tt.left())) {
                return tt.black();
            }
            return tt;
        }
        return this.mkTree(this.scala$collection$immutable$RedBlackTree$$$isRedTree(tl) || this.scala$collection$immutable$RedBlackTree$$$isRedTree(tr), k, v, tl, tr);
    }

    private <A, B> Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> split(RedBlackTree.Tree<A, B> t, A k2, Ordering<A> ordering) {
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4;
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> $7$;
        if (t == null) {
            return Tuple4$.MODULE$.apply(null, null, null, k2);
        }
        int cmp = ordering.compare(k2, t.key());
        if (cmp == 0) {
            return Tuple4$.MODULE$.apply(t.left(), t, t.right(), t.key());
        }
        if (cmp < 0) {
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple42;
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> $5$;
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple43 = $5$ = (tuple42 = this.split(t.left(), k2, ordering));
            RedBlackTree.Tree<A, B> ll = tuple43._1();
            RedBlackTree.Tree<A, B> b = tuple43._2();
            RedBlackTree.Tree<A, B> lr = tuple43._3();
            A k1 = tuple43._4();
            return Tuple4$.MODULE$.apply(ll, b, this.scala$collection$immutable$RedBlackTree$$$join(lr, t.key(), t.value(), t.right()), k1);
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple44 = $7$ = (tuple4 = this.split(t.right(), k2, ordering));
        RedBlackTree.Tree<A, B> rl = tuple44._1();
        RedBlackTree.Tree<A, B> b = tuple44._2();
        RedBlackTree.Tree<A, B> rr = tuple44._3();
        A k1 = tuple44._4();
        return Tuple4$.MODULE$.apply(this.scala$collection$immutable$RedBlackTree$$$join(t.left(), t.key(), t.value(), rl), b, rr, k1);
    }

    private <A, B> Tuple3<RedBlackTree.Tree<A, B>, A, B> splitLast(RedBlackTree.Tree<A, B> t) {
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3;
        Tuple3<RedBlackTree.Tree<A, B>, A, B> $9$;
        if (t.right() == null) {
            return Tuple3$.MODULE$.apply(t.left(), t.key(), t.value());
        }
        RedBlackTree.Tree<A, B> x$proxy119 = t.right();
        if (x$proxy119 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple32 = $9$ = (tuple3 = this.splitLast(x$proxy119));
        RedBlackTree.Tree<A, B> tt = tuple32._1();
        A kk = tuple32._2();
        B vv = tuple32._3();
        return Tuple3$.MODULE$.apply(this.scala$collection$immutable$RedBlackTree$$$join(t.left(), t.key(), t.value(), tt), kk, vv);
    }

    public <A, B> RedBlackTree.Tree<A, B> scala$collection$immutable$RedBlackTree$$$join2(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3;
        Tuple3<RedBlackTree.Tree<A, B>, A, B> $11$;
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple32 = $11$ = (tuple3 = this.splitLast(tl));
        RedBlackTree.Tree<A, B> ttl = tuple32._1();
        A k = tuple32._2();
        B v = tuple32._3();
        return this.scala$collection$immutable$RedBlackTree$$$join(ttl, k, v, tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> _union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4;
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> $13$;
        if (t1 == null || t1 == t2) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple42 = $13$ = (tuple4 = this.split(t1, t2.key(), ordering));
        RedBlackTree.Tree<A, B> l1 = tuple42._1();
        RedBlackTree.Tree<A, B> r1 = tuple42._3();
        A k1 = tuple42._4();
        RedBlackTree.Tree<A, B> tl = this._union(l1, t2.left(), ordering);
        RedBlackTree.Tree<A, B> tr = this._union(r1, t2.right(), ordering);
        return this.scala$collection$immutable$RedBlackTree$$$join(tl, k1, t2.value(), tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> _intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4;
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> $15$;
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1 == t2) {
            return t1;
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple42 = $15$ = (tuple4 = this.split(t1, t2.key(), ordering));
        RedBlackTree.Tree<A, B> l1 = tuple42._1();
        RedBlackTree.Tree<A, B> b = tuple42._2();
        RedBlackTree.Tree<A, B> r1 = tuple42._3();
        A k1 = tuple42._4();
        RedBlackTree.Tree<A, B> tl = this._intersect(l1, t2.left(), ordering);
        RedBlackTree.Tree<A, B> tr = this._intersect(r1, t2.right(), ordering);
        if (!(b == null)) {
            return this.scala$collection$immutable$RedBlackTree$$$join(tl, k1, t2.value(), tr);
        }
        return this.scala$collection$immutable$RedBlackTree$$$join2(tl, tr);
    }

    private <A, B> RedBlackTree.Tree<A, B> _difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4;
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> $17$;
        if (t1 == null || t2 == null) {
            return t1;
        }
        if (t1 == t2) {
            return null;
        }
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple42 = $17$ = (tuple4 = this.split(t1, t2.key(), ordering));
        RedBlackTree.Tree<A, B> l1 = tuple42._1();
        RedBlackTree.Tree<A, B> r1 = tuple42._3();
        RedBlackTree.Tree<A, B> tl = this._difference(l1, t2.left(), ordering);
        RedBlackTree.Tree<A, B> tr = this._difference(r1, t2.right(), ordering);
        return this.scala$collection$immutable$RedBlackTree$$$join2(tl, tr);
    }

    private final int impl$1(Ordering ordering$2, RedBlackTree.Tree tree, Function1 keyProp) {
        int rightBlacks;
        int n;
        int leftBlacks;
        int n2;
        if (!BoxesRunTime.unboxToBoolean(keyProp.apply(tree.key()))) {
            throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(18).append("key check failed: ").append(tree).toString());
        }
        if (tree.isRed()) {
            if (tree.left() != null) {
                RedBlackTree.Tree x$proxy1 = tree.left();
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (!x$proxy1.isBlack()) {
                    throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(13).append("red-red left ").append(tree).toString());
                }
            }
            if (tree.right() != null) {
                RedBlackTree.Tree x$proxy2 = tree.right();
                if (x$proxy2 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (!x$proxy2.isBlack()) {
                    throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(14).append("red-red right ").append(tree).toString());
                }
            }
        }
        if (tree.left() == null) {
            n2 = 0;
        } else {
            RedBlackTree.Tree x$proxy3 = tree.left();
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            n2 = leftBlacks = this.impl$1(ordering$2, x$proxy3, (Function1<Object, Boolean> & Serializable)k -> BoxesRunTime.unboxToBoolean(keyProp.apply(k)) && ordering$2.compare(k, tree.key()) < 0);
        }
        if (tree.right() == null) {
            n = 0;
        } else {
            RedBlackTree.Tree x$proxy4 = tree.right();
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            n = rightBlacks = this.impl$1(ordering$2, x$proxy4, (Function1<Object, Boolean> & Serializable)k -> BoxesRunTime.unboxToBoolean(keyProp.apply(k)) && ordering$2.compare(k, tree.key()) > 0);
        }
        if (leftBlacks != rightBlacks) {
            throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(14).append("not balanced: ").append(tree).toString());
        }
        return leftBlacks + (tree.isBlack() ? 1 : 0);
    }

    private final RedBlackTree.Tree _tail$1(RedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree tl = tree.left();
        if (tl == null) {
            return tree.right();
        }
        if (tl.isBlack()) {
            return this.balLeft(tree, this._tail$1(tl), tree.right());
        }
        return tree.redWithLeft(this._tail$1(tree.left()));
    }

    private final RedBlackTree.Tree _init$1(RedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree tr = tree.right();
        if (tr == null) {
            return tree.left();
        }
        if (tr.isBlack()) {
            return this.balRight(tree, tree.left(), this._init$1(tr));
        }
        return tree.redWithRight(this._init$1(tr));
    }

    private final RedBlackTree.Tree f$2(int maxUsedDepth$1, Iterator xs$1, int level, int size) {
        int n = size;
        if (0 == n) {
            return null;
        }
        if (1 == n) {
            return this.mkTree(level != maxUsedDepth$1 || level == 1, xs$1.next(), null, null, null);
        }
        int n2 = n;
        int leftSize = (size - 1) / 2;
        RedBlackTree.Tree left = this.f$2(maxUsedDepth$1, xs$1, level + 1, leftSize);
        Object x = xs$1.next();
        RedBlackTree.Tree right = this.f$2(maxUsedDepth$1, xs$1, level + 1, size - 1 - leftSize);
        return this.BlackTree(x, null, left, right);
    }

    private final RedBlackTree.Tree f$3(Iterator xs$2, int maxUsedDepth$2, int level, int size) {
        Tuple2 tuple2;
        Tuple2 $3$;
        int n = size;
        if (0 == n) {
            return null;
        }
        if (1 == n) {
            Tuple2 tuple22;
            Tuple2 $1$;
            Tuple2 tuple23 = $1$ = (tuple22 = (Tuple2)xs$2.next());
            Object k = tuple23._1();
            Object v = tuple23._2();
            return this.mkTree(level != maxUsedDepth$2 || level == 1, k, v, null, null);
        }
        int n2 = n;
        int leftSize = (size - 1) / 2;
        RedBlackTree.Tree left = this.f$3(xs$2, maxUsedDepth$2, level + 1, leftSize);
        Tuple2 tuple24 = $3$ = (tuple2 = (Tuple2)xs$2.next());
        Object k = tuple24._1();
        Object v = tuple24._2();
        RedBlackTree.Tree right = this.f$3(xs$2, maxUsedDepth$2, level + 1, size - 1 - leftSize);
        return this.BlackTree(k, v, left, right);
    }

    private final RedBlackTree.Tree fk$1(Function2 f$1, RedBlackTree.Tree t) {
        RedBlackTree.Tree r2;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2 = l == null ? null : this.fk$1(f$1, l);
        boolean keep = BoxesRunTime.unboxToBoolean(f$1.apply(k, v));
        RedBlackTree.Tree tree = r2 = r == null ? null : this.fk$1(f$1, r);
        if (!keep) {
            return this.scala$collection$immutable$RedBlackTree$$$join2(l2, r2);
        }
        if (l2 == l && r2 == r) {
            return t;
        }
        return this.scala$collection$immutable$RedBlackTree$$$join(l2, k, v, r2);
    }

    private final RedBlackTree$partitioner$2$ partitioner$lzyINIT1$1(LazyRef partitioner$lzy1$1, Function2 p$1) {
        RedBlackTree$partitioner$2$ redBlackTree$partitioner$2$;
        LazyRef lazyRef = partitioner$lzy1$1;
        synchronized (lazyRef) {
            redBlackTree$partitioner$2$ = (RedBlackTree$partitioner$2$)(partitioner$lzy1$1.initialized() ? partitioner$lzy1$1.value() : partitioner$lzy1$1.initialize(new RedBlackTree$partitioner$2$(p$1)));
        }
        return redBlackTree$partitioner$2$;
    }

    private final RedBlackTree$partitioner$2$ partitioner$1(LazyRef partitioner$lzy1$2, Function2 p$2) {
        return (RedBlackTree$partitioner$2$)(partitioner$lzy1$2.initialized() ? partitioner$lzy1$2.value() : this.partitioner$lzyINIT1$1(partitioner$lzy1$2, p$2));
    }

    private final int h$1(RedBlackTree.Tree t, int i) {
        while (!(t == null)) {
            RedBlackTree.Tree tree = t.left();
            int n = t.isBlack() ? i + 1 : i;
            t = tree;
            i = n;
        }
        return i + 1;
    }
}

