/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import scala.$less$colon$less;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.concurrent.Batchable;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$parasitic$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.impl.CompletionLatch;
import scala.concurrent.impl.Promise$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Promise {
    public static int Xform_collect() {
        return Promise$.MODULE$.Xform_collect();
    }

    public static int Xform_filter() {
        return Promise$.MODULE$.Xform_filter();
    }

    public static int Xform_flatMap() {
        return Promise$.MODULE$.Xform_flatMap();
    }

    public static int Xform_foreach() {
        return Promise$.MODULE$.Xform_foreach();
    }

    public static int Xform_map() {
        return Promise$.MODULE$.Xform_map();
    }

    public static int Xform_noop() {
        return Promise$.MODULE$.Xform_noop();
    }

    public static int Xform_onComplete() {
        return Promise$.MODULE$.Xform_onComplete();
    }

    public static int Xform_recover() {
        return Promise$.MODULE$.Xform_recover();
    }

    public static int Xform_recoverWith() {
        return Promise$.MODULE$.Xform_recoverWith();
    }

    public static int Xform_transform() {
        return Promise$.MODULE$.Xform_transform();
    }

    public static int Xform_transformWith() {
        return Promise$.MODULE$.Xform_transformWith();
    }

    public static interface Callbacks<T> {
    }

    public static class DefaultPromise<T>
    extends AtomicReference<Object>
    implements scala.concurrent.Promise<T>,
    Future<T>,
    Function1<Try<T>, BoxedUnit> {
        private DefaultPromise(Object initial) {
            super(initial);
            scala.concurrent.Promise.$init$(this);
            Future.$init$(this);
        }

        @Override
        public scala.concurrent.Promise complete(Try result) {
            return scala.concurrent.Promise.complete$(this, result);
        }

        @Override
        public final scala.concurrent.Promise tryCompleteWith(Future other) {
            return scala.concurrent.Promise.tryCompleteWith$(this, other);
        }

        @Override
        public scala.concurrent.Promise success(Object value) {
            return scala.concurrent.Promise.success$(this, value);
        }

        @Override
        public boolean trySuccess(T value) {
            return scala.concurrent.Promise.trySuccess$(this, value);
        }

        @Override
        public scala.concurrent.Promise failure(Throwable cause) {
            return scala.concurrent.Promise.failure$(this, cause);
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            return scala.concurrent.Promise.tryFailure$(this, cause);
        }

        @Override
        public <S> Future<S> transform(Function1<T, S> s, Function1<Throwable, Throwable> f, ExecutionContext executor) {
            return Future.transform$(this, s, f, executor);
        }

        @Override
        public <S> Future<S> flatten($less$colon$less<T, Future<S>> ev) {
            return Future.flatten$(this, ev);
        }

        @Override
        public final Future<T> withFilter(Function1<T, Object> p, ExecutionContext executor) {
            return Future.withFilter$(this, p, executor);
        }

        @Override
        public <U> Future<Tuple2<T, U>> zip(Future<U> that) {
            return Future.zip$(this, that);
        }

        @Override
        public <U> Future<U> fallbackTo(Future<U> that) {
            return Future.fallbackTo$(this, that);
        }

        @Override
        public <U> Future<T> andThen(PartialFunction<Try<T>, U> pf, ExecutionContext executor) {
            return Future.andThen$(this, pf, executor);
        }

        @Override
        public <A> Function1<A, BoxedUnit> compose(Function1<A, Try<T>> g) {
            return Function1.compose$(this, g);
        }

        @Override
        public <A> Function1<Try<T>, A> andThen(Function1<BoxedUnit, A> g) {
            return Function1.andThen$(this, g);
        }

        @Override
        public void apply$mcVI$sp(int x$0) {
            Function1.apply$mcVI$sp$(this, x$0);
        }

        @Override
        public void apply$mcVJ$sp(long x$0) {
            Function1.apply$mcVJ$sp$(this, x$0);
        }

        @Override
        public void apply$mcVF$sp(float x$0) {
            Function1.apply$mcVF$sp$(this, x$0);
        }

        @Override
        public void apply$mcVD$sp(double x$0) {
            Function1.apply$mcVD$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZI$sp(int x$0) {
            return Function1.apply$mcZI$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZJ$sp(long x$0) {
            return Function1.apply$mcZJ$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZF$sp(float x$0) {
            return Function1.apply$mcZF$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZD$sp(double x$0) {
            return Function1.apply$mcZD$sp$(this, x$0);
        }

        @Override
        public int apply$mcII$sp(int x$0) {
            return Function1.apply$mcII$sp$(this, x$0);
        }

        @Override
        public int apply$mcIJ$sp(long x$0) {
            return Function1.apply$mcIJ$sp$(this, x$0);
        }

        @Override
        public int apply$mcIF$sp(float x$0) {
            return Function1.apply$mcIF$sp$(this, x$0);
        }

        @Override
        public int apply$mcID$sp(double x$0) {
            return Function1.apply$mcID$sp$(this, x$0);
        }

        @Override
        public float apply$mcFI$sp(int x$0) {
            return Function1.apply$mcFI$sp$(this, x$0);
        }

        @Override
        public float apply$mcFJ$sp(long x$0) {
            return Function1.apply$mcFJ$sp$(this, x$0);
        }

        @Override
        public float apply$mcFF$sp(float x$0) {
            return Function1.apply$mcFF$sp$(this, x$0);
        }

        @Override
        public float apply$mcFD$sp(double x$0) {
            return Function1.apply$mcFD$sp$(this, x$0);
        }

        @Override
        public long apply$mcJI$sp(int x$0) {
            return Function1.apply$mcJI$sp$(this, x$0);
        }

        @Override
        public long apply$mcJJ$sp(long x$0) {
            return Function1.apply$mcJJ$sp$(this, x$0);
        }

        @Override
        public long apply$mcJF$sp(float x$0) {
            return Function1.apply$mcJF$sp$(this, x$0);
        }

        @Override
        public long apply$mcJD$sp(double x$0) {
            return Function1.apply$mcJD$sp$(this, x$0);
        }

        @Override
        public double apply$mcDI$sp(int x$0) {
            return Function1.apply$mcDI$sp$(this, x$0);
        }

        @Override
        public double apply$mcDJ$sp(long x$0) {
            return Function1.apply$mcDJ$sp$(this, x$0);
        }

        @Override
        public double apply$mcDF$sp(float x$0) {
            return Function1.apply$mcDF$sp$(this, x$0);
        }

        @Override
        public double apply$mcDD$sp(double x$0) {
            return Function1.apply$mcDD$sp$(this, x$0);
        }

        public DefaultPromise(Try<T> result) {
            this((Object)Promise$.MODULE$.scala$concurrent$impl$Promise$$$resolve(result));
        }

        public DefaultPromise() {
            this(Promise$.scala$concurrent$impl$Promise$$$Noop);
        }

        @Override
        public final void apply(Try<T> resolved) {
            this.tryComplete0(this.get(), resolved);
        }

        @Override
        public final Future<T> future() {
            return this;
        }

        @Override
        public final <S> Future<S> transform(Function1<Try<T>, Try<S>> f, ExecutionContext executor) {
            return this.dispatchOrAddCallbacks(this.get(), new Transformation(3, f, executor));
        }

        @Override
        public final <S> Future<S> transformWith(Function1<Try<T>, Future<S>> f, ExecutionContext executor) {
            return this.dispatchOrAddCallbacks(this.get(), new Transformation(4, f, executor));
        }

        @Override
        public final <U, R> Future<R> zipWith(Future<U> that, Function2<T, U, R> f, ExecutionContext executor) {
            Object state = this.get();
            if (state instanceof Try) {
                if (((Try)state).isFailure()) {
                    return this;
                }
                Object l = ((Success)state).get();
                return that.map(arg_0 -> Promise$.scala$concurrent$impl$Promise$DefaultPromise$$_$zipWith$$anonfun$1(f, l, arg_0), executor);
            }
            AtomicReference buffer = new AtomicReference();
            DefaultPromise<T> zipped = new DefaultPromise<T>();
            JProcedure1<Try> thisF = arg_0 -> Promise$.scala$concurrent$impl$Promise$DefaultPromise$$_$_$$anonfun$1(buffer, zipped, f, arg_0);
            JProcedure1 thatF = arg_0 -> Promise$.scala$concurrent$impl$Promise$DefaultPromise$$_$_$$anonfun$2(buffer, zipped, f, arg_0);
            this.dispatchOrAddCallbacks(state, new Transformation(6, thisF, executor));
            that.onComplete(thatF, executor);
            return zipped.future();
        }

        @Override
        public final <U> void foreach(Function1<T, U> f, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Failure)) {
                this.dispatchOrAddCallbacks(state, new Transformation(5, f, executor));
                return;
            }
        }

        @Override
        public final <S> Future<S> flatMap(Function1<T, Future<S>> f, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Failure)) {
                return this.dispatchOrAddCallbacks(state, new Transformation(2, f, executor));
            }
            return this;
        }

        @Override
        public final <S> Future<S> map(Function1<T, S> f, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Failure)) {
                return this.dispatchOrAddCallbacks(state, new Transformation(1, f, executor));
            }
            return this;
        }

        @Override
        public final Future<T> filter(Function1<T, Object> p, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Failure)) {
                return this.dispatchOrAddCallbacks(state, new Transformation(9, p, executor));
            }
            return this;
        }

        @Override
        public final <S> Future<S> collect(PartialFunction<T, S> pf, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Failure)) {
                return this.dispatchOrAddCallbacks(state, new Transformation(10, pf, executor));
            }
            return this;
        }

        @Override
        public final <U> Future<U> recoverWith(PartialFunction<Throwable, Future<U>> pf, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Success)) {
                return this.dispatchOrAddCallbacks(state, new Transformation(8, pf, executor));
            }
            return this;
        }

        @Override
        public final <U> Future<U> recover(PartialFunction<Throwable, U> pf, ExecutionContext executor) {
            Object state = this.get();
            if (!(state instanceof Success)) {
                return this.dispatchOrAddCallbacks(state, new Transformation(7, pf, executor));
            }
            return this;
        }

        @Override
        public final <S> Future<S> mapTo(ClassTag<S> tag) {
            if (!(this.get() instanceof Failure)) {
                return Future.mapTo$(this, tag);
            }
            return this;
        }

        @Override
        public final <U> void onComplete(Function1<Try<T>, U> func, ExecutionContext executor) {
            this.dispatchOrAddCallbacks(this.get(), new Transformation(6, func, executor));
        }

        public final <U> Function0<BoxedUnit> onCompleteWithUnregister(Function1<Try<T>, U> func, ExecutionContext executor) {
            Transformation t = new Transformation(6, func, executor);
            this.dispatchOrAddCallbacks(this.get(), t);
            return () -> this.unregisterCallback(t);
        }

        @Override
        public final Future<Throwable> failed() {
            if (!(this.get() instanceof Success)) {
                return Future.failed$(this);
            }
            return Future$.MODULE$.failedFailureFuture();
        }

        @Override
        public final String toString() {
            while (true) {
                Object state;
                if ((state = this_.get()) instanceof Try) {
                    return "Future(" + state + ")";
                }
                if (!(state instanceof Link)) break;
                DefaultPromise this_ = ((Link)state).promise(this_);
            }
            return "Future(<not completed>)";
        }

        private final Try<T> tryAwait0(Duration atMost) {
            if (atMost != Duration$.MODULE$.Undefined()) {
                Try r;
                Try<T> v = this.value0();
                if (!(v == null)) {
                    return v;
                }
                if (atMost.$less$eq(Duration$.MODULE$.Zero())) {
                    v0 = null;
                } else {
                    CompletionLatch l = new CompletionLatch();
                    this.onComplete(l, ExecutionContext$parasitic$.MODULE$);
                    if (atMost.isFinite()) {
                        v1 = BoxesRunTime.boxToBoolean(l.tryAcquireSharedNanos(1, atMost.toNanos()));
                    } else {
                        l.acquireSharedInterruptibly(1);
                        v1 = BoxedUnit.UNIT;
                    }
                    v0 = r = l.result();
                }
                if (!(r == null)) {
                    return r;
                }
                throw Future$.MODULE$.timeoutError(atMost);
            }
            throw Future$.MODULE$.waitUndefinedError();
        }

        @Override
        public final DefaultPromise ready(Duration atMost, CanAwait permit) throws InterruptedException, TimeoutException {
            this.tryAwait0(atMost);
            return this;
        }

        @Override
        public final T result(Duration atMost, CanAwait permit) throws Exception {
            Try<T> x$proxy1 = this.tryAwait0(atMost);
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy1.get();
        }

        @Override
        public final boolean isCompleted() {
            return !(this.value0() == null);
        }

        @Override
        public final Option<Try<T>> value() {
            return Option$.MODULE$.apply(this.value0());
        }

        private final Try<T> value0() {
            while (true) {
                Object state;
                if ((state = this_.get()) instanceof Try) {
                    return (Try)state;
                }
                if (!(state instanceof Link)) break;
                DefaultPromise this_ = ((Link)state).promise(this_);
            }
            return null;
        }

        @Override
        public final boolean tryComplete(Try<T> value) {
            Object state = this.get();
            if (state instanceof Try) {
                return false;
            }
            return this.tryComplete0(state, Promise$.MODULE$.scala$concurrent$impl$Promise$$$resolve(value));
        }

        public final boolean tryComplete0(Object state, Try<T> resolved) {
            block4: {
                while (true) {
                    if (state instanceof Callbacks) {
                        if (this_.compareAndSet(state, resolved)) {
                            if (state != Promise$.scala$concurrent$impl$Promise$$$Noop) {
                                this_.submitWithValue((Callbacks)state, resolved);
                            }
                            return true;
                        }
                        state = this_.get();
                        continue;
                    }
                    if (!(state instanceof Link)) break block4;
                    DefaultPromise<T> p = ((Link)state).promise(this_);
                    if (p == this_) break;
                    DefaultPromise<T> defaultPromise = p;
                    Object v = p.get();
                    DefaultPromise<T> this_ = defaultPromise;
                    state = v;
                }
                return false;
            }
            return false;
        }

        @Override
        public final DefaultPromise<T> completeWith(Future<T> other) {
            Object state;
            if (other != this && !((state = this.get()) instanceof Try)) {
                Try resolved = other instanceof DefaultPromise ? ((DefaultPromise)other).value0() : (Try)other.value().orNull($less$colon$less$.MODULE$.refl());
                if (!(resolved == null)) {
                    this.tryComplete0(state, resolved);
                } else {
                    other.onComplete(this, ExecutionContext$parasitic$.MODULE$);
                }
            }
            return this;
        }

        private final <C extends Callbacks<T>> C dispatchOrAddCallbacks(Object state, C callbacks) {
            while (true) {
                DefaultPromise p;
                if (state instanceof Try) {
                    this_.submitWithValue(callbacks, (Try)state);
                    return callbacks;
                }
                if (state instanceof Callbacks) {
                    if (this_.compareAndSet(state, state != Promise$.scala$concurrent$impl$Promise$$$Noop ? this_.concatCallbacks(callbacks, (Callbacks)state) : callbacks)) {
                        return callbacks;
                    }
                    state = this_.get();
                    continue;
                }
                DefaultPromise defaultPromise = p = ((Link)state).promise(this_);
                Object v = p.get();
                DefaultPromise this_ = defaultPromise;
                state = v;
            }
        }

        private void unregisterCallback(Transformation<?, ?> t) {
            block2: {
                while (true) {
                    Object state;
                    if ((state = this.get()) == t) {
                        if (!this.compareAndSet(state, Promise$.scala$concurrent$impl$Promise$$$Noop)) continue;
                        return;
                    }
                    if (!(state instanceof ManyCallbacks)) break block2;
                    if (this.compareAndSet(state, this.removeCallback((ManyCallbacks)state, t, this.removeCallback$default$3()))) break;
                }
                return;
            }
        }

        private final Callbacks<T> concatCallbacks(Callbacks<T> left, Callbacks<T> right) {
            while (!(left instanceof Transformation)) {
                ManyCallbacks m = (ManyCallbacks)left;
                Callbacks callbacks = m.rest();
                ManyCallbacks manyCallbacks = new ManyCallbacks(m.first(), right);
                left = callbacks;
                right = manyCallbacks;
            }
            return new ManyCallbacks<T>((Transformation)left, right);
        }

        private final Object removeCallback(Callbacks<T> cs, Transformation<?, ?> t, Callbacks<T> result) {
            while (true) {
                if (cs == t) {
                    if (result == null) {
                        return Promise$.scala$concurrent$impl$Promise$$$Noop;
                    }
                    return result;
                }
                if (!(cs instanceof ManyCallbacks)) break;
                ManyCallbacks m = (ManyCallbacks)cs;
                if (m.first() == t) {
                    if (result == null) {
                        return m.rest();
                    }
                    return this.concatCallbacks(m.rest(), result);
                }
                Callbacks callbacks = m.rest();
                Callbacks<Object> callbacks2 = result == null ? m.first() : new ManyCallbacks(m.first(), result);
                cs = callbacks;
                result = callbacks2;
            }
            return cs;
        }

        private Callbacks<T> removeCallback$default$3() {
            return null;
        }

        private final void submitWithValue(Callbacks<T> callbacks, Try<T> resolved) {
            while (callbacks instanceof ManyCallbacks) {
                ManyCallbacks m = (ManyCallbacks)callbacks;
                m.first().submitWithValue(resolved);
                callbacks = m.rest();
            }
            ((Transformation)callbacks).submitWithValue(resolved);
        }

        public final void linkRootOf(DefaultPromise<T> target, Link<T> link) {
            while (this_ != target) {
                Object state = this_.get();
                if (state instanceof Try) {
                    if (!target.tryComplete0(target.get(), (Try)state)) {
                        throw new IllegalStateException("Cannot link completed promises together");
                    }
                    return;
                }
                if (state instanceof Callbacks) {
                    Link l = !(link == null) ? link : new Link(target);
                    DefaultPromise<T> p = l.promise(this_);
                    if (this_ != p && this_.compareAndSet(state, l)) {
                        if (state != Promise$.scala$concurrent$impl$Promise$$$Noop) {
                            super.dispatchOrAddCallbacks(p.get(), (Callbacks)state);
                            return;
                        }
                        return;
                    }
                    DefaultPromise<T> defaultPromise = p;
                    Link link2 = l;
                    target = defaultPromise;
                    link = link2;
                    continue;
                }
                DefaultPromise this_ = ((Link)state).promise(this_);
            }
        }

        public final void unlink(Try<T> resolved) {
            Object state;
            while ((state = this_.get()) instanceof Link) {
                DefaultPromise next;
                DefaultPromise this_ = next = this_.compareAndSet(state, resolved) ? (DefaultPromise)((Link)state).get() : this_;
            }
            this_.tryComplete0(state, resolved);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new NotSerializableException("Promises and Futures cannot be serialized");
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            throw new NotSerializableException("Promises and Futures cannot be deserialized");
        }
    }

    public static final class Link<T>
    extends AtomicReference<DefaultPromise<T>> {
        public Link(DefaultPromise<T> to) {
            super(to);
        }

        public final DefaultPromise<T> promise(DefaultPromise<T> owner) {
            DefaultPromise c = (DefaultPromise)this.get();
            return this.compressed(c, c, owner);
        }

        private final DefaultPromise<T> compressed(DefaultPromise<T> current, DefaultPromise<T> target, DefaultPromise<T> owner) {
            Object value;
            while (true) {
                if ((value = target.get()) instanceof Callbacks) {
                    if (this.compareAndSet(current, target)) {
                        return target;
                    }
                    current = (DefaultPromise)this.get();
                    continue;
                }
                if (!(value instanceof Link)) break;
                target = (DefaultPromise)((Link)value).get();
            }
            owner.unlink((Try)value);
            return owner;
        }
    }

    public static final class ManyCallbacks<T>
    implements Callbacks<T> {
        private final Transformation<T, ?> first;
        private final Callbacks<T> rest;

        public ManyCallbacks(Transformation<T, ?> first, Callbacks<T> rest) {
            this.first = first;
            this.rest = rest;
        }

        public final Transformation<T, ?> first() {
            return this.first;
        }

        public final Callbacks<T> rest() {
            return this.rest;
        }

        public final String toString() {
            return "ManyCallbacks";
        }
    }

    public static final class Transformation<F, T>
    extends DefaultPromise<T>
    implements Callbacks<F>,
    Runnable,
    Batchable {
        private Function1<Object, Object> _fun;
        private ExecutionContext _ec;
        private Try<F> _arg;
        private final int _xform;

        private Transformation(Function1<Object, Object> _fun, ExecutionContext _ec, Try<F> _arg, int _xform) {
            this._fun = _fun;
            this._ec = _ec;
            this._arg = _arg;
            this._xform = _xform;
        }

        private final Function1<Object, Object> _fun() {
            return this._fun;
        }

        private final void _fun_$eq(Function1<Object, Object> x$0) {
            this._fun = x$0;
        }

        private final ExecutionContext _ec() {
            return this._ec;
        }

        private final void _ec_$eq(ExecutionContext x$0) {
            this._ec = x$0;
        }

        private final Try<F> _arg() {
            return this._arg;
        }

        private final void _arg_$eq(Try<F> x$0) {
            this._arg = x$0;
        }

        private final int _xform() {
            return this._xform;
        }

        public Transformation(int xform, Function1<?, ?> f, ExecutionContext ec) {
            this(f, ec.prepare(), null, xform);
        }

        public final boolean benefitsFromBatching() {
            return this._xform() != 6 && this._xform() != 5;
        }

        public final Transformation<F, T> submitWithValue(Try<F> resolved) {
            this._arg_$eq(resolved);
            ExecutionContext e = this._ec();
            try {
                if (e == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                e.execute(this);
            }
            catch (Throwable t) {
                this._fun_$eq(null);
                this._arg_$eq(null);
                this._ec_$eq(null);
                if (e == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.handleFailure(t, e);
            }
            return this;
        }

        private final void handleFailure(Throwable t, ExecutionContext e) {
            boolean wasInterrupted = t instanceof InterruptedException;
            if (wasInterrupted || NonFatal$.MODULE$.apply(t)) {
                boolean completed = this.tryComplete0(this.get(), Promise$.MODULE$.scala$concurrent$impl$Promise$$$resolve(Failure$.MODULE$.apply(t)));
                if (completed && wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                if (this._xform() == 5 || this._xform() == 6 || !completed) {
                    e.reportFailure(t);
                    return;
                }
                return;
            }
            throw t;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void var2_1;
            Try<F> x$proxy4 = this._arg();
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            void v = var2_1;
            Function1<Object, Object> x$proxy5 = this._fun();
            if (x$proxy5 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Function1<Object, Object> fun = x$proxy5;
            ExecutionContext x$proxy6 = this._ec();
            if (x$proxy6 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            ExecutionContext ec = x$proxy6;
            this._fun_$eq(null);
            this._arg_$eq(null);
            this._ec_$eq(null);
            int n = this._xform();
            Try<Object> try_ = switch (n) {
                case 0 -> null;
                case 1 -> {
                    if (v instanceof Success) {
                        yield Success$.MODULE$.apply(fun.apply(v.get()));
                    }
                    yield v;
                }
                case 2 -> {
                    if (v instanceof Success) {
                        Object f = fun.apply(v.get());
                        if (f instanceof DefaultPromise) {
                            ((DefaultPromise)f).linkRootOf(this, null);
                            v1 = BoxedUnit.UNIT;
                        } else {
                            v1 = this.completeWith((Future)f);
                        }
                        yield null;
                    }
                    yield v;
                }
                case 3 -> Promise$.MODULE$.scala$concurrent$impl$Promise$$$resolve((Try)fun.apply(v));
                case 4 -> {
                    Object f = fun.apply(v);
                    if (f instanceof DefaultPromise) {
                        ((DefaultPromise)f).linkRootOf(this, null);
                        v2 = BoxedUnit.UNIT;
                    } else {
                        v2 = this.completeWith((Future)f);
                    }
                    yield null;
                }
                case 5 -> {
                    v.foreach(fun);
                    yield null;
                }
                case 6 -> {
                    fun.apply(v);
                    yield null;
                }
                case 7 -> {
                    if (v instanceof Failure) {
                        yield Promise$.MODULE$.scala$concurrent$impl$Promise$$$resolve(v.recover((PartialFunction)fun));
                    }
                    yield v;
                }
                case 8 -> {
                    if (v instanceof Failure) {
                        Future<Nothing$> f = ((PartialFunction)fun).applyOrElse(((Failure)v).exception(), Future$.MODULE$.recoverWithFailed());
                        if (f != Future$.MODULE$.recoverWithFailedMarker()) {
                            if (f instanceof DefaultPromise) {
                                ((DefaultPromise)f).linkRootOf(this, null);
                                v3 = BoxedUnit.UNIT;
                            } else {
                                v3 = this.completeWith((Future)f);
                            }
                            yield null;
                        }
                        yield v;
                    }
                    yield v;
                }
                case 9 -> {
                    if (v instanceof Failure || BoxesRunTime.unboxToBoolean(fun.apply(v.get()))) {
                        yield v;
                    }
                    yield Future$.MODULE$.filterFailure();
                }
                case 10 -> {
                    if (v instanceof Success) {
                        yield Success$.MODULE$.apply(((PartialFunction)fun).applyOrElse(v.get(), Future$.MODULE$.collectFailed()));
                    }
                    yield v;
                }
                default -> Failure$.MODULE$.apply(new IllegalStateException("BUG: encountered transformation promise with illegal type: " + this._xform()));
            };
            try {
                Try resolvedResult = try_;
                if (!(resolvedResult == null)) {
                    this.tryComplete0(this.get(), resolvedResult);
                }
            }
            catch (Throwable t) {
                this.handleFailure(t, ec);
            }
        }
    }
}

