/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.collection.mutable.LinkedHashSet$;
import scala.math.Integral;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public class LinkedHashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, LinkedHashSet, LinkedHashSet<A>>,
DefaultSerializable {
    private Entry<A> firstEntry;
    private Entry<A> lastEntry;
    private Entry<A>[] table;
    private int threshold;
    private int contentSize;

    public static double defaultLoadFactor() {
        return LinkedHashSet$.MODULE$.defaultLoadFactor();
    }

    public static int defaultinitialSize() {
        return LinkedHashSet$.MODULE$.defaultinitialSize();
    }

    public static Object fill(int n, Function0 function0) {
        return LinkedHashSet$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return LinkedHashSet$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return LinkedHashSet$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return LinkedHashSet$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return LinkedHashSet$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <E> LinkedHashSet<E> from(IterableOnce<E> iterableOnce) {
        return LinkedHashSet$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return LinkedHashSet$.MODULE$.iterate(object, n, function1);
    }

    public static <A> GrowableBuilder<A, LinkedHashSet<A>> newBuilder() {
        return LinkedHashSet$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return LinkedHashSet$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return LinkedHashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return LinkedHashSet$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return LinkedHashSet$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return LinkedHashSet$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return LinkedHashSet$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return LinkedHashSet$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static Object unfold(Object object, Function1 function1) {
        return LinkedHashSet$.MODULE$.unfold(object, function1);
    }

    public LinkedHashSet() {
        StrictOptimizedIterableOps.$init$(this);
        DefaultSerializable.$init$(this);
        this.firstEntry = null;
        this.lastEntry = null;
        this.table = new Entry[this.tableSizeFor(LinkedHashSet$.MODULE$.defaultinitialSize())];
        this.threshold = this.newThreshold(this.table.length);
        this.contentSize = 0;
    }

    @Override
    public Tuple2<LinkedHashSet<A>, LinkedHashSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<LinkedHashSet<A>, LinkedHashSet<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<LinkedHashSet<A1>, LinkedHashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<LinkedHashSet<A1>, LinkedHashSet<A2>, LinkedHashSet<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<LinkedHashSet<A1>, LinkedHashSet<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    @Override
    public IterableFactory<LinkedHashSet> iterableFactory() {
        return LinkedHashSet$.MODULE$;
    }

    public Entry<A> firstEntry() {
        return this.firstEntry;
    }

    public void firstEntry_$eq(Entry<A> x$1) {
        this.firstEntry = x$1;
    }

    public Entry<A> lastEntry() {
        return this.lastEntry;
    }

    public void lastEntry_$eq(Entry<A> x$1) {
        this.lastEntry = x$1;
    }

    @Override
    public A last() {
        if (this.size() > 0) {
            Entry<A> x$proxy1 = this.lastEntry();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy1.key();
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashSet");
    }

    @Override
    public Option<A> lastOption() {
        if (this.size() > 0) {
            Entry<A> x$proxy2 = this.lastEntry();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return Some$.MODULE$.apply(x$proxy2.key());
        }
        return None$.MODULE$;
    }

    @Override
    public A head() {
        if (this.size() > 0) {
            Entry<A> x$proxy3 = this.firstEntry();
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy3.key();
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashSet");
    }

    @Override
    public Option<A> headOption() {
        if (this.size() > 0) {
            Entry<A> x$proxy4 = this.firstEntry();
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return Some$.MODULE$.apply(x$proxy4.key());
        }
        return None$.MODULE$;
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(A elem) {
        return !(this.findEntry(elem) == null);
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / LinkedHashSet$.MODULE$.defaultLoadFactor()));
        if (target > this.table.length) {
            this.growTable(target);
            return;
        }
    }

    @Override
    public boolean add(A elem) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.table.length * 2);
        }
        int hash = this.computeHash(elem);
        return this.put0(elem, hash, this.index(hash));
    }

    @Override
    public LinkedHashSet<A> addOne(A elem) {
        this.add(elem);
        return this;
    }

    @Override
    public LinkedHashSet<A> subtractOne(A elem) {
        this.remove(elem);
        return this;
    }

    @Override
    public boolean remove(A elem) {
        return this.remove0(elem, this.computeHash(elem));
    }

    @Override
    public Iterator<A> iterator() {
        return new LinkedHashSetIterator<A>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object extract(Entry nd) {
                return nd.key();
            }
        };
    }

    public Iterator<Entry<A>> entryIterator() {
        return new LinkedHashSetIterator<Entry<A>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Entry extract(Entry nd) {
                return nd;
            }
        };
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        Entry<A> cur = this.firstEntry();
        while (!(cur == null)) {
            f.apply(cur.key());
            cur = cur.later();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.contentSize = 0;
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private int tableSizeFor(int capacity) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(Integer.highestOneBit(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(capacity - 1), 4)) * 2), 0x40000000);
    }

    private int newThreshold(int size) {
        return (int)((double)size * LinkedHashSet$.MODULE$.defaultLoadFactor());
    }

    private int improveHash(int originalHash) {
        return originalHash ^ originalHash >>> 16;
    }

    public int unimproveHash(int improvedHash) {
        return this.improveHash(improvedHash);
    }

    private int computeHash(A o) {
        return this.improveHash(Statics.anyHash(o));
    }

    private int index(int hash) {
        return hash & this.table.length - 1;
    }

    private Entry<A> findEntry(A key) {
        int hash = this.computeHash(key);
        Entry<A> entry = this.table[this.index(hash)];
        if (entry == null) {
            return null;
        }
        Entry<A> nd = entry;
        return nd.findEntry(key, hash);
    }

    private Entry<A> createNewEntry(A key, int hash) {
        Entry<A> e = new Entry<A>(key, hash);
        if (this.firstEntry() == null) {
            this.firstEntry_$eq(e);
        } else {
            Entry<A> x$proxy14 = this.lastEntry();
            if (x$proxy14 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy14.later_$eq(e);
            e.earlier_$eq(this.lastEntry());
        }
        this.lastEntry_$eq(e);
        return e;
    }

    private void deleteEntry(Entry<A> e) {
        if (e.earlier() == null) {
            this.firstEntry_$eq(e.later());
        } else {
            e.earlier().later_$eq(e.later());
        }
        if (e.later() == null) {
            this.lastEntry_$eq(e.earlier());
        } else {
            e.later().earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        e.next_$eq(null);
    }

    private boolean put0(A elem, int hash, int idx) {
        Entry<A> entry = this.table[idx];
        if (entry == null) {
            this.table[idx] = this.createNewEntry(elem, hash);
        } else {
            Entry<A> old = entry;
            Entry<A> prev = null;
            Entry<A> n = old;
            while (!(n == null) && n.hash() <= hash) {
                if (n.hash() == hash && BoxesRunTime.equals(elem, n.key())) {
                    return false;
                }
                prev = n;
                n = n.next();
            }
            Entry<A> nnode = this.createNewEntry(elem, hash);
            if (prev == null) {
                nnode.next_$eq(old);
                this.table[idx] = nnode;
            } else {
                nnode.next_$eq(prev.next());
                prev.next_$eq(nnode);
            }
        }
        ++this.contentSize;
        return true;
    }

    private boolean remove0(A elem, int hash) {
        Entry<A> nd;
        int idx = this.index(hash);
        Entry<A> entry = this.table[idx];
        if (entry == null) {
            return false;
        }
        Entry<A> nd2 = entry;
        if (nd2.hash() == hash && BoxesRunTime.equals(nd2.key(), elem)) {
            this.table[idx] = nd2.next();
            this.deleteEntry(nd2);
            --this.contentSize;
            return true;
        }
        Entry<A> prev = nd = entry;
        Entry<A> next = nd.next();
        while (!(next == null) && next.hash() <= hash) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return true;
            }
            prev = next;
            next = next.next();
        }
        return false;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException("new hash table size " + newlen + " exceeds maximum");
        }
        this.threshold = this.newThreshold(newlen);
        if (this.size() == 0) {
            this.table = new Entry[newlen];
            return;
        }
        this.table = Arrays.copyOf(this.table, newlen);
        Entry<Object> preLow = new Entry<Object>(null, 0);
        Entry<Object> preHigh = new Entry<Object>(null, 0);
        for (int oldlen = this.table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                Entry<A> old = this.table[i];
                if (!(!(old == null))) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Entry<Object> lastLow = preLow;
                Entry<Object> lastHigh = preHigh;
                Entry<A> n = old;
                while (!(n == null)) {
                    Entry<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (!(old == preLow.next())) {
                    this.table[i] = preLow.next();
                }
                if (!(!(preHigh.next() == null))) continue;
                this.table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    @Override
    public int hashCode() {
        LinkedHashSetIterator<Object> setHashIterator = this.isEmpty() ? this.iterator() : new LinkedHashSetIterator<Object>(this){
            private int hash;
            private final /* synthetic */ LinkedHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hash = 0;
            }

            public int hash() {
                return this.hash;
            }

            public void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            public Object extract(Entry nd) {
                this.hash_$eq(this.$outer.unimproveHash(nd.hash()));
                return this;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)setHashIterator, MurmurHash3$.MODULE$.setSeed());
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashSet";
    }

    public static final class Entry<A> {
        private final A key;
        private final int hash;
        private Entry<A> earlier;
        private Entry<A> later;
        private Entry<A> next;

        public Entry(A key, int hash) {
            this.key = key;
            this.hash = hash;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }

        public A key() {
            return this.key;
        }

        public int hash() {
            return this.hash;
        }

        public Entry<A> earlier() {
            return this.earlier;
        }

        public void earlier_$eq(Entry<A> x$1) {
            this.earlier = x$1;
        }

        public Entry<A> later() {
            return this.later;
        }

        public void later_$eq(Entry<A> x$1) {
            this.later = x$1;
        }

        public Entry<A> next() {
            return this.next;
        }

        public void next_$eq(Entry<A> x$1) {
            this.next = x$1;
        }

        public final Entry<A> findEntry(A k, int h) {
            while (h != this_.hash() || !BoxesRunTime.equals(k, this_.key())) {
                if (this_.next() == null || this_.hash() > h) {
                    return null;
                }
                Entry<A> this_ = this_.next();
            }
            return this_;
        }
    }

    public abstract class LinkedHashSetIterator<T>
    extends AbstractIterator<T> {
        private Entry<A> cur;

        public LinkedHashSetIterator() {
            if (LinkedHashSet.this == null) {
                throw new NullPointerException();
            }
            this.cur = LinkedHashSet.this.firstEntry();
        }

        public abstract T extract(Entry<A> var1);

        @Override
        public boolean hasNext() {
            return !(this.cur == null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            if (this.hasNext()) {
                void var2_1;
                Entry x$proxy9 = this.cur;
                if (x$proxy9 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                T r = this.extract((Entry)var2_1);
                Entry x$proxy10 = this.cur;
                if (x$proxy10 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.cur = x$proxy10.later();
                return r;
            }
            return (T)Iterator$.MODULE$.empty().next();
        }

        public final /* synthetic */ LinkedHashSet scala$collection$mutable$LinkedHashSet$LinkedHashSetIterator$$$outer() {
            return LinkedHashSet.this;
        }
    }
}

