/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.AbstractIndexedSeqView;
import scala.collection.AbstractIterator;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Searching;
import scala.collection.SeqView;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.math.Ordering;
import scala.runtime.RichInt$;

public interface IndexedSeqView<A>
extends IndexedSeqOps<A, View, View<A>>,
SeqView<A> {
    public static void $init$(IndexedSeqView $this) {
    }

    public static IndexedSeqView view$(IndexedSeqView $this) {
        return $this.view();
    }

    @Override
    default public IndexedSeqView<A> view() {
        return this;
    }

    public static IndexedSeqView view$(IndexedSeqView $this, int from, int until) {
        return $this.view(from, until);
    }

    @Override
    default public IndexedSeqView<A> view(int from, int until) {
        return this.view().slice(from, until);
    }

    public static Iterator iterator$(IndexedSeqView $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return new IndexedSeqViewIterator(this);
    }

    public static Iterator reverseIterator$(IndexedSeqView $this) {
        return $this.reverseIterator();
    }

    @Override
    default public Iterator<A> reverseIterator() {
        return new IndexedSeqViewReverseIterator(this);
    }

    public static IndexedSeqView appended$(IndexedSeqView $this, Object elem) {
        return $this.appended(elem);
    }

    @Override
    default public <B> IndexedSeqView<B> appended(B elem) {
        return new Appended<B>(this, elem);
    }

    public static IndexedSeqView prepended$(IndexedSeqView $this, Object elem) {
        return $this.prepended(elem);
    }

    @Override
    default public <B> IndexedSeqView<B> prepended(B elem) {
        return new Prepended<B>(elem, this);
    }

    public static IndexedSeqView take$(IndexedSeqView $this, int n) {
        return $this.take(n);
    }

    @Override
    default public IndexedSeqView<A> take(int n) {
        return new Take(this, n);
    }

    public static IndexedSeqView takeRight$(IndexedSeqView $this, int n) {
        return $this.takeRight(n);
    }

    @Override
    default public IndexedSeqView<A> takeRight(int n) {
        return new TakeRight(this, n);
    }

    public static IndexedSeqView drop$(IndexedSeqView $this, int n) {
        return $this.drop(n);
    }

    @Override
    default public IndexedSeqView<A> drop(int n) {
        return new Drop(this, n);
    }

    public static IndexedSeqView dropRight$(IndexedSeqView $this, int n) {
        return $this.dropRight(n);
    }

    @Override
    default public IndexedSeqView<A> dropRight(int n) {
        return new DropRight(this, n);
    }

    public static IndexedSeqView map$(IndexedSeqView $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public <B> IndexedSeqView<B> map(Function1<A, B> f) {
        return new Map<A, B>(this, f);
    }

    public static IndexedSeqView reverse$(IndexedSeqView $this) {
        return $this.reverse();
    }

    @Override
    default public IndexedSeqView<A> reverse() {
        return new Reverse(this);
    }

    public static IndexedSeqView slice$(IndexedSeqView $this, int from, int until) {
        return $this.slice(from, until);
    }

    @Override
    default public IndexedSeqView<A> slice(int from, int until) {
        return new Slice(this, from, until);
    }

    public static IndexedSeqView tapEach$(IndexedSeqView $this, Function1 f) {
        return $this.tapEach(f);
    }

    @Override
    default public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
        return new Map(this, (Function1<Object, Object> & Serializable)a -> {
            f.apply(a);
            return a;
        });
    }

    public static IndexedSeqView concat$(IndexedSeqView $this, IndexedSeqOps suffix) {
        return $this.concat(suffix);
    }

    @Override
    default public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
        return new Concat<B>(this, suffix);
    }

    public static IndexedSeqView appendedAll$(IndexedSeqView $this, IndexedSeqOps suffix) {
        return $this.appendedAll(suffix);
    }

    @Override
    default public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
        return new Concat<B>(this, suffix);
    }

    public static IndexedSeqView prependedAll$(IndexedSeqView $this, IndexedSeqOps prefix) {
        return $this.prependedAll(prefix);
    }

    @Override
    default public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
        return new Concat<B>(prefix, this);
    }

    public static String stringPrefix$(IndexedSeqView $this) {
        return $this.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "IndexedSeqView";
    }

    public static class Appended<A>
    extends SeqView.Appended<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public Appended(IndexedSeqOps<A, Object, ?> underlying, A elem) {
            super(underlying, elem);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class Concat<A>
    extends SeqView.Concat<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public Concat(IndexedSeqOps<A, Object, ?> prefix, IndexedSeqOps<A, Object, ?> suffix) {
            super(prefix, suffix);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class Drop<A>
    extends SeqView.Drop<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public Drop(IndexedSeqOps<A, Object, ?> underlying, int n) {
            super(underlying, n);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class DropRight<A>
    extends SeqView.DropRight<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public DropRight(IndexedSeqOps<A, Object, ?> underlying, int n) {
            super(underlying, n);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class Id<A>
    extends SeqView.Id<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public Id(IndexedSeqOps<A, Object, ?> underlying) {
            super(underlying);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class IndexedSeqViewIterator<A>
    extends AbstractIterator<A>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final IndexedSeqView<A> self;
        private int current;
        private int remainder;

        public IndexedSeqViewIterator(IndexedSeqView<A> self) {
            this.self = self;
            this.current = 0;
            this.remainder = self.length();
        }

        @Override
        public int knownSize() {
            return this.remainder;
        }

        private boolean _hasNext() {
            return this.remainder > 0;
        }

        @Override
        public boolean hasNext() {
            return this._hasNext();
        }

        @Override
        public A next() {
            if (this._hasNext()) {
                Object r = this.self.apply(this.current);
                ++this.current;
                --this.remainder;
                return r;
            }
            return Iterator$.MODULE$.empty().next();
        }

        @Override
        public Iterator<A> drop(int n) {
            if (n > 0) {
                this.current += n;
                this.remainder = Math.max(0, this.remainder - n);
            }
            return this;
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            int formatFrom = this.formatRange$1(from);
            int formatUntil = this.formatRange$1(until);
            this.remainder = Math.max(0, formatUntil - formatFrom);
            this.current += formatFrom;
            return this;
        }

        private final int formatRange$1(int value) {
            if (value < 0) {
                return 0;
            }
            if (value > this.remainder) {
                return this.remainder;
            }
            return value;
        }
    }

    public static class IndexedSeqViewReverseIterator<A>
    extends AbstractIterator<A>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final IndexedSeqView<A> self;
        private int remainder;
        private int pos;

        public IndexedSeqViewReverseIterator(IndexedSeqView<A> self) {
            this.self = self;
            this.remainder = self.length();
            this.pos = this.remainder - 1;
        }

        private boolean _hasNext() {
            return this.remainder > 0;
        }

        @Override
        public boolean hasNext() {
            return this._hasNext();
        }

        @Override
        public A next() {
            if (this._hasNext()) {
                Object r = this.self.apply(this.pos);
                --this.pos;
                --this.remainder;
                return r;
            }
            return Iterator$.MODULE$.empty().next();
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            if (this._hasNext()) {
                if (this.remainder <= from) {
                    this.remainder = 0;
                } else if (from <= 0) {
                    if (until >= 0 && until < this.remainder) {
                        this.remainder = until;
                    }
                } else {
                    this.pos -= from;
                    this.remainder = until >= 0 && until < this.remainder ? (until <= from ? 0 : until - from) : (this.remainder -= from);
                }
            }
            return this;
        }
    }

    public static class Map<A, B>
    extends SeqView.Map<A, B>
    implements IndexedSeqView<B> {
        private static final long serialVersionUID = 3L;

        public Map(IndexedSeqOps<A, Object, ?> underlying, Function1<A, B> f) {
            super(underlying, f);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<B, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<B, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<B> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<B>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public B head() {
            return (B)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<B> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public B last() {
            return (B)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<B> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<B> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<B> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<B> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<B> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<B> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<B> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<B> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<B, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<B> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<B> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<B> tapEach(Function1<B, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class Prepended<A>
    extends SeqView.Prepended<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public Prepended(A elem, IndexedSeqOps<A, Object, ?> underlying) {
            super(elem, underlying);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class Reverse<A>
    extends SeqView.Reverse<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;
        private final IndexedSeqOps<A, Object, ?> underlying;

        public Reverse(IndexedSeqOps<A, Object, ?> underlying) {
            this.underlying = underlying;
            super(underlying);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            IndexedSeqOps<A, Object, ?> indexedSeqOps = this.underlying;
            if (indexedSeqOps instanceof IndexedSeqView) {
                IndexedSeqView indexedSeqView;
                IndexedSeqView x = indexedSeqView = (IndexedSeqView)indexedSeqOps;
                return x;
            }
            return IndexedSeqView.reverse$(this);
        }
    }

    public static class Slice<A>
    extends AbstractIndexedSeqView<A> {
        private static final long serialVersionUID = 3L;
        private final IndexedSeqOps<A, Object, ?> underlying;
        private final int lo;
        private final int hi;
        private final int len;

        public Slice(IndexedSeqOps<A, Object, ?> underlying, int from, int until) {
            this.underlying = underlying;
            this.lo = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0);
            this.hi = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(until), 0)), underlying.length());
            this.len = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.hi() - this.lo()), 0);
        }

        public int lo() {
            return this.lo;
        }

        public int hi() {
            return this.hi;
        }

        public int len() {
            return this.len;
        }

        @Override
        public A apply(int i) throws IndexOutOfBoundsException {
            return this.underlying.apply(this.lo() + i);
        }

        @Override
        public int length() {
            return this.len();
        }
    }

    public static class Take<A>
    extends SeqView.Take<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public Take(IndexedSeqOps<A, Object, ?> underlying, int n) {
            super(underlying, n);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }

    public static class TakeRight<A>
    extends SeqView.TakeRight<A>
    implements IndexedSeqView<A> {
        private static final long serialVersionUID = 3L;

        public TakeRight(IndexedSeqOps<A, Object, ?> underlying, int n) {
            super(underlying, n);
            IndexedSeqOps.$init$(this);
            IndexedSeqView.$init$(this);
        }

        @Override
        public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
            return (S)IndexedSeqOps.stepper$(this, shape);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)IndexedSeqOps.foldRight$(this, z, op);
        }

        @Override
        public Iterable<A> reversed() {
            return IndexedSeqOps.reversed$(this);
        }

        @Override
        public Iterator<View<A>> sliding(int size, int step) {
            return IndexedSeqOps.sliding$(this, size, step);
        }

        @Override
        public A head() {
            return (A)IndexedSeqOps.head$(this);
        }

        @Override
        public Option<A> headOption() {
            return IndexedSeqOps.headOption$(this);
        }

        @Override
        public A last() {
            return (A)IndexedSeqOps.last$(this);
        }

        @Override
        public final int lengthCompare(int len) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
        }

        @Override
        public int knownSize() {
            return IndexedSeqOps.knownSize$(this);
        }

        @Override
        public final int lengthCompare(Iterable<?> that) {
            return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, ord);
        }

        @Override
        public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
            return IndexedSeqOps.search$(this, elem, from, to, ord);
        }

        @Override
        public IndexedSeqView<A> view() {
            return IndexedSeqView.view$(this);
        }

        @Override
        public IndexedSeqView<A> view(int from, int until) {
            return IndexedSeqView.view$(this, from, until);
        }

        @Override
        public Iterator<A> iterator() {
            return IndexedSeqView.iterator$(this);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return IndexedSeqView.reverseIterator$(this);
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return IndexedSeqView.appended$(this, elem);
        }

        @Override
        public <B> IndexedSeqView<B> prepended(B elem) {
            return IndexedSeqView.prepended$(this, elem);
        }

        @Override
        public IndexedSeqView<A> take(int n) {
            return IndexedSeqView.take$(this, n);
        }

        @Override
        public IndexedSeqView<A> takeRight(int n) {
            return IndexedSeqView.takeRight$(this, n);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return IndexedSeqView.drop$(this, n);
        }

        @Override
        public IndexedSeqView<A> dropRight(int n) {
            return IndexedSeqView.dropRight$(this, n);
        }

        @Override
        public <B> IndexedSeqView<B> map(Function1<A, B> f) {
            return IndexedSeqView.map$(this, f);
        }

        @Override
        public IndexedSeqView<A> reverse() {
            return IndexedSeqView.reverse$(this);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return IndexedSeqView.slice$(this, from, until);
        }

        @Override
        public <U> IndexedSeqView<A> tapEach(Function1<A, U> f) {
            return IndexedSeqView.tapEach$(this, f);
        }

        @Override
        public <B> IndexedSeqView<B> concat(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.concat$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> appendedAll(IndexedSeqOps<B, Object, ?> suffix) {
            return IndexedSeqView.appendedAll$(this, suffix);
        }

        @Override
        public <B> IndexedSeqView<B> prependedAll(IndexedSeqOps<B, Object, ?> prefix) {
            return IndexedSeqView.prependedAll$(this, prefix);
        }

        @Override
        public String stringPrefix() {
            return IndexedSeqView.stringPrefix$(this);
        }
    }
}

