/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqSlidingIterator;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Searching;
import scala.collection.Searching$Found$;
import scala.collection.Searching$InsertionPoint$;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StringOps$;
import scala.collection.convert.impl.AnyIndexedSeqStepper;
import scala.collection.convert.impl.DoubleIndexedSeqStepper;
import scala.collection.convert.impl.IndexedStepperBase;
import scala.collection.convert.impl.IntIndexedSeqStepper;
import scala.collection.convert.impl.LongIndexedSeqStepper;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface IndexedSeqOps<A, CC, C>
extends SeqOps<A, CC, C> {
    public static void $init$(IndexedSeqOps $this) {
    }

    public static Iterator iterator$(IndexedSeqOps $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return this.view().iterator();
    }

    public static Stepper stepper$(IndexedSeqOps $this, StepperShape shape) {
        return $this.stepper(shape);
    }

    @Override
    default public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        int n = shape.shape();
        IndexedStepperBase s = StepperShape$.MODULE$.IntShape() == n ? new IntIndexedSeqStepper<IndexedSeqOps>(this, 0, this.length()) : (StepperShape$.MODULE$.LongShape() == n ? new LongIndexedSeqStepper<IndexedSeqOps>(this, 0, this.length()) : (StepperShape$.MODULE$.DoubleShape() == n ? new DoubleIndexedSeqStepper<IndexedSeqOps>(this, 0, this.length()) : shape.parUnbox(new AnyIndexedSeqStepper(this, 0, this.length()))));
        return (S)s;
    }

    public static Iterator reverseIterator$(IndexedSeqOps $this) {
        return $this.reverseIterator();
    }

    @Override
    default public Iterator<A> reverseIterator() {
        return this.view().reverseIterator();
    }

    private <B> B foldr(int start, int end, B z, Function2<A, B, B> op) {
        while (start != end) {
            int n = end - 1;
            B b = op.apply(this.apply(end - 1), z);
            end = n;
            z = b;
        }
        return z;
    }

    public static Object foldRight$(IndexedSeqOps $this, Object z, Function2 op) {
        return $this.foldRight(z, op);
    }

    @Override
    default public <B> B foldRight(B z, Function2<A, B, B> op) {
        return this.foldr(0, this.length(), z, op);
    }

    public static IndexedSeqView view$(IndexedSeqOps $this) {
        return $this.view();
    }

    @Override
    default public IndexedSeqView<A> view() {
        return new IndexedSeqView.Id(this);
    }

    public static IndexedSeqView view$(IndexedSeqOps $this, int from, int until) {
        return $this.view(from, until);
    }

    @Override
    default public IndexedSeqView<A> view(int from, int until) {
        return this.view().slice(from, until);
    }

    public static Iterable reversed$(IndexedSeqOps $this) {
        return $this.reversed();
    }

    @Override
    default public Iterable<A> reversed() {
        return new IndexedSeqView.Reverse(this);
    }

    public static Object prepended$(IndexedSeqOps $this, Object elem) {
        return $this.prepended(elem);
    }

    @Override
    default public <B> CC prepended(B elem) {
        return this.iterableFactory().from(new IndexedSeqView.Prepended<B>(elem, this));
    }

    public static Object take$(IndexedSeqOps $this, int n) {
        return $this.take(n);
    }

    @Override
    default public C take(int n) {
        return this.fromSpecific(new IndexedSeqView.Take(this, n));
    }

    public static Object takeRight$(IndexedSeqOps $this, int n) {
        return $this.takeRight(n);
    }

    @Override
    default public C takeRight(int n) {
        return this.fromSpecific(new IndexedSeqView.TakeRight(this, n));
    }

    public static Object drop$(IndexedSeqOps $this, int n) {
        return $this.drop(n);
    }

    @Override
    default public C drop(int n) {
        return this.fromSpecific(new IndexedSeqView.Drop(this, n));
    }

    public static Object dropRight$(IndexedSeqOps $this, int n) {
        return $this.dropRight(n);
    }

    @Override
    default public C dropRight(int n) {
        return this.fromSpecific(new IndexedSeqView.DropRight(this, n));
    }

    public static Object map$(IndexedSeqOps $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public <B> CC map(Function1<A, B> f) {
        return this.iterableFactory().from(new IndexedSeqView.Map<A, B>(this, f));
    }

    public static Object reverse$(IndexedSeqOps $this) {
        return $this.reverse();
    }

    @Override
    default public C reverse() {
        return this.fromSpecific(new IndexedSeqView.Reverse(this));
    }

    public static Object slice$(IndexedSeqOps $this, int from, int until) {
        return $this.slice(from, until);
    }

    @Override
    default public C slice(int from, int until) {
        return this.fromSpecific(new IndexedSeqView.Slice(this, from, until));
    }

    public static Iterator sliding$(IndexedSeqOps $this, int size, int step) {
        return $this.sliding(size, step);
    }

    @Override
    default public Iterator<C> sliding(int size, int step) {
        Predef$.MODULE$.require(size >= 1 && step >= 1, () -> IndexedSeqOps.sliding$$anonfun$1(size, step));
        IndexedSeqSlidingIterator it = new IndexedSeqSlidingIterator(this, size, step);
        return it;
    }

    public static Object head$(IndexedSeqOps $this) {
        return $this.head();
    }

    @Override
    default public A head() {
        String string2;
        if (!this.isEmpty()) {
            return this.apply(0);
        }
        IndexedSeqOps indexedSeqOps = this;
        if (indexedSeqOps instanceof IndexedSeq) {
            IndexedSeq indexedSeq;
            IndexedSeq self = indexedSeq = (IndexedSeq)indexedSeqOps;
            string2 = self.collectionClassName();
        } else {
            string2 = this.toString();
        }
        throw new NoSuchElementException("head of empty " + string2);
    }

    public static Option headOption$(IndexedSeqOps $this) {
        return $this.headOption();
    }

    @Override
    default public Option<A> headOption() {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.head());
    }

    public static Object last$(IndexedSeqOps $this) {
        return $this.last();
    }

    @Override
    default public A last() {
        String string2;
        if (!this.isEmpty()) {
            return this.apply(this.length() - 1);
        }
        IndexedSeqOps indexedSeqOps = this;
        if (indexedSeqOps instanceof IndexedSeq) {
            IndexedSeq indexedSeq;
            IndexedSeq self = indexedSeq = (IndexedSeq)indexedSeqOps;
            string2 = self.collectionClassName();
        } else {
            string2 = this.toString();
        }
        throw new NoSuchElementException("last of empty " + string2);
    }

    public static int lengthCompare$(IndexedSeqOps $this, int len) {
        return $this.lengthCompare(len);
    }

    @Override
    default public int lengthCompare(int len) {
        return Integer.compare(this.length(), len);
    }

    public static int knownSize$(IndexedSeqOps $this) {
        return $this.knownSize();
    }

    @Override
    default public int knownSize() {
        return this.length();
    }

    public static int lengthCompare$(IndexedSeqOps $this, Iterable that) {
        return $this.lengthCompare(that);
    }

    @Override
    default public int lengthCompare(Iterable<?> that) {
        int res = that.sizeCompare(this.length());
        if (res == Integer.MIN_VALUE) {
            return 1;
        }
        return -res;
    }

    public static Searching.SearchResult search$(IndexedSeqOps $this, Object elem, Ordering ord) {
        return $this.search(elem, ord);
    }

    @Override
    default public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return this.binarySearch(elem, 0, this.length(), ord);
    }

    public static Searching.SearchResult search$(IndexedSeqOps $this, Object elem, int from, int to, Ordering ord) {
        return $this.search(elem, from, to, ord);
    }

    @Override
    default public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return this.binarySearch(elem, from, to, ord);
    }

    private <B> Searching.SearchResult binarySearch(B elem, int from, int to, Ordering<B> ord) {
        int idx;
        while (true) {
            if (from < 0) {
                from = 0;
                continue;
            }
            if (to > this.length()) {
                to = this.length();
                continue;
            }
            if (to <= from) {
                return Searching$InsertionPoint$.MODULE$.apply(from);
            }
            idx = from + (to - from - 1) / 2;
            int n = package$.MODULE$.signum(ord.compare(elem, this.apply(idx)));
            if (-1 == n) {
                to = idx;
                continue;
            }
            if (1 != n) break;
            from = idx + 1;
        }
        return Searching$Found$.MODULE$.apply(idx);
    }

    private static Object sliding$$anonfun$1(int size$1, int step$1) {
        return StringOps$.MODULE$.format$extension("size=%d and step=%d, but both must be positive", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size$1), BoxesRunTime.boxToInteger(step$1)}));
    }
}

