/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapView;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class ListMapBuilder<K, V>
implements ReusableBuilder<Tuple2<K, V>, ListMap<K, V>> {
    private boolean isAliased;
    private ListMap<K, V> underlying;

    public ListMapBuilder() {
        Growable.$init$(this);
        Builder.$init$(this);
        this.isAliased = false;
        this.underlying = ListMap$.MODULE$.empty();
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public int knownSize() {
        return Growable.knownSize$(this);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<ListMap<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public void clear() {
        this.underlying = ListMap$.MODULE$.empty();
        this.isAliased = false;
    }

    @Override
    public ListMap<K, V> result() {
        this.isAliased = true;
        Statics.releaseFence();
        return this.underlying;
    }

    public ListMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        return this.addOne(elem._1(), elem._2());
    }

    private boolean insertValueAtKeyReturnFound(ListMap<K, V> m, K key, V value) {
        ListMap<K, V> listMap;
        while ((listMap = m) instanceof ListMap.Node) {
            ListMap.Node node = (ListMap.Node)listMap;
            ListMap.Node n = node;
            if (BoxesRunTime.equals(n.key(), key)) {
                n._value_$eq(value);
                return true;
            }
            m = n.init();
        }
        return false;
    }

    public ListMapBuilder<K, V> addOne(K key, V value) {
        if (this.isAliased) {
            this.underlying = this.underlying.updated((Object)key, value);
        } else if (!this.insertValueAtKeyReturnFound(this.underlying, key, value)) {
            this.underlying = new ListMap.Node<K, V>(key, value, this.underlying);
        }
        return this;
    }

    public ListMapBuilder<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        block12: {
            block11: {
                IterableOnce<Tuple2<K, V>> iterableOnce;
                block10: {
                    if (this.isAliased) {
                        return (ListMapBuilder)Growable.addAll$(this, xs);
                    }
                    if (this.underlying.nonEmpty()) {
                        IterableOnce<Tuple2<K, V>> iterableOnce2 = xs;
                        if (iterableOnce2 instanceof Map) {
                            Map map;
                            Map m = map = (Map)iterableOnce2;
                            Iterator iter = m.iterator();
                            ListMap<K, V> newUnderlying = this.underlying;
                            while (iter.hasNext()) {
                                Tuple2 next = (Tuple2)iter.next();
                                if (this.insertValueAtKeyReturnFound(this.underlying, next._1(), next._2())) continue;
                                newUnderlying = new ListMap.Node(next._1(), next._2(), newUnderlying);
                            }
                            this.underlying = newUnderlying;
                            return this;
                        }
                        return (ListMapBuilder)Growable.addAll$(this, xs);
                    }
                    iterableOnce = xs;
                    if (iterableOnce instanceof LinkedHashMap) {
                        LinkedHashMap linkedHashMap;
                        LinkedHashMap lhm = linkedHashMap = (LinkedHashMap)iterableOnce;
                        LinkedHashMap.LinkedEntry firstEntry = lhm._firstEntry();
                        while (!(firstEntry == null)) {
                            this.underlying = new ListMap.Node(firstEntry.key(), firstEntry.value(), this.underlying);
                            firstEntry = firstEntry.later();
                        }
                        return this;
                    }
                    if (!(iterableOnce instanceof Map)) break block10;
                    Map map = (Map)iterableOnce;
                    break block11;
                }
                if (!(iterableOnce instanceof MapView)) break block12;
                MapView mapView = (MapView)iterableOnce;
            }
            Iterator<Tuple2<K, V>> iter = xs.iterator();
            while (iter.hasNext()) {
                Tuple2<K, V> tuple2;
                Tuple2<K, V> $3$;
                Tuple2<K, V> tuple22 = $3$ = (tuple2 = iter.next());
                K k = tuple22._1();
                V v = tuple22._2();
                this.underlying = new ListMap.Node<K, V>(k, v, this.underlying);
            }
            return this;
        }
        return (ListMapBuilder)Growable.addAll$(this, xs);
    }
}

