/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.spatial.Domain;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class DomainConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1220801, 1220808);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1220801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1220802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1220803: {
                func = new UnknownPackageAttributeValidationFunction<Domain>("spatial"){

                    public boolean check(ValidationContext ctx, Domain dom) {
                        if (!dom.isSetId()) {
                            return false;
                        }
                        if (!dom.isSetDomainType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)dom);
                    }
                };
                break;
            }
            case 1220804: {
                func = new ValidationFunction<Domain>(){

                    public boolean check(ValidationContext ctx, Domain dom) {
                        boolean onlyOneList = new DuplicatedElementValidationFunction("listOfInteriorPoints").check(ctx, (TreeNodeWithChangeSupport)dom);
                        boolean noOtherElements = new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)dom);
                        return onlyOneList && noOtherElements;
                    }
                };
                break;
            }
            case 1220805: {
                func = new ValidationFunction<Domain>(){

                    public boolean check(ValidationContext ctx, Domain dom) {
                        Geometry g;
                        DomainType dt;
                        Model m;
                        SpatialModelPlugin smp;
                        return !dom.isSetDomainType() || !(smp = (SpatialModelPlugin)(m = dom.getModel()).getPlugin("spatial")).isSetGeometry() || (dt = (g = smp.getGeometry()).getDomainType(dom.getDomainType())) != null;
                    }
                };
                break;
            }
            case 1220806: {
                func = new ValidationFunction<Domain>(){

                    public boolean check(ValidationContext ctx, Domain dom) {
                        return true;
                    }
                };
            }
            case 1220807: {
                func = new ValidationFunction<Domain>(){

                    public boolean check(ValidationContext ctx, Domain dom) {
                        if (dom.isSetListOfInteriorPoints()) {
                            return new UnknownElementValidationFunction().check(ctx, dom.getListOfInteriorPoints());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1220808: {
                func = new ValidationFunction<Domain>(){

                    public boolean check(ValidationContext ctx, Domain dom) {
                        if (dom.isSetListOfInteriorPoints()) {
                            return new UnknownAttributeValidationFunction().check(ctx, dom.getListOfInteriorPoints());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

