/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.spatial.CSGNode;
import org.sbml.jsbml.ext.spatial.CSGSetOperator;
import org.sbml.jsbml.ext.spatial.SetOperation;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CSGSetOperatorConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 0x12AA21, 1223209);
                this.addRangeToSet(set, 1223250, 1223251);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 0x12AA21: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 0x12AA22: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223203: {
                func = new UnknownPackageAttributeValidationFunction<CSGSetOperator>("spatial"){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        if (!csgso.isSetOperationType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)csgso);
                    }
                };
                break;
            }
            case 1223204: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        return new DuplicatedElementValidationFunction("listOfCSGNodes").check(ctx, (TreeNodeWithChangeSupport)csgso) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)csgso);
                    }
                };
                break;
            }
            case 1223205: {
                func = new InvalidAttributeValidationFunction("operationType");
                break;
            }
            case 1223206: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        if (csgso.isSetComplementA()) {
                            if (csgso.isSetListOfCSGNodes()) {
                                ListOf<CSGNode> losn = csgso.getListOfCSGNodes();
                                for (CSGNode node : losn) {
                                    if (!node.getId().equals(csgso.getComplementA())) continue;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223207: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        if (csgso.isSetComplementB()) {
                            if (csgso.isSetListOfCSGNodes()) {
                                ListOf<CSGNode> losn = csgso.getListOfCSGNodes();
                                for (CSGNode node : losn) {
                                    if (!node.getId().equals(csgso.getComplementB())) continue;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223208: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        if (csgso.isSetListOfCSGNodes()) {
                            return new UnknownElementValidationFunction().check(ctx, csgso.getListOfCSGNodes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223209: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        if (csgso.isSetListOfCSGNodes()) {
                            return new UnknownAttributeValidationFunction().check(ctx, csgso.getListOfCSGNodes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223250: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        if (csgso.getOperationType() == SetOperation.difference) {
                            return csgso.isSetComplementA() && csgso.isSetComplementB();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223251: {
                func = new ValidationFunction<CSGSetOperator>(){

                    public boolean check(ValidationContext ctx, CSGSetOperator csgso) {
                        return csgso.getOperationType() != SetOperation.union && csgso.getOperationType() != SetOperation.intersection || !csgso.isSetComplementA() && !csgso.isSetComplementB();
                    }
                };
            }
        }
        return func;
    }
}

