/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.CSGHomogeneousTransformation;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CSGHomogeneousTransformationConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222901, 1222903);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222903: {
                func = new ValidationFunction<CSGHomogeneousTransformation>(){

                    public boolean check(ValidationContext ctx, CSGHomogeneousTransformation csgh) {
                        return new DuplicatedElementValidationFunction("forwardTransformation").check(ctx, (TreeNodeWithChangeSupport)csgh) && new DuplicatedElementValidationFunction("reverseTransformation").check(ctx, (TreeNodeWithChangeSupport)csgh) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)csgh);
                    }
                };
            }
        }
        return func;
    }
}

