/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;

public class ParameterType
extends AbstractSBase {
    private static final transient Logger logger = Logger.getLogger(ParameterType.class);
    private static final long serialVersionUID = 1359841900912406174L;
    private String spatialRef;
    private String variable;

    public ParameterType() {
        this.initDefaults();
    }

    public ParameterType(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public ParameterType(ParameterType ref) {
        super((SBase)ref);
        if (ref.isSetSpatialRef()) {
            this.setSpatialRef(ref.getSpatialRef());
        }
        if (ref.isSetVariable()) {
            this.setVariable(ref.getVariable());
        }
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "spatial";
    }

    public Geometry getGeometryInstance() {
        Model model = this.getModel();
        SpatialModelPlugin m = (SpatialModelPlugin)model.getExtension("spatial");
        return m.getGeometry();
    }

    public String getSpId() {
        return this.getSpatialRef();
    }

    public String getSpatialRef() {
        return this.isSetSpId() ? this.spatialRef : "";
    }

    public boolean isSetSpId() {
        return this.isSetSpatialRef();
    }

    public boolean isSetSpatialRef() {
        return this.spatialRef != null;
    }

    public void setSpId(String spatialRef) {
        this.setSpatialRef(spatialRef);
    }

    public void setSpatialRef(String spatialRef) {
        String oldSpatialRef = this.spatialRef;
        this.spatialRef = spatialRef;
        this.firePropertyChange("spatialRef", oldSpatialRef, this.spatialRef);
    }

    public String getVariable() {
        if (this.isSetVariable()) {
            return this.variable;
        }
        return "";
    }

    public SBase getVariableInstance() {
        Model model = this.getModel();
        SBase sbase = model != null ? model.findUniqueSBase(this.variable) : null;
        return sbase;
    }

    public Species getSpeciesInstance() {
        SBase sbase = this.getVariableInstance();
        if (sbase != null && sbase instanceof Species) {
            return (Species)sbase;
        }
        return null;
    }

    public String getSpeciesReference() {
        return this.getVariable();
    }

    public Parameter getParameterInstance() {
        SBase sbase = this.getVariableInstance();
        if (sbase != null && sbase instanceof Parameter) {
            return (Parameter)sbase;
        }
        return null;
    }

    public boolean isSetSpeciesReference() {
        return this.isSetVariable();
    }

    public boolean isSetVariable() {
        return this.variable != null;
    }

    public void setSpeciesReference(String variable) {
        this.setVariable(variable);
    }

    public void setVariable(String variable) {
        String oldVariable = this.variable;
        this.variable = variable;
        this.firePropertyChange("variable", oldVariable, this.variable);
    }

    public boolean unsetSpatialRef() {
        if (this.isSetSpatialRef()) {
            String oldSpatialRef = this.spatialRef;
            this.spatialRef = null;
            this.firePropertyChange("spatialRef", oldSpatialRef, this.spatialRef);
            return true;
        }
        return false;
    }

    public boolean unsetVariable() {
        if (this.isSetVariable()) {
            String oldVariable = this.variable;
            this.variable = null;
            this.firePropertyChange("variable", oldVariable, this.variable);
            return true;
        }
        return false;
    }

    public void setSpeciesRef(String variable) {
        this.setVariable(variable);
    }

    public ParameterType clone() {
        return new ParameterType(this);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ParameterType param = (ParameterType)((Object)object);
            if (param.isSetSpId()) {
                equal &= param.getSpId().equals(this.getSpId());
            }
            if (param.isSetVariable()) {
                equal &= param.getVariable().equals(this.getVariable());
            }
        }
        return equal;
    }

    public int hashCode() {
        int prime = 1901;
        int hashCode = super.hashCode();
        if (this.isSetSpId()) {
            hashCode += 1901 * this.getSpId().hashCode();
        }
        if (this.isSetVariable()) {
            hashCode += 1901 * this.getVariable().hashCode();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetSpId()) {
            attributes.put("spatial:spatialRef", this.getSpId());
        }
        if (this.isSetVariable()) {
            attributes.put("spatial:variable", String.valueOf(this.getVariable()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("spatialRef")) {
                try {
                    this.setSpatialRef(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "spatialRef", this.getElementName()));
                }
            } else if (attributeName.equals("variable")) {
                try {
                    this.setVariable(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "variable", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

