/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.reflector;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.robolectric.util.Util;
import sun.misc.Unsafe;

public class UnsafeAccess {
    private static final Danger DANGER = Util.getJavaVersion() < 11 ? new DangerPre11() : new Danger11Plus();

    static <T> Class<?> defineClass(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
        return DANGER.defineClass(iClass, reflectorClassName, bytecode);
    }

    static interface Danger {
        public <T> Class<?> defineClass(Class<T> var1, String var2, byte[] var3);
    }

    private static class DangerPre11
    implements Danger {
        private final Unsafe unsafe;
        private final Method defineClassMethod;

        private DangerPre11() {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                this.unsafe = (Unsafe)unsafeField.get(null);
                this.defineClassMethod = Unsafe.class.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public <T> Class<?> defineClass(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
            try {
                return (Class)this.defineClassMethod.invoke((Object)this.unsafe, reflectorClassName, bytecode, 0, bytecode.length, iClass.getClassLoader(), null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static class Danger11Plus
    implements Danger {
        private final Method privateLookupInMethod;
        private final Method defineClassMethod;

        private Danger11Plus() {
            try {
                this.privateLookupInMethod = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                this.defineClassMethod = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public <T> Class<?> defineClass(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                MethodHandles.Lookup privateLookup = (MethodHandles.Lookup)this.privateLookupInMethod.invoke((Object)lookup, iClass, lookup);
                return (Class)this.defineClassMethod.invoke((Object)privateLookup, new Object[]{bytecode});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

