/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassInfo;
import org.robolectric.internal.bytecode.DirectObjectMarker;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.InvokeDynamic;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.MethodRef;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowImpl;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Util;

public class SandboxClassLoader
extends URLClassLoader
implements Opcodes {
    private final URLClassLoader systemClassLoader;
    private final URLClassLoader urls;
    private final InstrumentationConfiguration config;
    private final Map<String, String> classesToRemap;
    private final Set<MethodRef> methodsToIntercept;

    public SandboxClassLoader(InstrumentationConfiguration config) {
        this((URLClassLoader)ClassLoader.getSystemClassLoader(), config, new URL[0]);
    }

    public SandboxClassLoader(URLClassLoader systemClassLoader, InstrumentationConfiguration config, URL ... urls) {
        super(systemClassLoader.getURLs(), systemClassLoader.getParent());
        this.systemClassLoader = systemClassLoader;
        this.config = config;
        this.urls = new URLClassLoader(urls, null);
        this.classesToRemap = this.convertToSlashes(config.classNameTranslations());
        this.methodsToIntercept = this.convertToSlashes(config.methodsToIntercept());
        for (URL url : urls) {
            Logger.debug((String)"Loading classes from: %s", (Object[])new Object[]{url});
        }
    }

    @Override
    public URL getResource(String name) {
        URL fromParent = super.getResource(name);
        if (fromParent != null) {
            return fromParent;
        }
        return this.urls.getResource(name);
    }

    private InputStream getClassBytesAsStreamPreferringLocalUrls(String resName) {
        InputStream fromUrlsClassLoader = this.urls.getResourceAsStream(resName);
        if (fromUrlsClassLoader != null) {
            return fromUrlsClassLoader;
        }
        return super.getResourceAsStream(resName);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.config.shouldAcquire(name)) {
            return this.maybeInstrumentClass(name);
        }
        return this.systemClassLoader.loadClass(name);
    }

    protected Class<?> maybeInstrumentClass(String className) throws ClassNotFoundException {
        byte[] origClassBytes = this.getByteCode(className);
        ClassNode classNode = new ClassNode(262144){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                desc = SandboxClassLoader.this.remapParamType(desc);
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(access, name, SandboxClassLoader.this.remapParams(desc), signature, exceptions);
                return new JSRInlinerAdapter(methodVisitor, access, name, desc, signature, exceptions);
            }
        };
        ClassReader classReader = new ClassReader(origClassBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.interfaces.add(Type.getInternalName(ShadowedObject.class));
        try {
            ClassInfo classInfo = new ClassInfo(className, classNode);
            byte[] bytes = this.config.shouldInstrument(classInfo) ? this.getInstrumentedBytes(classNode, this.config.containsStubs(classInfo)) : origClassBytes;
            this.ensurePackage(className);
            return this.defineClass(className, bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("couldn't load " + className, e);
        }
        catch (OutOfMemoryError e) {
            System.err.println("[ERROR] couldn't load " + className + " in " + this);
            throw e;
        }
    }

    @Override
    protected Package getPackage(String name) {
        Package aPackage = super.getPackage(name);
        if (aPackage != null) {
            return aPackage;
        }
        return (Package)ReflectionHelpers.callInstanceMethod((Object)this.systemClassLoader, (String)"getPackage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)name)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getByteCode(String className) throws ClassNotFoundException {
        String classFilename = className.replace('.', '/') + ".class";
        try (InputStream classBytesStream = this.getClassBytesAsStreamPreferringLocalUrls(classFilename);){
            if (classBytesStream == null) {
                throw new ClassNotFoundException(className);
            }
            byte[] byArray = Util.readBytes((InputStream)classBytesStream);
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("couldn't load " + className, e);
        }
    }

    private void ensurePackage(String className) {
        String pckgName;
        Package pckg;
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex != -1 && (pckg = this.getPackage(pckgName = className.substring(0, lastDotIndex))) == null) {
            this.definePackage(pckgName, null, null, null, null, null, null, null);
        }
    }

    private String remapParams(String desc) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (Type type : Type.getArgumentTypes((String)desc)) {
            buf.append(this.remapParamType(type));
        }
        buf.append(")");
        buf.append(this.remapParamType(Type.getReturnType((String)desc)));
        return buf.toString();
    }

    private String remapParamType(String desc) {
        return this.remapParamType(Type.getType((String)desc));
    }

    private String remapParamType(Type type) {
        switch (type.getSort()) {
            case 9: {
                String internalName = type.getInternalName();
                int count = 0;
                while (internalName.charAt(count) == '[') {
                    ++count;
                }
                String remappedName = this.remapParamType(internalName.substring(count));
                if (remappedName == null) break;
                return Type.getObjectType((String)(internalName.substring(0, count) + remappedName)).getDescriptor();
            }
            case 10: {
                String internalName = type.getInternalName();
                String remappedName = this.classesToRemap.get(internalName);
                if (remappedName == null) break;
                return Type.getObjectType((String)remappedName).getDescriptor();
            }
        }
        return type.getDescriptor();
    }

    private String remapType(String value) {
        String remappedValue = this.classesToRemap.get(value);
        if (remappedValue != null) {
            value = remappedValue;
        }
        return value;
    }

    private byte[] getInstrumentedBytes(ClassNode classNode, boolean containsStubs) throws ClassNotFoundException {
        if (InvokeDynamic.ENABLED) {
            new InvokeDynamicClassInstrumentor(classNode, containsStubs).instrument();
        } else {
            new OldClassInstrumentor(classNode, containsStubs).instrument();
        }
        InstrumentingClassWriter writer = new InstrumentingClassWriter(classNode);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private Map<String, String> convertToSlashes(Map<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = this.internalize(entry.getKey());
            String value = this.internalize(entry.getValue());
            newMap.put(key, value);
            newMap.put("L" + key + ";", "L" + value + ";");
        }
        return newMap;
    }

    private Set<MethodRef> convertToSlashes(Set<MethodRef> methodRefs) {
        HashSet<MethodRef> transformed = new HashSet<MethodRef>();
        for (MethodRef methodRef : methodRefs) {
            transformed.add(new MethodRef(this.internalize(methodRef.className), methodRef.methodName));
        }
        return transformed;
    }

    private String internalize(String className) {
        return className.replace('.', '/');
    }

    public static void box(Type type, ListIterator<AbstractInsnNode> instructions) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            Type boxed = SandboxClassLoader.getBoxedType(type);
            instructions.add((AbstractInsnNode)new TypeInsnNode(187, boxed.getInternalName()));
            if (type.getSize() == 2) {
                instructions.add((AbstractInsnNode)new InsnNode(91));
                instructions.add((AbstractInsnNode)new InsnNode(91));
                instructions.add((AbstractInsnNode)new InsnNode(87));
            } else {
                instructions.add((AbstractInsnNode)new InsnNode(90));
                instructions.add((AbstractInsnNode)new InsnNode(95));
            }
            instructions.add((AbstractInsnNode)new MethodInsnNode(183, boxed.getInternalName(), "<init>", "(" + type.getDescriptor() + ")V"));
        }
    }

    private static Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return Type.getObjectType((String)"java/lang/Byte");
            }
            case 1: {
                return Type.getObjectType((String)"java/lang/Boolean");
            }
            case 4: {
                return Type.getObjectType((String)"java/lang/Short");
            }
            case 2: {
                return Type.getObjectType((String)"java/lang/Character");
            }
            case 5: {
                return Type.getObjectType((String)"java/lang/Integer");
            }
            case 6: {
                return Type.getObjectType((String)"java/lang/Float");
            }
            case 7: {
                return Type.getObjectType((String)"java/lang/Long");
            }
            case 8: {
                return Type.getObjectType((String)"java/lang/Double");
            }
        }
        return type;
    }

    private boolean shouldIntercept(MethodInsnNode targetMethod) {
        if (targetMethod.name.equals("<init>")) {
            return false;
        }
        return this.methodsToIntercept.contains(new MethodRef(targetMethod.owner, targetMethod.name)) || this.methodsToIntercept.contains(new MethodRef(targetMethod.owner, "*"));
    }

    public class InvokeDynamicClassInstrumentor
    extends ClassInstrumentor {
        private final Handle BOOTSTRAP_INIT;
        private final Handle BOOTSTRAP;
        private final Handle BOOTSTRAP_STATIC;
        private final Handle BOOTSTRAP_INTRINSIC;

        public InvokeDynamicClassInstrumentor(ClassNode classNode, boolean containsStubs) {
            super(classNode, containsStubs);
            String className = Type.getInternalName(InvokeDynamicSupport.class);
            MethodType bootstrap = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
            String bootstrapMethod = bootstrap.appendParameterTypes(MethodHandle.class).toMethodDescriptorString();
            String bootstrapIntrinsic = bootstrap.appendParameterTypes(String.class).toMethodDescriptorString();
            this.BOOTSTRAP_INIT = new Handle(6, className, "bootstrapInit", bootstrap.toMethodDescriptorString());
            this.BOOTSTRAP = new Handle(6, className, "bootstrap", bootstrapMethod);
            this.BOOTSTRAP_STATIC = new Handle(6, className, "bootstrapStatic", bootstrapMethod);
            this.BOOTSTRAP_INTRINSIC = new Handle(6, className, "bootstrapIntrinsic", bootstrapIntrinsic);
        }

        @Override
        protected void addDirectCallConstructor() {
        }

        @Override
        protected void writeCallToInitializing(RobolectricGeneratorAdapter generator) {
            generator.invokeDynamic("initializing", Type.getMethodDescriptor((Type)this.OBJECT_TYPE, (Type[])new Type[]{this.classType}), this.BOOTSTRAP_INIT, new Object[0]);
        }

        @Override
        protected void generateShadowCall(MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
            this.generateInvokeDynamic(originalMethod, originalMethodName, generator);
        }

        private void generateInvokeDynamic(MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
            Handle original = new Handle(this.getTag(originalMethod), this.classType.getInternalName(), originalMethod.name, originalMethod.desc);
            if (generator.isStatic()) {
                generator.loadArgs();
                generator.invokeDynamic(originalMethodName, originalMethod.desc, this.BOOTSTRAP_STATIC, new Object[]{original});
            } else {
                String desc = "(" + this.classType.getDescriptor() + originalMethod.desc.substring(1);
                generator.loadThis();
                generator.loadArgs();
                generator.invokeDynamic(originalMethodName, desc, this.BOOTSTRAP, new Object[]{original});
            }
            generator.returnValue();
        }

        @Override
        protected void interceptInvokeVirtualMethod(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
            this.interceptInvokeVirtualMethodWithInvokeDynamic(instructions, targetMethod);
        }

        private void interceptInvokeVirtualMethodWithInvokeDynamic(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
            instructions.remove();
            Type type = Type.getObjectType((String)targetMethod.owner);
            String description = targetMethod.desc;
            String owner = type.getClassName();
            if (targetMethod.getOpcode() != 184) {
                String thisType = type.getDescriptor();
                description = "(" + thisType + description.substring(1, description.length());
            }
            instructions.add((AbstractInsnNode)new InvokeDynamicInsnNode(targetMethod.name, description, this.BOOTSTRAP_INTRINSIC, new Object[]{owner}));
        }
    }

    public class OldClassInstrumentor
    extends ClassInstrumentor {
        private final Type PLAN_TYPE;
        private final Type THROWABLE_TYPE;
        private final Method INITIALIZING_METHOD;
        private final Method METHOD_INVOKED_METHOD;
        private final Method PLAN_RUN_METHOD;
        private final Method HANDLE_EXCEPTION_METHOD;
        private final String DIRECT_OBJECT_MARKER_TYPE_DESC;
        private final Type ROBOLECTRIC_INTERNALS_TYPE;

        public OldClassInstrumentor(ClassNode classNode, boolean containsStubs) {
            super(classNode, containsStubs);
            this.PLAN_TYPE = Type.getType(ClassHandler.Plan.class);
            this.THROWABLE_TYPE = Type.getType(Throwable.class);
            this.INITIALIZING_METHOD = new Method("initializing", "(Ljava/lang/Object;)Ljava/lang/Object;");
            this.METHOD_INVOKED_METHOD = new Method("methodInvoked", "(Ljava/lang/String;ZLjava/lang/Class;)L" + this.PLAN_TYPE.getInternalName() + ";");
            this.PLAN_RUN_METHOD = new Method("run", this.OBJECT_TYPE, new Type[]{this.OBJECT_TYPE, this.OBJECT_TYPE, Type.getType(Object[].class)});
            this.HANDLE_EXCEPTION_METHOD = new Method("cleanStackTrace", this.THROWABLE_TYPE, new Type[]{this.THROWABLE_TYPE});
            this.DIRECT_OBJECT_MARKER_TYPE_DESC = Type.getObjectType((String)DirectObjectMarker.class.getName().replace('.', '/')).getDescriptor();
            this.ROBOLECTRIC_INTERNALS_TYPE = Type.getType(RobolectricInternals.class);
        }

        @Override
        protected void addDirectCallConstructor() {
            MethodNode directCallConstructor = new MethodNode(1, "<init>", "(" + this.DIRECT_OBJECT_MARKER_TYPE_DESC + this.classType.getDescriptor() + ")V", null, null);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(directCallConstructor);
            generator.loadThis();
            if (this.classNode.superName.equals("java/lang/Object")) {
                generator.visitMethodInsn(183, this.classNode.superName, "<init>", "()V");
            } else {
                generator.loadArgs();
                generator.visitMethodInsn(183, this.classNode.superName, "<init>", "(" + this.DIRECT_OBJECT_MARKER_TYPE_DESC + "L" + this.classNode.superName + ";)V");
            }
            generator.loadThis();
            generator.loadArg(1);
            generator.putField(this.classType, "__robo_data__", this.OBJECT_TYPE);
            generator.returnValue();
            this.classNode.methods.add(directCallConstructor);
        }

        @Override
        protected void writeCallToInitializing(RobolectricGeneratorAdapter generator) {
            generator.invokeStatic(this.ROBOLECTRIC_INTERNALS_TYPE, this.INITIALIZING_METHOD);
        }

        @Override
        protected void generateShadowCall(MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
            this.generateCallToClassHandler(originalMethod, originalMethodName, generator);
        }

        private void generateCallToClassHandler(MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
            boolean isNormalInstanceMethod;
            int planLocalVar = generator.newLocal(this.PLAN_TYPE);
            int exceptionLocalVar = generator.newLocal(this.THROWABLE_TYPE);
            Label directCall = new Label();
            Label doReturn = new Label();
            boolean bl = isNormalInstanceMethod = !generator.isStatic && !originalMethodName.equals("__constructor__");
            if (isNormalInstanceMethod) {
                Label notInstanceOfThis = new Label();
                generator.loadThis();
                generator.getField(this.classType, "__robo_data__", this.OBJECT_TYPE);
                generator.instanceOf(this.classType);
                generator.visitJumpInsn(153, notInstanceOfThis);
                TryCatch tryCatchForProxyCall = generator.tryStart(this.THROWABLE_TYPE);
                generator.loadThis();
                generator.getField(this.classType, "__robo_data__", this.OBJECT_TYPE);
                generator.checkCast(this.classType);
                generator.loadArgs();
                generator.visitMethodInsn(183, this.internalClassName, originalMethod.name, originalMethod.desc);
                tryCatchForProxyCall.end();
                generator.returnValue();
                tryCatchForProxyCall.handler();
                generator.storeLocal(exceptionLocalVar);
                generator.loadLocal(exceptionLocalVar);
                generator.invokeStatic(this.ROBOLECTRIC_INTERNALS_TYPE, this.HANDLE_EXCEPTION_METHOD);
                generator.throwException();
                generator.mark(notInstanceOfThis);
            }
            generator.push(this.classType.getInternalName() + "/" + originalMethodName + originalMethod.desc);
            generator.push(generator.isStatic());
            generator.push(this.classType);
            generator.invokeStatic(this.ROBOLECTRIC_INTERNALS_TYPE, this.METHOD_INVOKED_METHOD);
            generator.storeLocal(planLocalVar);
            generator.loadLocal(planLocalVar);
            generator.ifNull(directCall);
            TryCatch tryCatchForHandler = generator.tryStart(this.THROWABLE_TYPE);
            generator.loadLocal(planLocalVar);
            generator.loadThisOrNull();
            if (generator.isStatic()) {
                generator.loadNull();
            } else {
                generator.loadThis();
                generator.invokeVirtual(this.classType, new Method("$$robo$getData", "()Ljava/lang/Object;"));
            }
            generator.loadArgArray();
            generator.invokeInterface(this.PLAN_TYPE, this.PLAN_RUN_METHOD);
            Type returnType = generator.getReturnType();
            int sort = returnType.getSort();
            switch (sort) {
                case 0: {
                    generator.pop();
                    break;
                }
                case 9: 
                case 10: {
                    generator.checkCast(returnType);
                    break;
                }
                default: {
                    int unboxLocalVar = generator.newLocal(this.OBJECT_TYPE);
                    generator.storeLocal(unboxLocalVar);
                    generator.loadLocal(unboxLocalVar);
                    Label notNull = generator.newLabel();
                    Label afterward = generator.newLabel();
                    generator.ifNonNull(notNull);
                    generator.pushDefaultReturnValueToStack(returnType);
                    generator.goTo(afterward);
                    generator.mark(notNull);
                    generator.loadLocal(unboxLocalVar);
                    generator.unbox(returnType);
                    generator.mark(afterward);
                }
            }
            tryCatchForHandler.end();
            generator.goTo(doReturn);
            tryCatchForHandler.handler();
            generator.storeLocal(exceptionLocalVar);
            generator.loadLocal(exceptionLocalVar);
            generator.invokeStatic(this.ROBOLECTRIC_INTERNALS_TYPE, this.HANDLE_EXCEPTION_METHOD);
            generator.throwException();
            if (!originalMethod.name.equals("<init>")) {
                generator.mark(directCall);
                TryCatch tryCatchForDirect = generator.tryStart(this.THROWABLE_TYPE);
                generator.invokeMethod(this.classType.getInternalName(), originalMethod.name, originalMethod.desc);
                tryCatchForDirect.end();
                generator.returnValue();
                tryCatchForDirect.handler();
                generator.storeLocal(exceptionLocalVar);
                generator.loadLocal(exceptionLocalVar);
                generator.invokeStatic(this.ROBOLECTRIC_INTERNALS_TYPE, this.HANDLE_EXCEPTION_METHOD);
                generator.throwException();
            }
            generator.mark(doReturn);
            generator.returnValue();
        }

        @Override
        protected void interceptInvokeVirtualMethod(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
            this.interceptInvokeVirtualMethodWithoutInvokeDynamic(instructions, targetMethod);
        }

        private void interceptInvokeVirtualMethodWithoutInvokeDynamic(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
            boolean isStatic = targetMethod.getOpcode() == 184;
            instructions.remove();
            Type[] argumentTypes = Type.getArgumentTypes((String)targetMethod.desc);
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)argumentTypes.length));
            instructions.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
            for (int i = argumentTypes.length - 1; i >= 0; --i) {
                Type type = argumentTypes[i];
                int argWidth = type.getSize();
                if (argWidth == 1) {
                    instructions.add((AbstractInsnNode)new InsnNode(90));
                    instructions.add((AbstractInsnNode)new InsnNode(95));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)i));
                    instructions.add((AbstractInsnNode)new InsnNode(95));
                    SandboxClassLoader.box(type, instructions);
                    instructions.add((AbstractInsnNode)new InsnNode(83));
                    continue;
                }
                if (argWidth != 2) continue;
                instructions.add((AbstractInsnNode)new InsnNode(91));
                instructions.add((AbstractInsnNode)new InsnNode(91));
                instructions.add((AbstractInsnNode)new InsnNode(87));
                SandboxClassLoader.box(type, instructions);
                instructions.add((AbstractInsnNode)new LdcInsnNode((Object)i));
                instructions.add((AbstractInsnNode)new InsnNode(95));
                instructions.add((AbstractInsnNode)new InsnNode(83));
            }
            if (isStatic) {
                instructions.add((AbstractInsnNode)new InsnNode(1));
                instructions.add((AbstractInsnNode)new InsnNode(95));
            }
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)(targetMethod.owner + "/" + targetMethod.name + targetMethod.desc)));
            instructions.add((AbstractInsnNode)new InsnNode(91));
            instructions.add((AbstractInsnNode)new InsnNode(87));
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)this.classType));
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, Type.getType(RobolectricInternals.class).getInternalName(), "intercept", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;"));
            Type returnType = Type.getReturnType((String)targetMethod.desc);
            switch (returnType.getSort()) {
                case 9: 
                case 10: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, SandboxClassLoader.this.remapType(returnType.getInternalName())));
                    break;
                }
                case 0: {
                    instructions.add((AbstractInsnNode)new InsnNode(87));
                    break;
                }
                case 7: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Long.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Long.class), "longValue", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                case 6: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Float.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Float.class), "floatValue", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                case 8: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Double.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Double.class), "doubleValue", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                case 1: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Boolean.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                case 5: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Integer.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Integer.class), "intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                case 4: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Short.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Short.class), "shortValue", Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                case 3: {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Byte.class)));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Byte.class), "byteValue", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), false));
                    break;
                }
                default: {
                    throw new RuntimeException("Not implemented: " + this.getClass().getName() + " cannot intercept methods with return type " + returnType.getClassName());
                }
            }
        }
    }

    static class TryCatch {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final GeneratorAdapter generatorAdapter;

        TryCatch(GeneratorAdapter generatorAdapter, Type type) {
            this.generatorAdapter = generatorAdapter;
            this.start = generatorAdapter.mark();
            this.end = new Label();
            this.handler = new Label();
            generatorAdapter.visitTryCatchBlock(this.start, this.end, this.handler, type.getInternalName());
        }

        void end() {
            this.generatorAdapter.mark(this.end);
        }

        void handler() {
            this.generatorAdapter.mark(this.handler);
        }
    }

    private static class RobolectricGeneratorAdapter
    extends GeneratorAdapter {
        private final boolean isStatic;
        private final String desc;

        public RobolectricGeneratorAdapter(MethodNode methodNode) {
            super(262144, (MethodVisitor)methodNode, methodNode.access, methodNode.name, methodNode.desc);
            this.isStatic = Modifier.isStatic(methodNode.access);
            this.desc = methodNode.desc;
        }

        public void loadThisOrNull() {
            if (this.isStatic) {
                this.loadNull();
            } else {
                this.loadThis();
            }
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public void loadNull() {
            this.visitInsn(1);
        }

        public Type getReturnType() {
            return Type.getReturnType((String)this.desc);
        }

        public void pushDefaultReturnValueToStack(Type type) {
            if (type.equals((Object)Type.BOOLEAN_TYPE)) {
                this.push(false);
            } else if (type.equals((Object)Type.INT_TYPE) || type.equals((Object)Type.SHORT_TYPE) || type.equals((Object)Type.BYTE_TYPE) || type.equals((Object)Type.CHAR_TYPE)) {
                this.push(0);
            } else if (type.equals((Object)Type.LONG_TYPE)) {
                this.push(0L);
            } else if (type.equals((Object)Type.FLOAT_TYPE)) {
                this.push(0.0f);
            } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
                this.push(0.0);
            } else if (type.getSort() == 9 || type.getSort() == 10) {
                this.loadNull();
            }
        }

        private void invokeMethod(String internalClassName, MethodNode method) {
            this.invokeMethod(internalClassName, method.name, method.desc);
        }

        private void invokeMethod(String internalClassName, String methodName, String methodDesc) {
            if (this.isStatic()) {
                this.loadArgs();
                this.visitMethodInsn(184, internalClassName, methodName, methodDesc);
            } else {
                this.loadThisOrNull();
                this.loadArgs();
                this.visitMethodInsn(183, internalClassName, methodName, methodDesc);
            }
        }

        public TryCatch tryStart(Type exceptionType) {
            return new TryCatch(this, exceptionType);
        }
    }

    private class InstrumentingClassWriter
    extends ClassWriter {
        public InstrumentingClassWriter(ClassNode classNode) {
            super(classNode.version >= 51 ? 2 : 1);
        }

        public int newNameType(String name, String desc) {
            return super.newNameType(name, desc.charAt(0) == ')' ? SandboxClassLoader.this.remapParams(desc) : SandboxClassLoader.this.remapParamType(desc));
        }

        public int newClass(String value) {
            value = SandboxClassLoader.this.remapType(value);
            return super.newClass(value);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            try {
                String result;
                block8: {
                    ClassReader info1 = this.typeInfo(type1);
                    ClassReader info2 = this.typeInfo(type2);
                    if ((info1.getAccess() & 0x200) != 0) {
                        if (this.typeImplements(type2, info2, type1)) {
                            return type1;
                        }
                        if ((info2.getAccess() & 0x200) != 0 && this.typeImplements(type1, info1, type2)) {
                            return type2;
                        }
                        return "java/lang/Object";
                    }
                    if ((info2.getAccess() & 0x200) != 0) {
                        if (this.typeImplements(type1, info1, type2)) {
                            return type2;
                        }
                        return "java/lang/Object";
                    }
                    StringBuilder b1 = this.typeAncestors(type1, info1);
                    StringBuilder b2 = this.typeAncestors(type2, info2);
                    result = "java/lang/Object";
                    int end1 = b1.length();
                    int end2 = b2.length();
                    while (true) {
                        String p2;
                        int start1 = b1.lastIndexOf(";", end1 - 1);
                        int start2 = b2.lastIndexOf(";", end2 - 1);
                        if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block8;
                        String p1 = b1.substring(start1 + 1, end1);
                        if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                        result = p1;
                        end1 = start1;
                        end2 = start2;
                    }
                    return result;
                }
                return result;
            }
            catch (IOException e) {
                return "java/lang/Object";
            }
        }

        private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
            StringBuilder b = new StringBuilder();
            while (!"java/lang/Object".equals(type)) {
                b.append(';').append(type);
                type = info.getSuperName();
                info = this.typeInfo(type);
            }
            return b;
        }

        private boolean typeImplements(String type, ClassReader info, String itf) throws IOException {
            while (!"java/lang/Object".equals(type)) {
                String[] itfs;
                for (String itf2 : itfs = info.getInterfaces()) {
                    if (!itf2.equals(itf)) continue;
                    return true;
                }
                for (String itf1 : itfs) {
                    if (!this.typeImplements(itf1, this.typeInfo(itf1), itf)) continue;
                    return true;
                }
                type = info.getSuperName();
                info = this.typeInfo(type);
            }
            return false;
        }

        private ClassReader typeInfo(String type) throws IOException {
            try (InputStream is = SandboxClassLoader.this.getClassBytesAsStreamPreferringLocalUrls(type + ".class");){
                ClassReader classReader = new ClassReader(is);
                return classReader;
            }
        }
    }

    abstract class ClassInstrumentor {
        private static final String ROBO_INIT_METHOD_NAME = "$$robo$init";
        static final String GET_ROBO_DATA_SIGNATURE = "()Ljava/lang/Object;";
        final Type OBJECT_TYPE = Type.getType(Object.class);
        private final String OBJECT_DESC = Type.getDescriptor(Object.class);
        final ClassNode classNode;
        private final boolean containsStubs;
        final String internalClassName;
        private final String className;
        final Type classType;

        public ClassInstrumentor(ClassNode classNode, boolean containsStubs) {
            this.classNode = classNode;
            this.containsStubs = containsStubs;
            this.internalClassName = classNode.name;
            this.className = classNode.name.replace('/', '.');
            this.classType = Type.getObjectType((String)this.internalClassName);
        }

        public void instrument() {
            this.makeClassPublic(this.classNode);
            this.classNode.access &= 0xFFFFFFEF;
            this.classNode.version = Math.max(this.classNode.version, 51);
            this.classNode.fields.add(0, new FieldNode(17, "__robo_data__", this.OBJECT_DESC, this.OBJECT_DESC, null));
            Set<String> foundMethods = this.instrumentMethods();
            this.addNoArgsConstructor(foundMethods);
            this.addDirectCallConstructor();
            this.instrumentInheritedObjectMethod(this.classNode, foundMethods, "equals", "(Ljava/lang/Object;)Z");
            this.instrumentInheritedObjectMethod(this.classNode, foundMethods, "hashCode", "()I");
            this.instrumentInheritedObjectMethod(this.classNode, foundMethods, "toString", "()Ljava/lang/String;");
            this.addRoboInitMethod();
            this.addRoboGetDataMethod();
            this.doSpecialHandling();
        }

        @NotNull
        private Set<String> instrumentMethods() {
            HashSet<String> foundMethods = new HashSet<String>();
            ArrayList methods = new ArrayList(this.classNode.methods);
            for (MethodNode method : methods) {
                foundMethods.add(method.name + method.desc);
                this.filterSpecialMethods(method);
                if (method.name.equals("<clinit>")) {
                    method.name = "__staticInitializer__";
                    this.classNode.methods.add(this.generateStaticInitializerNotifierMethod());
                    continue;
                }
                if (method.name.equals("<init>")) {
                    this.instrumentConstructor(method);
                    continue;
                }
                if (this.isSyntheticAccessorMethod(method) || Modifier.isAbstract(method.access)) continue;
                this.instrumentNormalMethod(method);
            }
            return foundMethods;
        }

        private void addNoArgsConstructor(Set<String> foundMethods) {
            if (!foundMethods.contains("<init>()V")) {
                MethodNode defaultConstructor = new MethodNode(1, "<init>", "()V", "()V", null);
                RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(defaultConstructor);
                generator.loadThis();
                generator.visitMethodInsn(183, this.classNode.superName, "<init>", "()V");
                generator.loadThis();
                generator.invokeVirtual(this.classType, new Method(ROBO_INIT_METHOD_NAME, "()V"));
                generator.returnValue();
                this.classNode.methods.add(defaultConstructor);
            }
        }

        protected abstract void addDirectCallConstructor();

        private void addRoboInitMethod() {
            MethodNode initMethodNode = new MethodNode(4, ROBO_INIT_METHOD_NAME, "()V", null, null);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(initMethodNode);
            Label alreadyInitialized = new Label();
            generator.loadThis();
            generator.getField(this.classType, "__robo_data__", this.OBJECT_TYPE);
            generator.ifNonNull(alreadyInitialized);
            generator.loadThis();
            generator.loadThis();
            this.writeCallToInitializing(generator);
            generator.putField(this.classType, "__robo_data__", this.OBJECT_TYPE);
            generator.mark(alreadyInitialized);
            generator.returnValue();
            this.classNode.methods.add(initMethodNode);
        }

        protected abstract void writeCallToInitializing(RobolectricGeneratorAdapter var1);

        private void addRoboGetDataMethod() {
            MethodNode initMethodNode = new MethodNode(1, "$$robo$getData", GET_ROBO_DATA_SIGNATURE, null, null);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(initMethodNode);
            generator.loadThis();
            generator.getField(this.classType, "__robo_data__", this.OBJECT_TYPE);
            generator.returnValue();
            generator.endMethod();
            this.classNode.methods.add(initMethodNode);
        }

        private void doSpecialHandling() {
            if (this.className.equals("android.os.Build$VERSION")) {
                for (Object field : this.classNode.fields) {
                    FieldNode fieldNode = (FieldNode)field;
                    fieldNode.access &= 0xFFFFFFEF;
                }
            }
        }

        private boolean isOverridingFinalMethod(ClassNode classNode, String methodName, String methodSignature) {
            while (true) {
                ArrayList methods = new ArrayList(classNode.methods);
                for (MethodNode method : methods) {
                    if (!method.name.equals(methodName) || !method.desc.equals(methodSignature) || (method.access & 0x10) == 0) continue;
                    return true;
                }
                if (classNode.superName == null) {
                    return false;
                }
                try {
                    byte[] byteCode = SandboxClassLoader.this.getByteCode(classNode.superName);
                    ClassReader classReader = new ClassReader(byteCode);
                    classNode = new ClassNode();
                    classReader.accept((ClassVisitor)classNode, 0);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private boolean isSyntheticAccessorMethod(MethodNode method) {
            return (method.access & 0x1000) != 0;
        }

        private void instrumentInheritedObjectMethod(ClassNode classNode, Set<String> foundMethods, String methodName, String methodDesc) {
            if (this.isOverridingFinalMethod(classNode, methodName, methodDesc)) {
                return;
            }
            if (!foundMethods.contains(methodName + methodDesc)) {
                MethodNode methodNode = new MethodNode(1, methodName, methodDesc, null, null);
                RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(methodNode);
                generator.invokeMethod("java/lang/Object", methodNode);
                generator.returnValue();
                generator.endMethod();
                this.classNode.methods.add(methodNode);
                this.instrumentNormalMethod(methodNode);
            }
        }

        private void instrumentConstructor(MethodNode method) {
            this.makeMethodPrivate(method);
            if (this.containsStubs) {
                method.instructions.clear();
                RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(method);
                generator.loadThis();
                generator.visitMethodInsn(183, this.classNode.superName, "<init>", "()V");
                generator.returnValue();
                generator.endMethod();
            }
            InsnList removedInstructions = this.extractCallToSuperConstructor(method);
            method.name = new ShadowImpl().directMethodName("__constructor__");
            this.classNode.methods.add(this.redirectorMethod(method, "__constructor__"));
            String[] exceptions = this.exceptionArray(method);
            MethodNode methodNode = new MethodNode(method.access, "<init>", method.desc, method.signature, exceptions);
            this.makeMethodPublic(methodNode);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(methodNode);
            methodNode.instructions = removedInstructions;
            generator.loadThis();
            generator.invokeVirtual(this.classType, new Method(ROBO_INIT_METHOD_NAME, "()V"));
            this.generateShadowCall(method, "__constructor__", generator);
            generator.endMethod();
            this.classNode.methods.add(methodNode);
        }

        private InsnList extractCallToSuperConstructor(MethodNode ctor) {
            InsnList removedInstructions = new InsnList();
            int startIndex = 0;
            AbstractInsnNode[] insns = ctor.instructions.toArray();
            block5: for (int i = 0; i < insns.length; ++i) {
                AbstractInsnNode node = insns[i];
                switch (node.getOpcode()) {
                    case 25: {
                        VarInsnNode vnode = (VarInsnNode)node;
                        if (vnode.var != 0) continue block5;
                        startIndex = i;
                        continue block5;
                    }
                    case 183: {
                        MethodInsnNode mnode = (MethodInsnNode)node;
                        if (!mnode.owner.equals(this.internalClassName) && !mnode.owner.equals(this.classNode.superName)) continue block5;
                        assert (mnode.name.equals("<init>"));
                        while (startIndex <= i) {
                            ctor.instructions.remove(insns[startIndex]);
                            removedInstructions.add(insns[startIndex]);
                            ++startIndex;
                        }
                        return removedInstructions;
                    }
                    case 191: {
                        ctor.visitCode();
                        ctor.visitInsn(177);
                        ctor.visitEnd();
                        return removedInstructions;
                    }
                }
            }
            throw new RuntimeException("huh? " + ctor.name + ctor.desc);
        }

        private void instrumentNormalMethod(MethodNode method) {
            if ((method.access & 0x400) == 0) {
                method.access |= 0x10;
            }
            if ((method.access & 0x100) != 0) {
                method.access &= 0xFFFFFEFF;
                RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(method);
                Type returnType = generator.getReturnType();
                generator.pushDefaultReturnValueToStack(returnType);
                generator.returnValue();
            }
            String originalName = method.name;
            method.name = new ShadowImpl().directMethodName(originalName);
            MethodNode delegatorMethodNode = new MethodNode(method.access, originalName, method.desc, method.signature, this.exceptionArray(method));
            delegatorMethodNode.visibleAnnotations = method.visibleAnnotations;
            delegatorMethodNode.access &= 0xFFFFFAEF;
            this.makeMethodPrivate(method);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(delegatorMethodNode);
            this.generateShadowCall(method, originalName, generator);
            generator.endMethod();
            this.classNode.methods.add(delegatorMethodNode);
        }

        private MethodNode redirectorMethod(MethodNode method, String newName) {
            MethodNode redirector = new MethodNode(262144, newName, method.desc, method.signature, this.exceptionArray(method));
            redirector.access = method.access & 0xFFFFFAEF;
            this.makeMethodPrivate(redirector);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(redirector);
            generator.invokeMethod(this.internalClassName, method);
            generator.returnValue();
            return redirector;
        }

        private String[] exceptionArray(MethodNode method) {
            return method.exceptions.toArray(new String[method.exceptions.size()]);
        }

        private void filterSpecialMethods(MethodNode callingMethod) {
            ListIterator instructions = callingMethod.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                switch (node.getOpcode()) {
                    case 187: {
                        TypeInsnNode newInsnNode = (TypeInsnNode)node;
                        newInsnNode.desc = SandboxClassLoader.this.remapType(newInsnNode.desc);
                        break;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: {
                        FieldInsnNode fieldInsnNode = (FieldInsnNode)node;
                        fieldInsnNode.desc = SandboxClassLoader.this.remapType(fieldInsnNode.desc);
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        MethodInsnNode targetMethod = (MethodInsnNode)node;
                        targetMethod.desc = SandboxClassLoader.this.remapParams(targetMethod.desc);
                        if (this.isGregorianCalendarBooleanConstructor(targetMethod)) {
                            this.replaceGregorianCalendarBooleanConstructor(instructions, targetMethod);
                            break;
                        }
                        if (!SandboxClassLoader.this.shouldIntercept(targetMethod)) break;
                        this.interceptInvokeVirtualMethod(instructions, targetMethod);
                        break;
                    }
                    case 186: {
                        break;
                    }
                }
            }
        }

        private boolean isGregorianCalendarBooleanConstructor(MethodInsnNode targetMethod) {
            return targetMethod.owner.equals("java/util/GregorianCalendar") && targetMethod.name.equals("<init>") && targetMethod.desc.equals("(Z)V");
        }

        private void replaceGregorianCalendarBooleanConstructor(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
            instructions.remove();
            instructions.add((AbstractInsnNode)new InsnNode(87));
            instructions.add((AbstractInsnNode)new InsnNode(3));
            instructions.add((AbstractInsnNode)new InsnNode(3));
            instructions.add((AbstractInsnNode)new InsnNode(3));
            instructions.add((AbstractInsnNode)new MethodInsnNode(183, targetMethod.owner, targetMethod.name, "(III)V", targetMethod.itf));
        }

        protected abstract void interceptInvokeVirtualMethod(ListIterator<AbstractInsnNode> var1, MethodInsnNode var2);

        private void makeClassPublic(ClassNode clazz) {
            clazz.access = (clazz.access | 1) & 0xFFFFFFF9;
        }

        private void makeMethodPublic(MethodNode method) {
            method.access = (method.access | 1) & 0xFFFFFFF9;
        }

        private void makeMethodPrivate(MethodNode method) {
            method.access = (method.access | 2) & 0xFFFFFFFA;
        }

        private MethodNode generateStaticInitializerNotifierMethod() {
            MethodNode methodNode = new MethodNode(8, "<clinit>", "()V", "()V", null);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(methodNode);
            generator.push(this.classType);
            generator.invokeStatic(Type.getType(RobolectricInternals.class), new Method("classInitializing", "(Ljava/lang/Class;)V"));
            generator.returnValue();
            generator.endMethod();
            return methodNode;
        }

        protected abstract void generateShadowCall(MethodNode var1, String var2, RobolectricGeneratorAdapter var3);

        int getTag(MethodNode m) {
            return Modifier.isStatic(m.access) ? 6 : 7;
        }
    }
}

