/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import org.robolectric.internal.bytecode.RoboCallSite;

public class MethodCallSite
extends RoboCallSite {
    private final String name;
    private final MethodHandle original;
    private final Kind kind;

    public MethodCallSite(MethodType type, Class<?> caller, String name, MethodHandle original, Kind kind) {
        super(type, caller);
        this.name = name;
        this.original = original;
        this.kind = kind;
    }

    public String getName() {
        return this.name;
    }

    public MethodHandle getOriginal() {
        return this.original;
    }

    public Class<?> thisType() {
        return this.isStatic() ? null : this.type().parameterType(0);
    }

    public boolean isStatic() {
        return this.kind == Kind.STATIC;
    }

    public String toString() {
        return "RoboCallSite{caller=" + this.getCaller() + ", original=" + this.original + ", kind=" + (Object)((Object)this.kind) + '}';
    }

    public static enum Kind {
        REGULAR,
        STATIC;

    }
}

