/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import org.robolectric.internal.bytecode.Interceptor;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.MethodCallSite;
import org.robolectric.internal.bytecode.RoboCallSite;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowWrangler;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.robolectric.util.ReflectionHelpers;

public class InvokeDynamicSupport {
    private static Interceptors INTERCEPTORS;
    private static final MethodHandle BIND_CALL_SITE;
    private static final MethodHandle BIND_INIT_CALL_SITE;
    private static final MethodHandle EXCEPTION_HANDLER;
    private static final MethodHandle GET_SHADOW;
    private static final MethodHandle NOTHING;

    public static CallSite bootstrapInit(MethodHandles.Lookup caller, String name, MethodType type) {
        RoboCallSite site = new RoboCallSite(type, caller.lookupClass());
        InvokeDynamicSupport.bindInitCallSite(site);
        return site;
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, MethodHandle original) throws IllegalAccessException {
        MethodCallSite site = new MethodCallSite(type, caller.lookupClass(), name, original, MethodCallSite.Kind.REGULAR);
        InvokeDynamicSupport.bindCallSite(site);
        return site;
    }

    public static CallSite bootstrapStatic(MethodHandles.Lookup caller, String name, MethodType type, MethodHandle original) throws IllegalAccessException {
        MethodCallSite site = new MethodCallSite(type, caller.lookupClass(), name, original, MethodCallSite.Kind.STATIC);
        InvokeDynamicSupport.bindCallSite(site);
        return site;
    }

    public static CallSite bootstrapIntrinsic(MethodHandles.Lookup caller, String name, MethodType type, String callee) throws IllegalAccessException {
        MethodHandle mh = InvokeDynamicSupport.getMethodHandle(callee, name, type);
        if (mh == null) {
            throw new IllegalArgumentException("Could not find intrinsic for " + callee + ":" + name);
        }
        return new ConstantCallSite(mh.asType(type));
    }

    private static MethodHandle getMethodHandle(String className, String methodName, MethodType type) {
        Interceptor interceptor = INTERCEPTORS.findInterceptor(className, methodName);
        if (interceptor != null) {
            try {
                Class<Interceptor> theClass = ReflectionHelpers.loadClass((ClassLoader)RobolectricInternals.getClassLoader(), (String)interceptor.getClass().getName()).asSubclass(Interceptor.class);
                return ((Interceptor)ReflectionHelpers.newInstance(theClass)).getMethodHandle(methodName, type);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        if (type.parameterCount() != 0) {
            return MethodHandles.dropArguments(NOTHING, 0, type.parameterArray());
        }
        return NOTHING;
    }

    private static MethodHandle bindInitCallSite(RoboCallSite site) {
        MethodHandle mh = RobolectricInternals.getShadowCreator(site.getCaller());
        return InvokeDynamicSupport.bindWithFallback(mh, site, BIND_INIT_CALL_SITE);
    }

    private static MethodHandle bindCallSite(MethodCallSite site) throws IllegalAccessException {
        MethodHandle mh = RobolectricInternals.findShadowMethod(site.getCaller(), site.getName(), site.type(), site.isStatic());
        if (mh == null) {
            mh = InvokeDynamicSupport.cleanStackTraces(site.getOriginal());
        } else if (mh == ShadowWrangler.DO_NOTHING) {
            mh = MethodHandles.dropArguments(mh, 0, site.type().parameterList());
        } else if (!site.isStatic()) {
            TypeDescriptor.OfField shadowType = mh.type().parameterType(0);
            mh = MethodHandles.filterArguments(mh, 0, GET_SHADOW.asType(MethodType.methodType(shadowType, site.thisType())));
        }
        try {
            return InvokeDynamicSupport.bindWithFallback(mh, site, BIND_CALL_SITE);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println(site.getCaller());
            throw t;
        }
    }

    private static MethodHandle bindWithFallback(MethodHandle mh, RoboCallSite site, MethodHandle fallback) {
        SwitchPoint switchPoint = InvokeDynamicSupport.getInvalidator(site.getCaller());
        MethodType type = site.type();
        MethodHandle boundFallback = MethodHandles.foldArguments(MethodHandles.exactInvoker(type), fallback.bindTo(site));
        mh = switchPoint.guardWithTest(mh.asType(type), boundFallback);
        site.setTarget(mh);
        return mh;
    }

    private static SwitchPoint getInvalidator(Class<?> cl) {
        return RobolectricInternals.getShadowInvalidator().getSwitchPoint(cl);
    }

    private static MethodHandle cleanStackTraces(MethodHandle mh) {
        MethodType type = EXCEPTION_HANDLER.type().changeReturnType((Class<?>)mh.type().returnType());
        return MethodHandles.catchException(mh, Throwable.class, EXCEPTION_HANDLER.asType(type));
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            BIND_CALL_SITE = lookup.findStatic(InvokeDynamicSupport.class, "bindCallSite", MethodType.methodType(MethodHandle.class, MethodCallSite.class));
            BIND_INIT_CALL_SITE = lookup.findStatic(InvokeDynamicSupport.class, "bindInitCallSite", MethodType.methodType(MethodHandle.class, RoboCallSite.class));
            MethodHandle cleanStackTrace = lookup.findStatic(RobolectricInternals.class, "cleanStackTrace", MethodType.methodType(Throwable.class, Throwable.class));
            EXCEPTION_HANDLER = MethodHandles.filterArguments(MethodHandles.throwException(Void.TYPE, Throwable.class), 0, cleanStackTrace);
            GET_SHADOW = lookup.findVirtual(ShadowedObject.class, "$$robo$getData", MethodType.methodType(Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        NOTHING = MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE));
    }
}

