/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.Arrays;
import org.robolectric.internal.bytecode.MethodSignature;
import org.robolectric.internal.bytecode.ShadowWrangler;

public class InvocationProfile {
    public final Class clazz;
    public final String methodName;
    public final boolean isStatic;
    public final String[] paramTypes;
    private final boolean isDeclaredOnObject;

    public InvocationProfile(String methodSignatureString, boolean isStatic, ClassLoader classLoader) {
        MethodSignature methodSignature = MethodSignature.parse(methodSignatureString);
        this.clazz = this.loadClass(classLoader, methodSignature.className);
        this.methodName = methodSignature.methodName;
        this.paramTypes = methodSignature.paramTypes;
        this.isStatic = isStatic;
        this.isDeclaredOnObject = methodSignatureString.endsWith("/equals(Ljava/lang/Object;)Z") || methodSignatureString.endsWith("/hashCode()I") || methodSignatureString.endsWith("/toString()Ljava/lang/String;");
    }

    public Class<?>[] getParamClasses(ClassLoader classLoader) throws ClassNotFoundException {
        Class[] classes = new Class[this.paramTypes.length];
        for (int i = 0; i < this.paramTypes.length; ++i) {
            String paramType = this.paramTypes[i];
            classes[i] = ShadowWrangler.loadClass(paramType, classLoader);
        }
        return classes;
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationProfile that = (InvocationProfile)o;
        if (this.isDeclaredOnObject != that.isDeclaredOnObject) {
            return false;
        }
        if (this.isStatic != that.isStatic) {
            return false;
        }
        if (this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return Arrays.equals(this.paramTypes, that.paramTypes);
    }

    public int hashCode() {
        int result = this.clazz != null ? this.clazz.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.isStatic ? 1 : 0);
        result = 31 * result + (this.paramTypes != null ? Arrays.hashCode(this.paramTypes) : 0);
        result = 31 * result + (this.isDeclaredOnObject ? 1 : 0);
        return result;
    }

    public boolean isDeclaredOnObject() {
        return this.isDeclaredOnObject;
    }
}

