/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.annotation.Annotation;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ClassInfo {
    private final String className;
    private final ClassNode classNode;

    public ClassInfo(String className, ClassNode classNode) {
        this.className = className;
        this.classNode = classNode;
    }

    public boolean isInterface() {
        return (this.classNode.access & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classNode.access & 0x2000) != 0;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        String internalName = "L" + annotationClass.getName().replace('.', '/') + ";";
        if (this.classNode.visibleAnnotations == null) {
            return false;
        }
        for (Object visibleAnnotation : this.classNode.visibleAnnotations) {
            AnnotationNode annotationNode = (AnnotationNode)visibleAnnotation;
            if (!annotationNode.desc.equals(internalName)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.className;
    }
}

