/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.ResType;
import org.robolectric.res.XmlLoader;

public class TypedResource<T> {
    private final T data;
    private final ResType resType;
    private final String qualifiers;
    private final XmlLoader.XmlContext xmlContext;

    public TypedResource(T data, ResType resType, XmlLoader.XmlContext xmlContext) {
        this.data = data;
        this.resType = resType;
        this.xmlContext = xmlContext;
        String qualifiers = xmlContext.getQualifiers();
        this.qualifiers = qualifiers == null ? "--" : "-" + qualifiers + "-";
    }

    public T getData() {
        return this.data;
    }

    public ResType getResType() {
        return this.resType;
    }

    public String getQualifiers() {
        return this.qualifiers;
    }

    public XmlLoader.XmlContext getXmlContext() {
        return this.xmlContext;
    }

    public String asString() {
        return (String)this.getData();
    }

    public boolean isFile() {
        return false;
    }

    public boolean isReference() {
        T data = this.getData();
        if (data instanceof String) {
            String s = (String)data;
            return !s.isEmpty() && s.charAt(0) == '@';
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{data=" + this.data + ", resType=" + (Object)((Object)this.resType) + ", xmlContext=" + this.xmlContext + '}';
    }
}

