/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation;

import android.app.Application;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.robolectric.annotation.DefaultApplication;

@Documented
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface Config {
    public static final String NONE = "--none";
    public static final String DEFAULT_VALUE_STRING = "--default";
    public static final int DEFAULT_VALUE_INT = -1;
    public static final String DEFAULT_MANIFEST_NAME = "AndroidManifest.xml";
    public static final Class<? extends Application> DEFAULT_APPLICATION = DefaultApplication.class;
    public static final String DEFAULT_PACKAGE_NAME = "";
    public static final String DEFAULT_ABI_SPLIT = "";
    public static final String DEFAULT_QUALIFIERS = "";
    public static final String DEFAULT_RES_FOLDER = "res";
    public static final String DEFAULT_ASSET_FOLDER = "assets";
    public static final String DEFAULT_BUILD_FOLDER = "build";
    public static final int ALL_SDKS = -2;
    public static final int TARGET_SDK = -3;
    public static final int OLDEST_SDK = -4;
    public static final int NEWEST_SDK = -5;

    public int[] sdk() default {};

    public int minSdk() default -1;

    public int maxSdk() default -1;

    public String manifest() default "--default";

    public Class<?> constants() default Void.class;

    public Class<? extends Application> application() default DefaultApplication.class;

    public String packageName() default "";

    public String abiSplit() default "";

    public String qualifiers() default "";

    public String resourceDir() default "res";

    public String assetDir() default "assets";

    public String buildDir() default "build";

    public Class<?>[] shadows() default {};

    public String[] instrumentedPackages() default {};

    public String[] libraries() default {};

    public static class Builder {
        private int[] sdk = new int[0];
        private int minSdk = -1;
        private int maxSdk = -1;
        private String manifest = "--default";
        private String qualifiers = "";
        private String packageName = "";
        private String abiSplit = "";
        private String resourceDir = "res";
        private String assetDir = "assets";
        private String buildDir = "build";
        private Class<?>[] shadows = new Class[0];
        private String[] instrumentedPackages = new String[0];
        private Class<? extends Application> application = DEFAULT_APPLICATION;
        private String[] libraries = new String[0];
        private Class<?> constants = Void.class;

        public Builder() {
        }

        public Builder(Config config) {
            this.sdk = config.sdk();
            this.minSdk = config.minSdk();
            this.maxSdk = config.maxSdk();
            this.manifest = config.manifest();
            this.qualifiers = config.qualifiers();
            this.packageName = config.packageName();
            this.abiSplit = config.abiSplit();
            this.resourceDir = config.resourceDir();
            this.assetDir = config.assetDir();
            this.buildDir = config.buildDir();
            this.shadows = config.shadows();
            this.instrumentedPackages = config.instrumentedPackages();
            this.application = config.application();
            this.libraries = config.libraries();
            this.constants = config.constants();
        }

        public Builder setSdk(int ... sdk) {
            this.sdk = sdk;
            return this;
        }

        public Builder setMinSdk(int minSdk) {
            this.minSdk = minSdk;
            return this;
        }

        public Builder setMaxSdk(int maxSdk) {
            this.maxSdk = maxSdk;
            return this;
        }

        public Builder setManifest(String manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder setQualifiers(String qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setAbiSplit(String abiSplit) {
            this.abiSplit = abiSplit;
            return this;
        }

        public Builder setResourceDir(String resourceDir) {
            this.resourceDir = resourceDir;
            return this;
        }

        public Builder setAssetDir(String assetDir) {
            this.assetDir = assetDir;
            return this;
        }

        public Builder setBuildDir(String buildDir) {
            this.buildDir = buildDir;
            return this;
        }

        public Builder setShadows(Class<?>[] shadows) {
            this.shadows = shadows;
            return this;
        }

        public Builder setInstrumentedPackages(String[] instrumentedPackages) {
            this.instrumentedPackages = instrumentedPackages;
            return this;
        }

        public Builder setApplication(Class<? extends Application> application) {
            this.application = application;
            return this;
        }

        public Builder setLibraries(String[] libraries) {
            this.libraries = libraries;
            return this;
        }

        public Builder setConstants(Class<?> constants) {
            this.constants = constants;
            return this;
        }

        public static Builder defaults() {
            return new Builder().setManifest(Config.DEFAULT_MANIFEST_NAME).setResourceDir(Config.DEFAULT_RES_FOLDER).setAssetDir(Config.DEFAULT_ASSET_FOLDER);
        }

        public Builder overlay(Config overlayConfig) {
            int[] overlaySdk = overlayConfig.sdk();
            int overlayMinSdk = overlayConfig.minSdk();
            int overlayMaxSdk = overlayConfig.maxSdk();
            if (overlaySdk != null && overlaySdk.length > 0) {
                this.sdk = overlaySdk;
                this.minSdk = overlayMinSdk;
                this.maxSdk = overlayMaxSdk;
            } else {
                this.sdk = overlayMinSdk != -1 || overlayMaxSdk != -1 ? new int[0] : this.pickSdk(this.sdk, overlaySdk, new int[0]);
                this.minSdk = this.pick(this.minSdk, overlayMinSdk, -1);
                this.maxSdk = this.pick(this.maxSdk, overlayMaxSdk, -1);
            }
            this.manifest = this.pick(this.manifest, overlayConfig.manifest(), Config.DEFAULT_VALUE_STRING);
            this.qualifiers = this.pick(this.qualifiers, overlayConfig.qualifiers(), "");
            this.packageName = this.pick(this.packageName, overlayConfig.packageName(), "");
            this.abiSplit = this.pick(this.abiSplit, overlayConfig.abiSplit(), "");
            this.resourceDir = this.pick(this.resourceDir, overlayConfig.resourceDir(), Config.DEFAULT_RES_FOLDER);
            this.assetDir = this.pick(this.assetDir, overlayConfig.assetDir(), Config.DEFAULT_ASSET_FOLDER);
            this.buildDir = this.pick(this.buildDir, overlayConfig.buildDir(), Config.DEFAULT_BUILD_FOLDER);
            this.constants = this.pick(this.constants, overlayConfig.constants(), Void.class);
            HashSet shadows = new HashSet();
            shadows.addAll(Arrays.asList(this.shadows));
            shadows.addAll(Arrays.asList(overlayConfig.shadows()));
            this.shadows = shadows.toArray(new Class[shadows.size()]);
            HashSet<String> instrumentedPackages = new HashSet<String>();
            instrumentedPackages.addAll(Arrays.asList(this.instrumentedPackages));
            instrumentedPackages.addAll(Arrays.asList(overlayConfig.instrumentedPackages()));
            this.instrumentedPackages = instrumentedPackages.toArray(new String[instrumentedPackages.size()]);
            this.application = this.pick(this.application, overlayConfig.application(), DEFAULT_APPLICATION);
            HashSet<String> libraries = new HashSet<String>();
            libraries.addAll(Arrays.asList(this.libraries));
            libraries.addAll(Arrays.asList(overlayConfig.libraries()));
            this.libraries = libraries.toArray(new String[libraries.size()]);
            return this;
        }

        private <T> T pick(T baseValue, T overlayValue, T nullValue) {
            return overlayValue != null ? (overlayValue.equals(nullValue) ? (T)baseValue : (T)overlayValue) : null;
        }

        private int[] pickSdk(int[] baseValue, int[] overlayValue, int[] nullValue) {
            return Arrays.equals(overlayValue, nullValue) ? baseValue : overlayValue;
        }

        public Implementation build() {
            return new Implementation(this.sdk, this.minSdk, this.maxSdk, this.manifest, this.qualifiers, this.packageName, this.abiSplit, this.resourceDir, this.assetDir, this.buildDir, this.shadows, this.instrumentedPackages, this.application, this.libraries, this.constants);
        }

        public static boolean isDefaultApplication(Class<? extends Application> clazz) {
            return clazz == null || clazz.getCanonicalName().equals(DEFAULT_APPLICATION.getCanonicalName());
        }
    }

    public static class Implementation
    implements Config {
        private final int[] sdk;
        private final int minSdk;
        private final int maxSdk;
        private final String manifest;
        private final String qualifiers;
        private final String resourceDir;
        private final String assetDir;
        private final String buildDir;
        private final String packageName;
        private final String abiSplit;
        private final Class<?> constants;
        private final Class<?>[] shadows;
        private final String[] instrumentedPackages;
        private final Class<? extends Application> application;
        private final String[] libraries;

        public static Config fromProperties(Properties properties) {
            if (properties == null || properties.size() == 0) {
                return null;
            }
            return new Implementation(Implementation.parseSdkArrayProperty(properties.getProperty("sdk", "")), Implementation.parseSdkInt(properties.getProperty("minSdk", "-1")), Implementation.parseSdkInt(properties.getProperty("maxSdk", "-1")), properties.getProperty("manifest", Config.DEFAULT_VALUE_STRING), properties.getProperty("qualifiers", ""), properties.getProperty("packageName", ""), properties.getProperty("abiSplit", ""), properties.getProperty("resourceDir", Config.DEFAULT_RES_FOLDER), properties.getProperty("assetDir", Config.DEFAULT_ASSET_FOLDER), properties.getProperty("buildDir", Config.DEFAULT_BUILD_FOLDER), Implementation.parseClasses(properties.getProperty("shadows", "")), Implementation.parseStringArrayProperty(properties.getProperty("instrumentedPackages", "")), Implementation.parseApplication(properties.getProperty("application", DEFAULT_APPLICATION.getCanonicalName())), Implementation.parseStringArrayProperty(properties.getProperty("libraries", "")), Implementation.parseClass(properties.getProperty("constants", "")));
        }

        private static Class<?> parseClass(String className) {
            if (className.isEmpty()) {
                return null;
            }
            try {
                return Implementation.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load class: " + className);
            }
        }

        private static Class<?>[] parseClasses(String input) {
            if (input.isEmpty()) {
                return new Class[0];
            }
            String[] classNames = input.split("[, ]+");
            Class[] classes = new Class[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                classes[i] = Implementation.parseClass(classNames[i]);
            }
            return classes;
        }

        private static <T extends Application> Class<T> parseApplication(String className) {
            return Implementation.parseClass(className);
        }

        private static String[] parseStringArrayProperty(String property) {
            if (property.isEmpty()) {
                return new String[0];
            }
            return property.split("[, ]+");
        }

        private static int[] parseSdkArrayProperty(String property) {
            String[] parts = Implementation.parseStringArrayProperty(property);
            int[] result = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Implementation.parseSdkInt(parts[i]);
            }
            return result;
        }

        private static int parseSdkInt(String part) {
            String spec;
            switch (spec = part.trim()) {
                case "ALL_SDKS": {
                    return -2;
                }
                case "TARGET_SDK": {
                    return -3;
                }
                case "OLDEST_SDK": {
                    return -4;
                }
                case "NEWEST_SDK": {
                    return -5;
                }
            }
            return Integer.parseInt(spec);
        }

        private static void validate(Config config) {
            if (config.sdk() != null && config.sdk().length > 0 && (config.minSdk() != -1 || config.maxSdk() != -1)) {
                throw new IllegalArgumentException("sdk and minSdk/maxSdk may not be specified together (sdk=" + Arrays.toString(config.sdk()) + ", minSdk=" + config.minSdk() + ", maxSdk=" + config.maxSdk() + ")");
            }
            if (config.minSdk() > -1 && config.maxSdk() > -1 && config.minSdk() > config.maxSdk()) {
                throw new IllegalArgumentException("minSdk may not be larger than maxSdk (minSdk=" + config.minSdk() + ", maxSdk=" + config.maxSdk() + ")");
            }
        }

        public Implementation(int[] sdk, int minSdk, int maxSdk, String manifest, String qualifiers, String packageName, String abiSplit, String resourceDir, String assetDir, String buildDir, Class<?>[] shadows, String[] instrumentedPackages, Class<? extends Application> application, String[] libraries, Class<?> constants) {
            this.sdk = sdk;
            this.minSdk = minSdk;
            this.maxSdk = maxSdk;
            this.manifest = manifest;
            this.qualifiers = qualifiers;
            this.packageName = packageName;
            this.abiSplit = abiSplit;
            this.resourceDir = resourceDir;
            this.assetDir = assetDir;
            this.buildDir = buildDir;
            this.shadows = shadows;
            this.instrumentedPackages = instrumentedPackages;
            this.application = application;
            this.libraries = libraries;
            this.constants = constants;
            Implementation.validate(this);
        }

        @Override
        public int[] sdk() {
            return this.sdk;
        }

        @Override
        public int minSdk() {
            return this.minSdk;
        }

        @Override
        public int maxSdk() {
            return this.maxSdk;
        }

        @Override
        public String manifest() {
            return this.manifest;
        }

        @Override
        public Class<?> constants() {
            return this.constants;
        }

        @Override
        public Class<? extends Application> application() {
            return this.application;
        }

        @Override
        public String qualifiers() {
            return this.qualifiers;
        }

        @Override
        public String packageName() {
            return this.packageName;
        }

        @Override
        public String abiSplit() {
            return this.abiSplit;
        }

        @Override
        public String resourceDir() {
            return this.resourceDir;
        }

        @Override
        public String assetDir() {
            return this.assetDir;
        }

        @Override
        public String buildDir() {
            return this.buildDir;
        }

        @Override
        public Class<?>[] shadows() {
            return this.shadows;
        }

        @Override
        public String[] instrumentedPackages() {
            return this.instrumentedPackages;
        }

        @Override
        public String[] libraries() {
            return this.libraries;
        }

        @Override
        @NotNull
        public Class<? extends Annotation> annotationType() {
            return Config.class;
        }
    }
}

