/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert.seamtext;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.richfaces.convert.seamtext.tags.HtmlTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlToSeamTransformer {
    public boolean preformatted = false;
    private static final Collection<String> SIMPLE_HTML_SEAM_TEXT_ELEMENTS = new HashSet<String>(Arrays.asList("del", "sup", "pre", "q", "i", "tt", "u"));
    private static final Collection<String> FORMATTED_HTML_SEAM_TEXT_ELEMENTS = new HashSet<String>(Arrays.asList("h1", "h2", "h3", "h4", "p", "ul", "ol", "li", "a", "blockqoute"));
    private static final Collection<String> HTML_SEAM_TEXT_ELEMENTS = new HashSet<String>(SIMPLE_HTML_SEAM_TEXT_ELEMENTS.size() + FORMATTED_HTML_SEAM_TEXT_ELEMENTS.size());
    private Stack<HtmlTag> htmlElementStack = new Stack();
    private StringBuilder newLinesCollector;
    private HtmlTag currentTag = null;
    private boolean isHeaderProcessed = false;
    private boolean isFirstChars = false;

    public Stack<HtmlTag> getHtmlElementStack() {
        return this.htmlElementStack;
    }

    public void setHtmlElementStack(Stack<HtmlTag> htmlElementStack) {
        this.htmlElementStack = htmlElementStack;
    }

    private void appendStart(HtmlTag tag) {
        this.currentTag.appendBody(tag);
        this.currentTag = tag;
    }

    private void appendBody(String ... strings) {
        for (String str : strings) {
            if (str == null || "".equals(str)) continue;
            this.currentTag.appendBody(str);
        }
    }

    private void appendEnd() {
        this.currentTag = this.htmlElementStack.peek();
    }

    public String escapeSeamText(String tokenName, boolean preformatted) {
        StringBuilder result = new StringBuilder(tokenName.length() + 1);
        if (!preformatted) {
            result.append('\\');
        }
        result.append(tokenName);
        return result.toString();
    }

    public boolean isSeamTextElement(HtmlTag element) {
        return HTML_SEAM_TEXT_ELEMENTS.contains(element.getName().toLowerCase());
    }

    public boolean isSimpleSeamTextElement(HtmlTag element) {
        return SIMPLE_HTML_SEAM_TEXT_ELEMENTS.contains(element.getName().toLowerCase());
    }

    public boolean isFormattedHtmlSeamTextElement(HtmlTag element) {
        return FORMATTED_HTML_SEAM_TEXT_ELEMENTS.contains(element.getName().toLowerCase());
    }

    public boolean isPlainHtmlRequired(HtmlTag name) {
        if (!this.isSeamTextElement(name)) {
            return true;
        }
        if (this.isSimpleSeamTextElement(name)) {
            return false;
        }
        if (!name.isLink() && !name.isParagraph()) {
            for (HtmlTag token : this.htmlElementStack) {
                if (!token.isHeader() && !token.isListItem()) continue;
                return true;
            }
        }
        return false;
    }

    public void text(char[] text, int start, int length) {
        if (this.isFirstChars) {
            while (text[start] == '\n' && length > 0) {
                ++start;
                --length;
            }
            this.isFirstChars = false;
        }
        while (length > 0) {
            this.processChar(text, start, 1);
            this.setHeaderProcessed();
            ++start;
            --length;
        }
    }

    private void setHeaderProcessed() {
        HtmlTag token = this.htmlElementStack.peek();
        if (!token.isParagraph() && this.isHeaderProcessed) {
            this.isHeaderProcessed = false;
        }
    }

    private void processChar(char[] text, int start, int localLength) {
        switch (text[start]) {
            case '#': 
            case '&': 
            case '*': 
            case '+': 
            case '<': 
            case '=': 
            case '>': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                this.seamCharacters(text, start, localLength);
                break;
            }
            case '\n': {
                HtmlTag token = this.htmlElementStack.peek();
                if (this.isHeaderProcessed || "root".equals(token.getName()) || token.isList()) break;
                this.out(text, start, localLength);
                break;
            }
            default: {
                this.out(text, start, localLength);
            }
        }
    }

    public void seamCharacters(char[] text, int start, int length) {
        this.appendBody(this.escapeSeamText(new String(text, start, length), this.preformatted));
    }

    public void plain(char[] text, int start, int length) {
        this.out(text, start, length);
        this.setHeaderProcessed();
    }

    public void out(char[] text, int start, int length) {
        this.appendBody(new String(text, start, length));
    }

    public void space(char[] text, int start, int length) {
        HtmlTag token;
        if (!this.htmlElementStack.isEmpty() && this.isPlainHtmlRequired(token = this.htmlElementStack.peek())) {
            this.out(text, start, length);
        }
    }

    public void newline(char[] text, int start, int length) {
        if (this.preformatted && this.newLinesCollector != null) {
            this.newLinesCollector.append(new String(text, start, length));
        }
    }

    public void openTag(HtmlTag tag) {
        if (tag.isPreFormattedElement()) {
            this.preformatted = true;
        }
        if (this.isPlainHtmlRequired(tag)) {
            this.outValueCollector();
            this.appendStart(tag);
        } else {
            if (!this.isFormattedHtmlSeamTextElement(tag)) {
                this.outValueCollector();
            }
            this.appendStart(tag);
        }
        this.isFirstChars = true;
    }

    private void outValueCollector() {
        if (this.newLinesCollector != null) {
            this.appendBody(this.newLinesCollector.toString());
            this.newLinesCollector = null;
        }
    }

    public void closeTagWithBody(HtmlTag tag) {
        if (!tag.getName().equals(tag.getName())) {
            throw new IllegalStateException("Can not convert to the Seam Text:  </" + tag.getName() + "> expected");
        }
        String value = "";
        if (this.newLinesCollector != null) {
            value = this.newLinesCollector.toString();
        }
        if (tag.isLink()) {
            value = "";
        } else if (tag.isParagraph()) {
            this.isHeaderProcessed = false;
        } else if (tag.isHeader()) {
            this.isHeaderProcessed = true;
        }
        this.appendBody(value);
        this.appendEnd();
        this.newLinesCollector = null;
        if (tag.isPreFormattedElement()) {
            this.preformatted = false;
        }
    }

    public HtmlTag getCurrentTag() {
        return this.currentTag;
    }

    public void setCurrentTag(HtmlTag currentTag) {
        this.currentTag = currentTag;
    }

    static {
        HTML_SEAM_TEXT_ELEMENTS.addAll(SIMPLE_HTML_SEAM_TEXT_ELEMENTS);
        HTML_SEAM_TEXT_ELEMENTS.addAll(FORMATTED_HTML_SEAM_TEXT_ELEMENTS);
    }
}

