package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.renderkit.html.MenuGroupRendererBase;


@ResourceDependencies({@ResourceDependency(name="base-component.reslib",library="org.richfaces",target=""),@ResourceDependency(name="menu-base.js",library="org.richfaces",target=""),@ResourceDependency(name="menugroup.js",library="org.richfaces",target="")})
public class MenuGroupRenderer extends MenuGroupRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES30 = attributes()
	     .generic("align","align")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("title","title")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
Object style  =  component.getAttributes().get("style"); 
Object cssRoot  =  component.getAttributes().get("cssRoot"); 
Object iconClass  =  component.getAttributes().get("iconClass"); 
Object labelClass  =  component.getAttributes().get("labelClass"); 
String styleClass  =  this.getStyleClass(facesContext,component,"groupClass","styleClass"); 
String selectedClass  =  this.getStyleClass(facesContext,component,"selectedGroupClass","selectedClass"); 
String disabledClass  =  this.getStyleClass(facesContext,component,"disabledGroupClass","disabledClass"); 
boolean isDisabled  =  this.isDisabled(facesContext,component); 
UIComponent iconFacet  =  this.getIconFacet(facesContext,component); 
String iconAttribute  =  this.getIconAttribute(facesContext,component); 
responseWriter.startElement("div", component); 
   {
      String value = "rf-" + convertToString(cssRoot) + "-itm " + convertToString((convertToBoolean(isDisabled) ? ((("rf-" + cssRoot) + "-itm-dis ") + disabledClass) : ((("rf-" + cssRoot) + "-itm-unsel ") + styleClass)));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = style;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES30);

responseWriter.startElement("span", component); 
   {
      String value = "rf-" + convertToString(cssRoot) + "-itm-ic " + convertToString(iconClass);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	if (convertToBoolean("iconFacet != null and iconFacet.isRendered()")) {
	iconFacet.encodeAll(facesContext);
	} else if ((!convertToBoolean(this.isStringEmpty(iconAttribute))))  { 
	responseWriter.startElement("img", component); 
	  responseWriter.writeAttribute("alt","",null);

  responseWriter.writeAttribute("height","16",null);

   {
      Object value = RenderKitUtils.getResourceURL(iconAttribute,facesContext);
      if(null != value && value.toString().length()>0) {
        responseWriter.writeURIAttribute("src",value,null);
      }
   }

  responseWriter.writeAttribute("width","16",null);


	responseWriter.endElement("img"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      String value = "rf-" + convertToString(cssRoot) + "-emptyIcon";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	responseWriter.endElement("span"); 
}
responseWriter.endElement("span"); 
	if ((!convertToBoolean(isDisabled))) {
	responseWriter.startElement("span", component); 
	   {
      String value = "rf-" + convertToString(cssRoot) + "-itm-lbl " + convertToString(labelClass);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	{
	Object text = component.getAttributes().get("label");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("span"); 
	} else  { 
	{
	Object text = component.getAttributes().get("label");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
responseWriter.startElement("div", component); 
   {
      String value = "rf-" + convertToString(cssRoot) + "-nd";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	if ((!convertToBoolean(isDisabled))) {
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-" + convertToString(cssRoot) + "-lst rf-" + convertToString(cssRoot) + "-sublst";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_list";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = "display:none;min-width:" + convertToString(this.getMinPopupWidth(facesContext,component)) + "px;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	   {
      String value = "rf-" + convertToString(cssRoot) + "-lst-bg";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	renderChildren(facesContext, component);
	responseWriter.endElement("div"); 
	responseWriter.endElement("div"); 
}
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

