/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.event.ActionListener;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.ajax4jsf.Messages;
import org.richfaces.component.AbstractParameter;

public class ParameterHandler
extends ComponentHandler {
    private static final ActionParamMetaRule ACTION_PARAM_META_RULE = new ActionParamMetaRule();
    private TagAttribute assignTo = this.getAttribute("assignTo");

    public ParameterHandler(ComponentConfig config) {
        super(config);
        if (null != this.assignTo && this.assignTo.isLiteral()) {
            throw new TagAttributeException(this.tag, this.assignTo, Messages.getMessage((String)"MUST_BE_EXPRESSION_ERROR"));
        }
    }

    public void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        if (parent instanceof ActionSource && this.assignTo != null) {
            AbstractParameter al = (AbstractParameter)c;
            ((ActionSource)parent).addActionListener((ActionListener)al);
        }
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset metaRules = super.createMetaRuleset(type);
        metaRules.addRule((MetaRule)ACTION_PARAM_META_RULE);
        return metaRules;
    }

    static final class AssignToValueExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public AssignToValueExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((AbstractParameter)((Object)instance)).setAssignToExpression(this.attr.getValueExpression(ctx, Object.class));
        }
    }

    static final class DynamicConverterMetadata
    extends Metadata {
        private final TagAttribute attr;

        public DynamicConverterMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((AbstractParameter)((Object)instance)).setConverter((Converter)this.attr.getObject(ctx, Converter.class));
        }
    }

    static final class LiteralConverterMetadata
    extends Metadata {
        private final String converterId;

        public LiteralConverterMetadata(String converterId) {
            this.converterId = converterId;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((AbstractParameter)((Object)instance)).setConverter(ctx.getFacesContext().getApplication().createConverter(this.converterId));
        }
    }

    public static class ActionParamMetaRule
    extends MetaRule {
        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AbstractParameter.class)) {
                if ("assignTo".equals(name)) {
                    return new AssignToValueExpressionMetadata(attribute);
                }
                if ("converter".equals(name)) {
                    if (attribute.isLiteral()) {
                        return new LiteralConverterMetadata(attribute.getValue());
                    }
                    return new DynamicConverterMetadata(attribute);
                }
            }
            return null;
        }
    }
}

