/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.CompatibilityType;
import org.revapi.Criticality;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.TreeFilter;
import org.revapi.basic.AbstractDifferenceReferringTransform;
import org.revapi.basic.DifferenceMatchRecipe;
import org.revapi.basic.MatchingProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferencesTransform<E extends Element<E>>
extends AbstractDifferenceReferringTransform<E> {
    private static final Logger LOG = LoggerFactory.getLogger(DifferencesTransform.class);
    private JsonNode bulkClassify;
    private JsonNode bulkIgnore;
    private JsonNode bulkJustification;
    private JsonNode bulkAttachments;
    private JsonNode bulkCriticality;
    private JsonNode bulkMatcher;

    public DifferencesTransform() {
        super("revapi.differences");
    }

    protected DifferencesTransform(String extensionId) {
        super(extensionId);
    }

    private static Map<CompatibilityType, DifferenceSeverity> parseClassification(JsonNode config) {
        EnumMap<CompatibilityType, DifferenceSeverity> classification = new EnumMap<CompatibilityType, DifferenceSeverity>(CompatibilityType.class);
        for (CompatibilityType ct : CompatibilityType.values()) {
            if (!config.has(ct.name())) continue;
            String val = config.path(ct.name()).asText();
            DifferenceSeverity sev = DifferenceSeverity.valueOf((String)val);
            classification.put(ct, sev);
        }
        return classification;
    }

    @Override
    @Nonnull
    protected DifferenceMatchRecipe newRecipe(JsonNode node) throws IllegalArgumentException {
        ObjectNode configNode = (ObjectNode)node.deepCopy();
        if (!configNode.hasNonNull("ignore") && !this.bulkIgnore.isMissingNode()) {
            configNode.put("ignore", this.bulkIgnore.asBoolean());
        }
        if (!configNode.hasNonNull("justification") && !this.bulkJustification.isMissingNode()) {
            configNode.put("justification", this.bulkJustification.asText());
        }
        if (configNode.hasNonNull("classify")) {
            ObjectNode classify = (ObjectNode)configNode.path("classify");
            if (!classify.hasNonNull("SOURCE") && this.bulkClassify.hasNonNull("SOURCE")) {
                classify.put("SOURCE", this.bulkClassify.get("SOURCE").asText());
            }
            if (!classify.hasNonNull("BINARY") && this.bulkClassify.hasNonNull("BINARY")) {
                classify.put("BINARY", this.bulkClassify.get("BINARY").asText());
            }
            if (!classify.hasNonNull("SEMANTIC") && this.bulkClassify.hasNonNull("SEMANTIC")) {
                classify.put("SEMANTIC", this.bulkClassify.get("SEMANTIC").asText());
            }
            if (!classify.hasNonNull("OTHER") && this.bulkClassify.hasNonNull("OTHER")) {
                classify.put("OTHER", this.bulkClassify.get("OTHER").asText());
            }
        } else if (!this.bulkClassify.isMissingNode()) {
            configNode.set("classify", this.bulkClassify);
        }
        if (configNode.hasNonNull("attachments")) {
            ObjectNode attachments = (ObjectNode)configNode.get("attachments");
            if (this.bulkAttachments.isObject()) {
                Iterator it = this.bulkAttachments.fields();
                while (it.hasNext()) {
                    Map.Entry e = (Map.Entry)it.next();
                    String key = (String)e.getKey();
                    JsonNode bulkAttachment = (JsonNode)e.getValue();
                    if (attachments.hasNonNull(key)) continue;
                    attachments.set(key, bulkAttachment);
                }
            }
        } else if (this.bulkAttachments.isObject()) {
            configNode.set("attachments", this.bulkAttachments);
        }
        if (!configNode.hasNonNull("criticality") && !this.bulkCriticality.isMissingNode()) {
            configNode.put("criticality", this.bulkCriticality.asText());
        }
        if (!this.bulkMatcher.isMissingNode()) {
            ObjectNode match;
            if (configNode.path("old").isTextual()) {
                match = JsonNodeFactory.instance.objectNode();
                match.put("matcher", this.bulkMatcher.asText());
                match.put("match", configNode.get("old").asText());
                configNode.set("old", (JsonNode)match);
            }
            if (configNode.path("new").isTextual()) {
                match = JsonNodeFactory.instance.objectNode();
                match.put("matcher", this.bulkMatcher.asText());
                match.put("match", configNode.get("new").asText());
                configNode.set("new", (JsonNode)match);
            }
        }
        return new DifferenceRecipe((JsonNode)configNode, this.analysisContext);
    }

    public void close() {
    }

    @Override
    protected JsonNode getRecipesConfigurationAndInitialize() {
        JsonNode configNode = this.analysisContext.getConfigurationNode();
        this.bulkClassify = configNode.path("classify");
        this.bulkIgnore = configNode.path("ignore");
        this.bulkJustification = configNode.path("justification");
        this.bulkAttachments = configNode.path("attachments");
        this.bulkCriticality = configNode.path("criticality");
        this.bulkMatcher = configNode.path("matcher");
        return configNode.path("differences");
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/differences-schema.json"), StandardCharsets.UTF_8);
    }

    public static class DifferenceRecipe
    extends DifferenceMatchRecipe {
        protected final boolean ignore;
        protected final String justification;
        protected final Map<CompatibilityType, DifferenceSeverity> classification;
        protected final Map<String, String> newAttachments;
        protected final Criticality criticality;

        public DifferenceRecipe(JsonNode config, AnalysisContext ctx) {
            super(ctx.getMatchers(), config, "classify", "ignore", "justification", "attachments", "criticality");
            this.ignore = config.path("ignore").asBoolean(false);
            this.justification = config.path("justification").asText(null);
            this.classification = DifferencesTransform.parseClassification(config.path("classify"));
            if (config.hasNonNull("attachments")) {
                JsonNode attachments = config.get("attachments");
                this.newAttachments = new HashMap<String, String>();
                attachments.fields().forEachRemaining(e -> this.newAttachments.put((String)e.getKey(), ((JsonNode)e.getValue()).asText(null)));
            } else {
                this.newAttachments = Collections.emptyMap();
            }
            if (config.hasNonNull("criticality")) {
                String name = config.path("criticality").asText();
                this.criticality = ctx.getCriticalityByName(name);
                if (this.criticality == null) {
                    throw new IllegalArgumentException("Unknown criticality '" + name + "'.");
                }
            } else {
                this.criticality = null;
            }
        }

        @Override
        protected <E extends Element<E>> MatchingProgress<E> createMatchingProgress(@Nullable TreeFilter<E> oldFilter, @Nullable TreeFilter<E> newFilter) {
            return new MatchingProgress<E>(this.regex, this.code, this.codeRegex, oldFilter, newFilter, this.attachments, this.attachmentRegexes){

                @Override
                @Nullable
                public Difference transformMatching(Difference difference, Element<?> oldElement, Element<?> newElement) {
                    if (ignore) {
                        return null;
                    }
                    if (justification == null && classification.isEmpty() && newAttachments.isEmpty() && criticality == null) {
                        return difference;
                    }
                    Difference.Builder copy = Difference.copy((Difference)difference);
                    if (justification != null) {
                        copy.withJustification(justification);
                    }
                    if (criticality != null) {
                        copy.withCriticality(criticality);
                    }
                    copy.addClassifications(classification);
                    copy.addAttachments(newAttachments);
                    return copy.build();
                }
            };
        }
    }
}

